/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.utils.JFXNodeUtils;
import java.util.Set;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public class JFXListCell<T>
extends ListCell<T> {
    protected JFXRippler cellRippler = new JFXRippler((Node)this){

        @Override
        protected Node getMask() {
            Region clip = new Region();
            JFXNodeUtils.updateBackground(JFXListCell.this.getBackground(), clip);
            double width = this.control.getLayoutBounds().getWidth();
            double height = this.control.getLayoutBounds().getHeight();
            clip.resize(width, height);
            return clip;
        }

        @Override
        protected void positionControl(Node control) {
        }
    };
    protected Node cellContent;
    private Rectangle clip;
    private Timeline gapAnimation;
    private boolean playExpandAnimation = false;
    private boolean selectionChanged = false;
    private static final String DEFAULT_STYLE_CLASS = "jfx-list-cell";

    public JFXListCell() {
        this.initialize();
        this.initListeners();
    }

    private void initListeners() {
        this.listViewProperty().addListener((listObj, oldList, newList) -> {
            if (newList instanceof JFXListView) {
                JFXListView listView = (JFXListView)((Object)newList);
                listView.currentVerticalGapProperty().addListener((o, oldVal, newVal) -> {
                    this.cellRippler.rippler.setClip(null);
                    if (newVal.doubleValue() != 0.0) {
                        this.playExpandAnimation = true;
                        this.getListView().requestLayout();
                    } else {
                        double gap = this.clip.getY() * 2.0;
                        this.gapAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)240.0), new KeyValue[]{new KeyValue((WritableValue)this.translateYProperty(), (Object)(-gap / 2.0 - gap * (double)this.getIndex()), Interpolator.EASE_BOTH)})});
                        this.gapAnimation.play();
                        this.gapAnimation.setOnFinished(finish -> {
                            this.requestLayout();
                            Platform.runLater(() -> this.getListView().requestLayout());
                        });
                    }
                });
                this.selectedProperty().addListener((o, oldVal, newVal) -> {
                    if (newVal.booleanValue()) {
                        this.selectionChanged = true;
                    }
                });
            }
        });
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.cellRippler.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
        double gap = this.getGap();
        if (this.clip == null) {
            this.clip = new Rectangle(0.0, gap / 2.0, this.getWidth(), this.getHeight() - gap);
            this.setClip((Node)this.clip);
        } else {
            if (gap != 0.0) {
                if (this.playExpandAnimation || this.selectionChanged) {
                    if (this.playExpandAnimation) {
                        this.setTranslateY(-gap / 2.0 + -gap * (double)this.getIndex());
                        this.clip.setY(gap / 2.0);
                        this.clip.setHeight(this.getHeight() - gap);
                        this.gapAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)240.0), new KeyValue[]{new KeyValue((WritableValue)this.translateYProperty(), (Object)0, Interpolator.EASE_BOTH)})});
                        this.playExpandAnimation = false;
                    } else if (this.selectionChanged) {
                        this.clip.setY(0.0);
                        this.clip.setHeight(this.getHeight());
                        this.gapAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)240.0), new KeyValue[]{new KeyValue((WritableValue)this.clip.yProperty(), (Object)(gap / 2.0), Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.clip.heightProperty(), (Object)(this.getHeight() - gap), Interpolator.EASE_BOTH)})});
                    }
                    this.playExpandAnimation = false;
                    this.selectionChanged = false;
                    this.gapAnimation.play();
                } else {
                    if (this.gapAnimation != null) {
                        this.gapAnimation.stop();
                    }
                    this.setTranslateY(0.0);
                    this.clip.setY(gap / 2.0);
                    this.clip.setHeight(this.getHeight() - gap);
                }
            } else {
                this.setTranslateY(0.0);
                this.clip.setY(0.0);
                this.clip.setHeight(this.getHeight());
            }
            this.clip.setX(0.0);
            this.clip.setWidth(this.getWidth());
        }
        if (!this.getChildren().contains((Object)this.cellRippler)) {
            this.makeChildrenTransparent();
            this.getChildren().add(0, (Object)this.cellRippler);
            this.cellRippler.rippler.clear();
        }
    }

    protected void makeChildrenTransparent() {
        for (Node child : this.getChildren()) {
            if (child instanceof Label) {
                Set texts = child.lookupAll("Text");
                for (Node text : texts) {
                    text.setMouseTransparent(true);
                }
                continue;
            }
            if (!(child instanceof Shape)) continue;
            child.setMouseTransparent(true);
        }
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
            this.setMouseTransparent(true);
            this.setStyle("-fx-background-color:TRANSPARENT;");
        } else {
            JFXListView listView;
            Node currentNode;
            this.setMouseTransparent(false);
            this.setStyle(null);
            if (item instanceof Node) {
                Node newNode = (Node)item;
                this.setText(null);
                currentNode = this.getGraphic();
                if (currentNode == null || !currentNode.equals(newNode)) {
                    this.cellContent = newNode;
                    this.cellRippler.rippler.cacheRippleClip(false);
                    if (newNode instanceof JFXRippler) {
                        JFXRippler newRippler = (JFXRippler)newNode;
                        this.cellRippler.ripplerFillProperty().bind(newRippler.ripplerFillProperty());
                        this.cellRippler.maskTypeProperty().bind(newRippler.maskTypeProperty());
                        this.cellRippler.positionProperty().bind(newRippler.positionProperty());
                        this.cellContent = newRippler.getControl();
                    }
                    ((Region)this.cellContent).setMaxHeight(this.cellContent.prefHeight(-1.0));
                    this.setGraphic(this.cellContent);
                }
            } else {
                this.setText(item == null ? "null" : item.toString());
                this.setGraphic(null);
            }
            currentNode = this.getListView();
            if (currentNode instanceof JFXListView && (listView = (JFXListView)currentNode).isShowTooltip()) {
                if (item instanceof Label) {
                    Label label = (Label)item;
                    this.setTooltip(new Tooltip(label.getText()));
                } else if (this.getText() != null) {
                    this.setTooltip(new Tooltip(this.getText()));
                }
            }
        }
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setPadding(new Insets(8.0, 12.0, 8.0, 12.0));
    }

    protected double computePrefHeight(double width) {
        double gap = this.getGap();
        return super.computePrefHeight(width) + gap;
    }

    private double getGap() {
        JFXListView listView;
        ListView listView2 = this.getListView();
        return listView2 instanceof JFXListView ? ((listView = (JFXListView)listView2).isExpanded().booleanValue() ? listView.currentVerticalGapProperty().get() : 0.0) : 0.0;
    }
}

