/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXListCell;
import com.jfoenix.skins.JFXListViewSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.SizeConverter;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;

public class JFXListView<T>
extends ListView<T> {
    private IntegerProperty depth;
    private DoubleProperty currentVerticalGap;
    private BooleanProperty showTooltip;
    private static final String DEFAULT_STYLE_CLASS = "jfx-list-view";
    private StyleableDoubleProperty verticalGap;
    private StyleableBooleanProperty expanded;

    public JFXListView() {
        this.setCellFactory(listView -> new JFXListCell());
        this.initialize();
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXListViewSkin(this);
    }

    public IntegerProperty depthProperty() {
        if (this.depth == null) {
            this.depth = new SimpleIntegerProperty((Object)this, "depth", 0);
        }
        return this.depth;
    }

    public int getDepth() {
        return this.depth != null ? this.depth.get() : 0;
    }

    public void setDepth(int depth) {
        this.depthProperty().set(depth);
    }

    DoubleProperty currentVerticalGapProperty() {
        if (this.currentVerticalGap == null) {
            this.currentVerticalGap = new SimpleDoubleProperty((Object)this, "currentVerticalGap");
        }
        return this.currentVerticalGap;
    }

    private void updateVerticalGap() {
        if (this.isExpanded().booleanValue()) {
            this.currentVerticalGapProperty().set(this.verticalGap.get());
        } else {
            this.currentVerticalGapProperty().set(0.0);
        }
    }

    public final BooleanProperty showTooltipProperty() {
        if (this.showTooltip == null) {
            this.showTooltip = new SimpleBooleanProperty((Object)this, "showTooltip", false);
        }
        return this.showTooltip;
    }

    public final boolean isShowTooltip() {
        return this.showTooltip != null && this.showTooltip.get();
    }

    public final void setShowTooltip(boolean showTooltip) {
        this.showTooltipProperty().set(showTooltip);
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public void propagateMouseEventsToParent() {
        this.addEventHandler(MouseEvent.ANY, e -> {
            e.consume();
            this.getParent().fireEvent(e);
        });
    }

    public StyleableDoubleProperty verticalGapProperty() {
        if (this.verticalGap == null) {
            this.verticalGap = new StyleableDoubleProperty(0.0){

                public Object getBean() {
                    return JFXListView.this;
                }

                public String getName() {
                    return "verticalGap";
                }

                public CssMetaData<? extends Styleable, Number> getCssMetaData() {
                    return StyleableProperties.VERTICAL_GAP;
                }

                protected void invalidated() {
                    JFXListView.this.updateVerticalGap();
                }
            };
        }
        return this.verticalGap;
    }

    public Double getVerticalGap() {
        return this.verticalGap == null ? 0.0 : this.verticalGap.get();
    }

    public void setVerticalGap(Double gap) {
        this.verticalGapProperty().set(gap.doubleValue());
    }

    public StyleableBooleanProperty expandedProperty() {
        if (this.expanded == null) {
            this.expanded = new StyleableBooleanProperty(false){

                public Object getBean() {
                    return JFXListView.this;
                }

                public String getName() {
                    return "expanded";
                }

                public CssMetaData<? extends Styleable, Boolean> getCssMetaData() {
                    return StyleableProperties.EXPANDED;
                }

                protected void invalidated() {
                    JFXListView.this.updateVerticalGap();
                }
            };
        }
        return this.expanded;
    }

    public Boolean isExpanded() {
        return this.expanded != null && this.expanded.get();
    }

    public void setExpanded(Boolean expanded) {
        this.expandedProperty().set(expanded.booleanValue());
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXListView.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static final class StyleableProperties {
        private static final CssMetaData<JFXListView<?>, Number> VERTICAL_GAP = new CssMetaData<JFXListView<?>, Number>("-jfx-vertical-gap", SizeConverter.getInstance(), 0){

            public boolean isSettable(JFXListView<?> control) {
                return control.verticalGap == null || !control.verticalGap.isBound();
            }

            public StyleableDoubleProperty getStyleableProperty(JFXListView<?> control) {
                return control.verticalGapProperty();
            }
        };
        private static final CssMetaData<JFXListView<?>, Boolean> EXPANDED = new CssMetaData<JFXListView<?>, Boolean>("-jfx-expanded", BooleanConverter.getInstance(), false){

            public boolean isSettable(JFXListView<?> control) {
                return control.getHeight() == 0.0 && (control.expanded == null || !control.expanded.isBound());
            }

            public StyleableBooleanProperty getStyleableProperty(JFXListView<?> control) {
                return control.expandedProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(ListView.getClassCssMetaData());
            Collections.addAll(styleables, VERTICAL_GAP, EXPANDED);
            CHILD_STYLEABLES = List.copyOf(styleables);
        }
    }
}

