/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.skins.JFXSpinnerSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.converter.SizeConverter;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Skin;

public class JFXSpinner
extends ProgressIndicator {
    public static final double INDETERMINATE_PROGRESS = -1.0;
    private static final String DEFAULT_STYLE_CLASS = "jfx-spinner";
    private static final double DEFAULT_RADIUS = 12.0;
    private StyleableDoubleProperty radius;
    private StyleableDoubleProperty startingAngle;

    public JFXSpinner() {
        this(-1.0);
    }

    public JFXSpinner(double progress) {
        super(progress);
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXSpinnerSkin(this);
    }

    public final StyleableDoubleProperty radiusProperty() {
        if (this.radius == null) {
            this.radius = new SimpleStyleableDoubleProperty(StyleableProperties.RADIUS, (Object)this, "radius", Double.valueOf(12.0));
        }
        return this.radius;
    }

    public final double getRadius() {
        return this.radius != null ? this.radius.get() : 12.0;
    }

    public final void setRadius(double radius) {
        this.radiusProperty().set(radius);
    }

    public final StyleableDoubleProperty startingAngleProperty() {
        if (this.startingAngle == null) {
            this.startingAngle = new SimpleStyleableDoubleProperty(StyleableProperties.STARTING_ANGLE, (Object)this, "startingAngle", Double.valueOf(0.0));
        }
        return this.startingAngle;
    }

    public final double getStartingAngle() {
        return this.startingAngle != null ? this.startingAngle.get() : 0.0;
    }

    public final void setStartingAngle(double startingAngle) {
        this.startingAngleProperty().set(startingAngle);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXSpinner.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static final class StyleableProperties {
        private static final CssMetaData<JFXSpinner, Number> RADIUS = new CssMetaData<JFXSpinner, Number>("-jfx-radius", SizeConverter.getInstance(), (Number)12.0){

            public boolean isSettable(JFXSpinner control) {
                return control.radius == null || !control.radius.isBound();
            }

            public StyleableDoubleProperty getStyleableProperty(JFXSpinner control) {
                return control.radius;
            }
        };
        private static final CssMetaData<JFXSpinner, Number> STARTING_ANGLE = new CssMetaData<JFXSpinner, Number>("-jfx-starting-angle", SizeConverter.getInstance(), (Number)0.0){

            public boolean isSettable(JFXSpinner control) {
                return control.startingAngle == null || !control.startingAngle.isBound();
            }

            public StyleableDoubleProperty getStyleableProperty(JFXSpinner control) {
                return control.startingAngle;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(ProgressIndicator.getClassCssMetaData());
            Collections.addAll(styleables, RADIUS, STARTING_ANGLE);
            CHILD_STYLEABLES = List.copyOf(styleables);
        }
    }
}

