/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.utils;

import com.jfoenix.utils.JFXNodeUtils;
import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Window;

public class TreeShowingProperty
extends ReadOnlyBooleanPropertyBase {
    private final ChangeListener<Boolean> windowShowingChangedListener = (obs, old, current) -> this.updateTreeShowing();
    private final ChangeListener<Window> sceneWindowChangedListener = (obs, old, current) -> this.windowChanged((Window)old, (Window)current);
    private final ChangeListener<Scene> nodeSceneChangedListener = (obs, old, current) -> this.sceneChanged((Scene)old, (Scene)current);
    private final Node node;
    private final ObservableBooleanValue treeVisibleProperty;
    private boolean valid;
    private boolean treeShowing;

    public TreeShowingProperty(Node node) {
        this.node = node;
        this.treeVisibleProperty = JFXNodeUtils.treeVisibleProperty(node);
        this.node.sceneProperty().addListener(this.nodeSceneChangedListener);
        this.treeVisibleProperty.addListener(this.windowShowingChangedListener);
        this.sceneChanged(null, node.getScene());
    }

    public Object getBean() {
        return this.node;
    }

    public String getName() {
        return "treeShowing";
    }

    public void dispose() {
        this.node.sceneProperty().removeListener(this.nodeSceneChangedListener);
        if (this.treeVisibleProperty != null) {
            this.treeVisibleProperty.removeListener(this.windowShowingChangedListener);
        }
        this.valid = false;
        this.sceneChanged(this.node.getScene(), null);
    }

    protected void invalidate() {
        if (this.valid) {
            this.valid = false;
            this.fireValueChangedEvent();
        }
    }

    public boolean get() {
        if (!this.valid) {
            this.updateTreeShowing();
            this.valid = true;
        }
        return this.treeShowing;
    }

    private void sceneChanged(Scene oldScene, Scene newScene) {
        if (oldScene != null) {
            oldScene.windowProperty().removeListener(this.sceneWindowChangedListener);
        }
        if (newScene != null) {
            newScene.windowProperty().addListener(this.sceneWindowChangedListener);
        }
        this.windowChanged(oldScene == null ? null : oldScene.getWindow(), newScene == null ? null : newScene.getWindow());
    }

    private void windowChanged(Window oldWindow, Window newWindow) {
        if (oldWindow != null) {
            oldWindow.showingProperty().removeListener(this.windowShowingChangedListener);
        }
        if (newWindow != null) {
            newWindow.showingProperty().addListener(this.windowShowingChangedListener);
        }
        this.updateTreeShowing();
    }

    private void updateTreeShowing() {
        boolean newValue = JFXNodeUtils.isTreeShowing(this.node);
        if (newValue != this.treeShowing) {
            this.treeShowing = newValue;
            this.invalidate();
        }
    }
}

