/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.theme;

import com.sun.jna.Pointer;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.glavo.monetfx.Brightness;
import org.glavo.monetfx.ColorScheme;
import org.glavo.monetfx.Contrast;
import org.glavo.monetfx.beans.property.ColorSchemeProperty;
import org.glavo.monetfx.beans.property.ReadOnlyColorSchemeProperty;
import org.glavo.monetfx.beans.property.SimpleColorSchemeProperty;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.theme.Theme;
import org.jackhuang.hmcl.theme.ThemeColor;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.WindowsNativeUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.NativeUtils;
import org.jackhuang.hmcl.util.platform.OSVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.SystemUtils;
import org.jackhuang.hmcl.util.platform.windows.Dwmapi;
import org.jackhuang.hmcl.util.platform.windows.WinReg;
import org.jackhuang.hmcl.util.platform.windows.WinTypes;

public final class Themes {
    private static final ObjectExpression<Theme> theme = new ObjectBinding<Theme>(){
        {
            ArrayList<Object> observables = new ArrayList<Object>();
            observables.add(ConfigHolder.config().themeBrightnessProperty());
            observables.add(ConfigHolder.config().themeColorProperty());
            if (FXUtils.DARK_MODE != null) {
                observables.add(FXUtils.DARK_MODE);
            }
            this.bind(observables.toArray(new Observable[0]));
        }

        private Brightness getBrightness() {
            String themeBrightness = ConfigHolder.config().getThemeBrightness();
            if (themeBrightness == null) {
                return Brightness.DEFAULT;
            }
            return switch (themeBrightness.toLowerCase(Locale.ROOT).trim()) {
                case "auto" -> {
                    if (FXUtils.DARK_MODE != null) {
                        if (FXUtils.DARK_MODE.get()) {
                            yield Brightness.DARK;
                        }
                        yield Brightness.LIGHT;
                    }
                    yield Themes.getDefaultBrightness();
                }
                case "dark" -> Brightness.DARK;
                case "light" -> Brightness.LIGHT;
                default -> Brightness.DEFAULT;
            };
        }

        protected Theme computeValue() {
            ThemeColor themeColor = Objects.requireNonNullElse(ConfigHolder.config().getThemeColor(), ThemeColor.DEFAULT);
            return new Theme(themeColor, this.getBrightness(), Theme.DEFAULT.colorStyle(), Contrast.DEFAULT);
        }
    };
    private static final ColorSchemeProperty colorScheme = new SimpleColorSchemeProperty();
    private static final BooleanBinding darkMode = Bindings.createBooleanBinding(() -> ((ColorScheme)colorScheme.get()).getBrightness() == Brightness.DARK, (Observable[])new Observable[]{colorScheme});
    private static Brightness defaultBrightness;
    private static final ObjectBinding<Color> titleFill;

    private static Brightness getDefaultBrightness() {
        Path dbusSend;
        if (defaultBrightness != null) {
            return defaultBrightness;
        }
        Logger.LOG.info("Detecting system theme brightness");
        Brightness brightness = Brightness.DEFAULT;
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
            Object appsUseLightTheme;
            WinReg reg = WinReg.INSTANCE;
            if (reg != null && (appsUseLightTheme = reg.queryValue(WinReg.HKEY.HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize", "AppsUseLightTheme")) instanceof Integer) {
                Integer value = (Integer)appsUseLightTheme;
                brightness = value == 0 ? Brightness.DARK : Brightness.LIGHT;
            }
        } else if (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS) {
            try {
                String result = SystemUtils.run("/usr/bin/defaults", "read", "-g", "AppleInterfaceStyle").trim();
                brightness = "Dark".equalsIgnoreCase(result) ? Brightness.DARK : Brightness.LIGHT;
            }
            catch (Exception e) {
                brightness = Brightness.LIGHT;
            }
        } else if (OperatingSystem.CURRENT_OS == OperatingSystem.LINUX && (dbusSend = SystemUtils.which("dbus-send")) != null) {
            try {
                String[] result = SystemUtils.run(List.of(FileUtils.getAbsolutePath(dbusSend), "--session", "--print-reply=literal", "--reply-timeout=1000", "--dest=org.freedesktop.portal.Desktop", "/org/freedesktop/portal/desktop", "org.freedesktop.portal.Settings.Read", "string:org.freedesktop.appearance", "string:color-scheme"), Duration.ofSeconds(2L)).trim().split(" ");
                if (result.length > 0) {
                    String value = result[result.length - 1];
                    if ("1".equals(value)) {
                        brightness = Brightness.DARK;
                    } else if ("2".equals(value)) {
                        brightness = Brightness.LIGHT;
                    }
                }
            }
            catch (Exception e) {
                Logger.LOG.warning("Failed to get system theme from D-Bus", e);
            }
        }
        Logger.LOG.info("Detected system theme brightness: " + String.valueOf((Object)brightness));
        defaultBrightness = brightness;
        return defaultBrightness;
    }

    public static ObjectExpression<Theme> themeProperty() {
        return theme;
    }

    public static Theme getTheme() {
        return (Theme)Themes.themeProperty().get();
    }

    public static ReadOnlyColorSchemeProperty colorSchemeProperty() {
        return colorScheme;
    }

    public static ColorScheme getColorScheme() {
        return (ColorScheme)colorScheme.get();
    }

    public static ObservableValue<Color> titleFillProperty() {
        return titleFill;
    }

    public static BooleanBinding darkModeProperty() {
        return darkMode;
    }

    public static void applyNativeDarkMode(final Stage stage) {
        if (OperatingSystem.SYSTEM_VERSION.isAtLeast(OSVersion.WINDOWS_11) && NativeUtils.USE_JNA && Dwmapi.INSTANCE != null) {
            final ChangeListener<Boolean> listener = FXUtils.onWeakChange(Themes.darkModeProperty(), darkMode -> {
                if (stage.isShowing()) {
                    WindowsNativeUtils.getWindowHandle(stage).ifPresent(handle -> {
                        if (handle == WinTypes.HANDLE.INVALID_VALUE) {
                            return;
                        }
                        Dwmapi.INSTANCE.DwmSetWindowAttribute(new WinTypes.HANDLE(Pointer.createConstant(handle)), 20, new WinTypes.BOOLByReference(new WinTypes.BOOL((boolean)darkMode)), 4);
                    });
                }
            });
            stage.getProperties().put((Object)"Themes.applyNativeDarkMode.listener", listener);
            if (stage.isShowing()) {
                listener.changed(null, (Object)false, (Object)Themes.darkModeProperty().get());
            } else {
                stage.addEventFilter(WindowEvent.WINDOW_SHOWN, (EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        stage.removeEventFilter(WindowEvent.WINDOW_SHOWN, (EventHandler)this);
                        listener.changed(null, (Object)false, (Object)Themes.darkModeProperty().get());
                    }
                });
            }
        }
    }

    private Themes() {
    }

    static {
        ChangeListener listener = (observable, oldValue, newValue) -> {
            if (!Objects.equals(oldValue, newValue)) {
                colorScheme.set(newValue != null ? newValue.toColorScheme() : Theme.DEFAULT.toColorScheme());
            }
        };
        listener.changed(theme, null, (Object)((Theme)theme.get()));
        theme.addListener(listener);
        titleFill = Bindings.createObjectBinding(() -> ConfigHolder.config().isTitleTransparent() ? Themes.getColorScheme().getOnSurface() : Themes.getColorScheme().getOnPrimaryContainer(), (Observable[])new Observable[]{Themes.colorSchemeProperty(), ConfigHolder.config().titleTransparentProperty()});
    }
}

