/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.event.EventManager;
import org.jackhuang.hmcl.event.EventPriority;
import org.jackhuang.hmcl.ui.FXUtils;

public final class WeakListenerHolder {
    private final List<Object> refs = new ArrayList<Object>(0);

    public WeakInvalidationListener weak(InvalidationListener listener) {
        this.refs.add(listener);
        return new WeakInvalidationListener(listener);
    }

    public <T> WeakChangeListener<T> weak(ChangeListener<T> listener) {
        this.refs.add(listener);
        return new WeakChangeListener(listener);
    }

    public <T> WeakListChangeListener<T> weak(ListChangeListener<T> listener) {
        this.refs.add(listener);
        return new WeakListChangeListener(listener);
    }

    public <T extends Event> void registerWeak(EventManager<T> manager, Consumer<T> consumer) {
        this.refs.add(manager.registerWeak(consumer));
    }

    public <T extends Event> void registerWeak(EventManager<T> manager, Consumer<T> consumer, EventPriority priority) {
        this.refs.add(manager.registerWeak(consumer, priority));
    }

    public <T> void onWeakChange(ObservableValue<T> value, Consumer<T> consumer) {
        this.refs.add(FXUtils.onWeakChange(value, consumer));
    }

    public <T> void onWeakChangeAndOperate(ObservableValue<T> value, Consumer<T> consumer) {
        this.refs.add(FXUtils.onWeakChangeAndOperate(value, consumer));
    }

    public void add(Object obj) {
        this.refs.add(obj);
    }

    public boolean remove(Object obj) {
        return this.refs.remove(obj);
    }

    public void clear() {
        this.refs.clear();
    }
}

