/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXSpinner;
import io.nayuki.qrcodegen.QrCode;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.SVGPath;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.OAuth;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftAccount;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.theme.Themes;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.construct.DialogAware;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.upgrade.IntegrityChecker;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.QrCodeUtils;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;

public class MicrosoftAccountLoginPane
extends JFXDialogLayout
implements DialogAware {
    private final Account accountToRelogin;
    private final Consumer<AuthInfo> loginCallback;
    private final Runnable cancelCallback;
    private final WeakListenerHolder holder = new WeakListenerHolder();
    private final ObjectProperty<Step> step = new SimpleObjectProperty();
    private TaskExecutor browserTaskExecutor;
    private TaskExecutor deviceTaskExecutor;
    private final JFXButton btnLogin;
    private final SpinnerPane loginButtonSpinner;

    public MicrosoftAccountLoginPane() {
        this(false);
    }

    public MicrosoftAccountLoginPane(boolean bodyonly) {
        this(null, null, null, bodyonly);
    }

    public MicrosoftAccountLoginPane(Account account, Consumer<AuthInfo> callback, Runnable onCancel, boolean bodyonly) {
        this.accountToRelogin = account;
        this.loginCallback = callback;
        this.cancelCallback = onCancel;
        this.getStyleClass().add((Object)"microsoft-login-dialog");
        if (bodyonly) {
            this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"bodyonly"), true);
        } else {
            Label heading = new Label(this.accountToRelogin != null ? I18n.i18n("account.login.refresh") : I18n.i18n("account.create.microsoft"));
            heading.getStyleClass().add((Object)"header-label");
            this.setHeading(new Node[]{heading});
        }
        this.setMaxWidth(650.0);
        FXUtils.onEscPressed((Node)this, this::onCancel);
        this.btnLogin = new JFXButton(I18n.i18n("account.login"));
        this.btnLogin.getStyleClass().add((Object)"dialog-accept");
        this.loginButtonSpinner = new SpinnerPane();
        this.loginButtonSpinner.getStyleClass().add((Object)"small-spinner-pane");
        this.loginButtonSpinner.setContent((Node)this.btnLogin);
        JFXButton btnCancel = new JFXButton(I18n.i18n("button.cancel"));
        btnCancel.getStyleClass().add((Object)"dialog-cancel");
        btnCancel.setOnAction(e -> this.onCancel());
        this.setActions(new Node[]{this.loginButtonSpinner, btnCancel});
        this.holder.registerWeak(Accounts.OAUTH_CALLBACK.onOpenBrowserAuthorizationCode, event -> Platform.runLater(() -> {
            if (this.step.get() instanceof Step.StartAuthorizationCodeLogin) {
                this.step.set((Object)new Step.WaitForOpenBrowser(event.getUrl()));
            }
        }));
        this.holder.registerWeak(Accounts.OAUTH_CALLBACK.onGrantDeviceCode, event -> Platform.runLater(() -> {
            if (this.step.get() instanceof Step.StartDeviceCodeLogin) {
                this.step.set((Object)new Step.WaitForScanQrCode(event.getUserCode(), event.getVerificationUri()));
            }
        }));
        this.step.set((Object)(Accounts.OAUTH_CALLBACK.getClientId().isEmpty() ? new Step.Init() : new Step.StartAuthorizationCodeLogin()));
        FXUtils.onChangeAndOperate(this.step, this::onStep);
    }

    private void onStep(Step currentStep) {
        VBox rootContainer = new VBox(10.0);
        this.setBody(new Node[]{rootContainer});
        rootContainer.setAlignment(Pos.TOP_CENTER);
        if (Accounts.OAUTH_CALLBACK.getClientId().isEmpty()) {
            HintPane snapshotHint = new HintPane(MessageDialogPane.MessageType.WARNING);
            snapshotHint.setSegment(I18n.i18n("account.methods.microsoft.snapshot"));
            rootContainer.getChildren().add((Object)snapshotHint);
            this.btnLogin.setDisable(true);
            this.loginButtonSpinner.setLoading(false);
            return;
        }
        if (!IntegrityChecker.isOfficial()) {
            HintPane unofficialHintPane = new HintPane(MessageDialogPane.MessageType.WARNING);
            unofficialHintPane.setSegment(I18n.i18n("unofficial.hint"));
            rootContainer.getChildren().add((Object)unofficialHintPane);
        }
        if (currentStep instanceof Step.Init) {
            this.btnLogin.setOnAction(e -> this.step.set((Object)new Step.StartAuthorizationCodeLogin()));
            this.loginButtonSpinner.setLoading(false);
            HintPane hintPane = new HintPane(MessageDialogPane.MessageType.INFO);
            hintPane.setText(I18n.i18n("account.methods.microsoft.hint"));
            rootContainer.getChildren().add((Object)hintPane);
        } else if (currentStep instanceof Step.StartAuthorizationCodeLogin) {
            this.loginButtonSpinner.setLoading(false);
            this.cancelAllTasks();
            rootContainer.getChildren().add((Object)new JFXSpinner());
            this.browserTaskExecutor = Task.supplyAsync(() -> Accounts.FACTORY_MICROSOFT.create(null, null, null, null, (Object)OAuth.GrantFlow.AUTHORIZATION_CODE)).whenComplete(Schedulers.javafx(), this::onLoginCompleted).executor(true);
        } else if (currentStep instanceof Step.StartDeviceCodeLogin) {
            this.loginButtonSpinner.setLoading(true);
            this.cancelAllTasks();
            rootContainer.getChildren().add((Object)new JFXSpinner());
            this.deviceTaskExecutor = Task.supplyAsync(() -> Accounts.FACTORY_MICROSOFT.create(null, null, null, null, (Object)OAuth.GrantFlow.DEVICE)).whenComplete(Schedulers.javafx(), this::onLoginCompleted).executor(true);
        } else if (currentStep instanceof Step.WaitForOpenBrowser) {
            Step.WaitForOpenBrowser wait = (Step.WaitForOpenBrowser)currentStep;
            this.btnLogin.setOnAction(e -> {
                FXUtils.openLink(wait.url());
                this.loginButtonSpinner.setLoading(true);
            });
            this.loginButtonSpinner.setLoading(false);
            HintPane hintPane = new HintPane(MessageDialogPane.MessageType.INFO);
            hintPane.setSegment(I18n.i18n("account.methods.microsoft.methods.browser.hint", StringUtils.escapeXmlAttribute(wait.url()), wait.url()), FXUtils::copyText);
            rootContainer.getChildren().add((Object)hintPane);
        } else if (currentStep instanceof Step.WaitForScanQrCode) {
            Step.WaitForScanQrCode wait = (Step.WaitForScanQrCode)currentStep;
            this.loginButtonSpinner.setLoading(true);
            HintPane deviceHint = new HintPane(MessageDialogPane.MessageType.INFO);
            deviceHint.setSegment(I18n.i18n("account.methods.microsoft.methods.device.hint", StringUtils.escapeXmlAttribute(wait.verificationUri()), wait.verificationUri(), wait.userCode()));
            SVGPath qrCode = new SVGPath();
            qrCode.fillProperty().bind(Themes.colorSchemeProperty().getPrimary());
            qrCode.setContent(QrCodeUtils.toSVGPath(QrCode.encodeText(wait.verificationUri() + "?otc=" + wait.userCode(), QrCode.Ecc.MEDIUM)));
            qrCode.setScaleX(3.0);
            qrCode.setScaleY(3.0);
            Label lblCode = new Label(wait.userCode());
            lblCode.getStyleClass().add((Object)"code-label");
            lblCode.setStyle("-fx-font-family: \"" + Lang.requireNonNullElse(ConfigHolder.config().getFontFamily(), FXUtils.DEFAULT_MONOSPACE_FONT) + "\";");
            StackPane codeBox = new StackPane(new Node[]{lblCode});
            codeBox.getStyleClass().add((Object)"code-box");
            codeBox.setCursor(Cursor.HAND);
            FXUtils.onClicked((Node)codeBox, () -> FXUtils.copyText(wait.userCode()));
            codeBox.setMaxWidth(Double.NEGATIVE_INFINITY);
            rootContainer.getChildren().addAll((Object[])new Node[]{deviceHint, new Group(new Node[]{qrCode}), codeBox});
        } else if (currentStep instanceof Step.LoginFailed) {
            Step.LoginFailed failed = (Step.LoginFailed)currentStep;
            this.btnLogin.setOnAction(e -> this.step.set((Object)new Step.StartAuthorizationCodeLogin()));
            this.loginButtonSpinner.setLoading(false);
            this.cancelAllTasks();
            HintPane errHintPane = new HintPane(MessageDialogPane.MessageType.ERROR);
            errHintPane.setSegment(failed.message());
            rootContainer.getChildren().add((Object)errHintPane);
        }
        FlowPane linkBox = new FlowPane(8.0, 8.0);
        linkBox.setAlignment(Pos.CENTER_LEFT);
        linkBox.setPrefWrapLength(500.0);
        if (currentStep instanceof Step.Init || currentStep instanceof Step.StartAuthorizationCodeLogin || currentStep instanceof Step.WaitForOpenBrowser) {
            JFXHyperlink useQrCode = new JFXHyperlink(I18n.i18n("account.methods.microsoft.methods.device"));
            useQrCode.setOnAction(e -> this.step.set((Object)new Step.StartDeviceCodeLogin()));
            linkBox.getChildren().add((Object)useQrCode);
        } else if (currentStep instanceof Step.StartDeviceCodeLogin || currentStep instanceof Step.WaitForScanQrCode) {
            JFXHyperlink userBrowser = new JFXHyperlink(I18n.i18n("account.methods.microsoft.methods.browser"));
            userBrowser.setOnAction(e -> this.step.set((Object)new Step.StartAuthorizationCodeLogin()));
            linkBox.getChildren().add((Object)userBrowser);
        }
        JFXHyperlink profileLink = new JFXHyperlink(I18n.i18n("account.methods.microsoft.profile"));
        profileLink.setExternalLink("https://account.live.com/editprof.aspx");
        JFXHyperlink purchaseLink = new JFXHyperlink(I18n.i18n("account.methods.microsoft.purchase"));
        purchaseLink.setExternalLink("https://www.xbox.com/games/store/minecraft-java-bedrock-edition-for-pc/9nxp44l49shj");
        linkBox.getChildren().addAll((Object[])new Node[]{profileLink, purchaseLink});
        rootContainer.getChildren().add((Object)linkBox);
        this.setBody(new Node[]{rootContainer});
    }

    private void cancelAllTasks() {
        if (this.browserTaskExecutor != null) {
            this.browserTaskExecutor.cancel();
        }
        if (this.deviceTaskExecutor != null) {
            this.deviceTaskExecutor.cancel();
        }
    }

    private void onCancel() {
        this.cancelAllTasks();
        if (this.cancelCallback != null) {
            this.cancelCallback.run();
        }
        this.fireEvent(new DialogCloseEvent());
    }

    private void onLoginCompleted(MicrosoftAccount account, Exception exception) {
        if (exception == null) {
            int oldIndex;
            if (this.accountToRelogin != null) {
                Accounts.getAccounts().remove((Object)this.accountToRelogin);
            }
            if ((oldIndex = Accounts.getAccounts().indexOf((Object)account)) == -1) {
                Accounts.getAccounts().add((Object)account);
            } else {
                Accounts.getAccounts().remove(oldIndex);
                Accounts.getAccounts().add(oldIndex, (Object)account);
            }
            Accounts.setSelectedAccount(account);
            if (this.loginCallback != null) {
                try {
                    this.loginCallback.accept(account.logIn());
                }
                catch (AuthenticationException e) {
                    this.step.set((Object)new Step.LoginFailed(Accounts.localizeErrorMessage(e)));
                    return;
                }
            }
            this.fireEvent(new DialogCloseEvent());
        } else if (!(exception instanceof CancellationException)) {
            this.step.set((Object)new Step.LoginFailed(Accounts.localizeErrorMessage(exception)));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface Step {

        public record LoginFailed(String message) implements Step
        {
        }

        public record WaitForScanQrCode(String userCode, String verificationUri) implements Step
        {
        }

        public static final class StartDeviceCodeLogin
        implements Step {
        }

        public record WaitForOpenBrowser(String url) implements Step
        {
        }

        public static final class StartAuthorizationCodeLogin
        implements Step {
        }

        public static final class Init
        implements Step {
        }
    }
}

