/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXProgressBar;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.WeakListener;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.download.cleanroom.CleanroomInstallTask;
import org.jackhuang.hmcl.download.fabric.FabricAPIInstallTask;
import org.jackhuang.hmcl.download.fabric.FabricInstallTask;
import org.jackhuang.hmcl.download.forge.ForgeNewInstallTask;
import org.jackhuang.hmcl.download.forge.ForgeOldInstallTask;
import org.jackhuang.hmcl.download.game.GameAssetDownloadTask;
import org.jackhuang.hmcl.download.game.GameInstallTask;
import org.jackhuang.hmcl.download.java.mojang.MojangJavaDownloadTask;
import org.jackhuang.hmcl.download.legacyfabric.LegacyFabricInstallTask;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderInstallTask;
import org.jackhuang.hmcl.download.neoforge.NeoForgeInstallTask;
import org.jackhuang.hmcl.download.neoforge.NeoForgeOldInstallTask;
import org.jackhuang.hmcl.download.optifine.OptiFineInstallTask;
import org.jackhuang.hmcl.download.quilt.QuiltAPIInstallTask;
import org.jackhuang.hmcl.download.quilt.QuiltInstallTask;
import org.jackhuang.hmcl.game.HMCLModpackInstallTask;
import org.jackhuang.hmcl.java.JavaInstallTask;
import org.jackhuang.hmcl.mod.MinecraftInstanceTask;
import org.jackhuang.hmcl.mod.ModpackInstallTask;
import org.jackhuang.hmcl.mod.ModpackUpdateTask;
import org.jackhuang.hmcl.mod.curse.CurseCompletionTask;
import org.jackhuang.hmcl.mod.curse.CurseInstallTask;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackCompletionTask;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackExportTask;
import org.jackhuang.hmcl.mod.modrinth.ModrinthCompletionTask;
import org.jackhuang.hmcl.mod.modrinth.ModrinthInstallTask;
import org.jackhuang.hmcl.mod.modrinth.ModrinthModpackExportTask;
import org.jackhuang.hmcl.mod.multimc.MultiMCModpackExportTask;
import org.jackhuang.hmcl.mod.multimc.MultiMCModpackInstallTask;
import org.jackhuang.hmcl.mod.server.ServerModpackCompletionTask;
import org.jackhuang.hmcl.mod.server.ServerModpackExportTask;
import org.jackhuang.hmcl.mod.server.ServerModpackLocalInstallTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.task.TaskListener;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jetbrains.annotations.NotNull;

public final class TaskListPane
extends StackPane {
    private static final Insets DEFAULT_PROGRESS_NODE_PADDING = new Insets(0.0, 0.0, 8.0, 0.0);
    private static final Insets STAGED_PROGRESS_NODE_PADDING = new Insets(0.0, 0.0, 8.0, 26.0);
    private TaskExecutor executor;
    private final JFXListView<Node> listView = new JFXListView();
    private final Map<Task<?>, ProgressListNode> nodes = new HashMap();
    private final Map<String, StageNode> stageNodes = new HashMap<String, StageNode>();
    private final ObjectProperty<Insets> progressNodePadding = new SimpleObjectProperty((Object)Insets.EMPTY);
    private final DoubleProperty cellWidth = new SimpleDoubleProperty();

    public TaskListPane() {
        this.listView.setPadding(new Insets(12.0, 0.0, 0.0, 0.0));
        this.listView.setCellFactory(l -> new Cell());
        this.listView.setSelectionModel(null);
        FXUtils.onChangeAndOperate(this.listView.widthProperty(), width -> {
            double w = width.doubleValue();
            this.cellWidth.set(w <= 12.0 ? w : w - 12.0);
        });
        this.getChildren().setAll((Object[])new javafx.scene.Node[]{this.listView});
    }

    private void addStagesHints(@NotNull Collection<Task.StagesHint> hints) {
        for (Task.StagesHint hint : hints) {
            StageNode node = this.stageNodes.get(hint.stage());
            if (node == null) {
                node = new StageNode(hint.stage());
                this.stageNodes.put(hint.stage(), node);
                this.listView.getItems().add((Object)node);
            }
            for (String stage : hint.aliases()) {
                this.stageNodes.put(stage, node);
            }
        }
    }

    private void updateProgressNodePadding() {
        this.progressNodePadding.set((Object)(this.stageNodes.isEmpty() ? DEFAULT_PROGRESS_NODE_PADDING : STAGED_PROGRESS_NODE_PADDING));
    }

    public void setExecutor(final TaskExecutor executor) {
        this.executor = executor;
        executor.addTaskListener(new TaskListener(){

            @Override
            public void onStart() {
                Platform.runLater(() -> {
                    TaskListPane.this.stageNodes.clear();
                    TaskListPane.this.listView.getItems().clear();
                    TaskListPane.this.addStagesHints(executor.getHints());
                    TaskListPane.this.updateProgressNodePadding();
                });
            }

            @Override
            public void onReady(Task<?> task) {
                if (task instanceof Task.StagesHintTask) {
                    Platform.runLater(() -> {
                        TaskListPane.this.addStagesHints(((Task.StagesHintTask)task).getHints());
                        TaskListPane.this.updateProgressNodePadding();
                    });
                }
                if (task.getStage() != null) {
                    Platform.runLater(() -> {
                        StageNode node = TaskListPane.this.stageNodes.get(task.getStage());
                        if (node != null) {
                            node.begin();
                        }
                    });
                }
            }

            @Override
            public void onRunning(Task<?> task) {
                if (!task.getSignificance().shouldShow() || task.getName() == null) {
                    return;
                }
                if (task instanceof GameAssetDownloadTask) {
                    task.setName(I18n.i18n("assets.download_all"));
                } else if (task instanceof GameInstallTask) {
                    if (task.getInheritedStage() != null && task.getInheritedStage().startsWith("hmcl.install.game")) {
                        return;
                    }
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.game")));
                } else if (task instanceof CleanroomInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.cleanroom")));
                } else if (task instanceof LegacyFabricInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.legacyfabric")));
                } else if (task instanceof ForgeNewInstallTask || task instanceof ForgeOldInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.forge")));
                } else if (task instanceof NeoForgeInstallTask || task instanceof NeoForgeOldInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.neoforge")));
                } else if (task instanceof LiteLoaderInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.liteloader")));
                } else if (task instanceof OptiFineInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.optifine")));
                } else if (task instanceof FabricInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.fabric")));
                } else if (task instanceof FabricAPIInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.fabric-api")));
                } else if (task instanceof QuiltInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.quilt")));
                } else if (task instanceof QuiltAPIInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.quilt-api")));
                } else if (task instanceof CurseCompletionTask || task instanceof ModrinthCompletionTask || task instanceof ServerModpackCompletionTask || task instanceof McbbsModpackCompletionTask) {
                    task.setName(I18n.i18n("modpack.completion"));
                } else if (task instanceof ModpackInstallTask) {
                    task.setName(I18n.i18n("modpack.installing"));
                } else if (task instanceof ModpackUpdateTask) {
                    task.setName(I18n.i18n("modpack.update"));
                } else if (task instanceof CurseInstallTask) {
                    task.setName(I18n.i18n("modpack.installing.given", I18n.i18n("modpack.type.curse")));
                } else if (task instanceof MultiMCModpackInstallTask) {
                    task.setName(I18n.i18n("modpack.installing.given", I18n.i18n("modpack.type.multimc")));
                } else if (task instanceof ModrinthInstallTask) {
                    task.setName(I18n.i18n("modpack.installing.given", I18n.i18n("modpack.type.modrinth")));
                } else if (task instanceof ServerModpackLocalInstallTask) {
                    task.setName(I18n.i18n("install.installing") + ": " + I18n.i18n("modpack.type.server"));
                } else if (task instanceof HMCLModpackInstallTask) {
                    task.setName(I18n.i18n("modpack.installing.given", I18n.i18n("modpack.type.hmcl")));
                } else if (task instanceof McbbsModpackExportTask || task instanceof MultiMCModpackExportTask || task instanceof ServerModpackExportTask || task instanceof ModrinthModpackExportTask) {
                    task.setName(I18n.i18n("modpack.export"));
                } else if (task instanceof MinecraftInstanceTask) {
                    task.setName(I18n.i18n("modpack.scan"));
                } else if (task instanceof MojangJavaDownloadTask) {
                    task.setName(I18n.i18n("download.java"));
                } else if (task instanceof JavaInstallTask) {
                    task.setName(I18n.i18n("java.installing"));
                }
                Platform.runLater(() -> {
                    ProgressListNode node = new ProgressListNode(task);
                    TaskListPane.this.nodes.put(task, node);
                    StageNode stageNode = TaskListPane.this.stageNodes.get(task.getInheritedStage());
                    TaskListPane.this.listView.getItems().add(TaskListPane.this.listView.getItems().indexOf((Object)stageNode) + 1, (Object)node);
                });
            }

            @Override
            public void onFinished(Task<?> task) {
                Platform.runLater(() -> {
                    ProgressListNode node;
                    StageNode stageNode;
                    if (task.getStage() != null && (stageNode = TaskListPane.this.stageNodes.get(task.getStage())) != null) {
                        stageNode.succeed();
                    }
                    if ((node = TaskListPane.this.nodes.remove(task)) != null) {
                        node.unbind();
                        TaskListPane.this.listView.getItems().remove((Object)node);
                    }
                });
            }

            @Override
            public void onFailed(Task<?> task, Throwable throwable) {
                ProgressListNode node;
                if (task.getStage() != null) {
                    Platform.runLater(() -> {
                        StageNode stageNode = TaskListPane.this.stageNodes.get(task.getStage());
                        if (stageNode != null) {
                            stageNode.fail();
                        }
                    });
                }
                if ((node = TaskListPane.this.nodes.remove(task)) != null) {
                    Platform.runLater(() -> node.setThrowable(throwable));
                }
            }

            @Override
            public void onPropertiesUpdate(Task<?> task) {
                if (task instanceof Task.CountTask) {
                    FXUtils.runInFX(() -> {
                        StageNode stageNode = TaskListPane.this.stageNodes.get(((Task.CountTask)task).getCountStage());
                        if (stageNode != null) {
                            stageNode.count();
                        }
                    });
                    return;
                }
                if (task.getStage() != null) {
                    int total = Lang.tryCast(task.getProperties().get("total"), Integer.class).orElse(0);
                    FXUtils.runInFX(() -> {
                        StageNode stageNode = TaskListPane.this.stageNodes.get(task.getStage());
                        if (stageNode != null) {
                            stageNode.addTotal(total);
                        }
                    });
                }
            }
        });
    }

    private static final class StageNode
    extends Node {
        private int runningTasksCount = 0;
        private final ObjectProperty<Status> status = new SimpleObjectProperty((Object)Status.WAITING);
        private final StringProperty title = new SimpleStringProperty();
        private final String message;
        private int count = 0;
        private int total = 0;

        private StageNode(String stage) {
            String stageValue;
            String stageKey;
            int idx = stage.indexOf(58);
            if (idx >= 0) {
                stageKey = stage.substring(0, idx);
                stageValue = stage.substring(idx + 1);
            } else {
                stageKey = stage;
                stageValue = null;
            }
            this.message = switch (stageKey) {
                case "hmcl.modpack" -> I18n.i18n("install.modpack");
                case "hmcl.modpack.download" -> I18n.i18n("launch.state.modpack");
                case "hmcl.install.assets" -> I18n.i18n("assets.download");
                case "hmcl.install.libraries" -> I18n.i18n("libraries.download");
                case "hmcl.install.game" -> I18n.i18n("install.installer.install", I18n.i18n("install.installer.game") + " " + stageValue);
                case "hmcl.install.forge" -> I18n.i18n("install.installer.install", I18n.i18n("install.installer.forge") + " " + stageValue);
                case "hmcl.install.cleanroom" -> I18n.i18n("install.installer.install", I18n.i18n("install.installer.cleanroom") + " " + stageValue);
                case "hmcl.install.neoforge" -> I18n.i18n("install.installer.install", I18n.i18n("install.installer.neoforge") + " " + stageValue);
                case "hmcl.install.liteloader" -> I18n.i18n("install.installer.install", I18n.i18n("install.installer.liteloader") + " " + stageValue);
                case "hmcl.install.optifine" -> I18n.i18n("install.installer.install", I18n.i18n("install.installer.optifine") + " " + stageValue);
                case "hmcl.install.fabric" -> I18n.i18n("install.installer.install", I18n.i18n("install.installer.fabric") + " " + stageValue);
                case "hmcl.install.fabric-api" -> I18n.i18n("install.installer.install", I18n.i18n("install.installer.fabric-api") + " " + stageValue);
                case "hmcl.install.legacyfabric" -> I18n.i18n("install.installer.install", I18n.i18n("install.installer.legacyfabric") + " " + stageValue);
                case "hmcl.install.legacyfabric-api" -> I18n.i18n("install.installer.install", I18n.i18n("install.installer.legacyfabric-api") + " " + stageValue);
                case "hmcl.install.quilt" -> I18n.i18n("install.installer.install", I18n.i18n("install.installer.quilt") + " " + stageValue);
                case "hmcl.install.quilt-api" -> I18n.i18n("install.installer.install", I18n.i18n("install.installer.quilt-api") + " " + stageValue);
                default -> I18n.i18n(stageKey);
            };
            this.title.set((Object)this.message);
        }

        private void begin() {
            ++this.runningTasksCount;
            if (this.status.get() == Status.WAITING || this.status.get() == Status.SUCCESS) {
                this.status.set((Object)Status.RUNNING);
            }
        }

        public void succeed() {
            this.runningTasksCount = Math.max(0, this.runningTasksCount - 1);
            if (this.runningTasksCount == 0) {
                this.status.set((Object)Status.SUCCESS);
            }
        }

        public void fail() {
            this.runningTasksCount = Math.max(0, this.runningTasksCount - 1);
            this.status.set((Object)Status.FAILED);
        }

        public void count() {
            this.updateCounter(++this.count, this.total);
        }

        public void addTotal(int n) {
            this.total += n;
            this.updateCounter(this.count, this.total);
        }

        public void updateCounter(int count, int total) {
            this.title.setValue((String)(total > 0 ? this.message + " - " + count + "/" + total : this.message));
        }

        private static enum Status {
            WAITING(SVG.MORE_HORIZ),
            RUNNING(SVG.ARROW_FORWARD),
            SUCCESS(SVG.CHECK),
            FAILED(SVG.CLOSE);

            private final SVG svg;

            private Status(SVG svg) {
                this.svg = svg;
            }
        }
    }

    private final class Cell
    extends ListCell<Node> {
        private static final double STATUS_ICON_SIZE = 14.0;
        private final BorderPane pane = new BorderPane();
        private final StackPane left = new StackPane();
        private final Label title = new Label();
        private final Label message = new Label();
        private final JFXProgressBar bar = new JFXProgressBar();
        private WeakReference<StageNode> prevStageNodeRef;
        private StatusChangeListener statusChangeListener;

        private Cell() {
            this.setPadding(new Insets(0.0, 0.0, 4.0, 0.0));
            this.prefWidthProperty().bind((ObservableValue)TaskListPane.this.cellWidth);
            FXUtils.setLimitHeight((Region)this.left, 14.0);
            FXUtils.setLimitWidth((Region)this.left, 14.0);
            BorderPane.setAlignment((javafx.scene.Node)this.left, (Pos)Pos.CENTER_LEFT);
            BorderPane.setMargin((javafx.scene.Node)this.left, (Insets)new Insets(0.0, 12.0, 0.0, 0.0));
            BorderPane.setAlignment((javafx.scene.Node)this.title, (Pos)Pos.CENTER_LEFT);
            this.pane.setCenter((javafx.scene.Node)this.title);
            DoubleBinding barWidth = Bindings.createDoubleBinding(() -> {
                Insets padding = this.pane.getPadding();
                Insets insets = this.pane.getInsets();
                return this.pane.getWidth() - padding.getLeft() - padding.getRight() - insets.getLeft() - insets.getRight();
            }, (Observable[])new Observable[]{this.pane.paddingProperty(), this.pane.widthProperty()});
            this.bar.minWidthProperty().bind((ObservableValue)barWidth);
            this.bar.prefWidthProperty().bind((ObservableValue)barWidth);
            this.bar.maxWidthProperty().bind((ObservableValue)barWidth);
            this.setGraphic((javafx.scene.Node)this.pane);
        }

        private void updateLeftIcon(StageNode.Status status) {
            this.left.getChildren().setAll((Object[])new javafx.scene.Node[]{status.svg.createIcon(14.0)});
        }

        protected void updateItem(Node item, boolean empty) {
            StageNode prevStageNode;
            super.updateItem((Object)item, empty);
            this.pane.paddingProperty().unbind();
            this.title.textProperty().unbind();
            this.message.textProperty().unbind();
            this.bar.progressProperty().unbind();
            if (this.prevStageNodeRef != null && (prevStageNode = (StageNode)this.prevStageNodeRef.get()) != null) {
                prevStageNode.status.removeListener((ChangeListener)this.statusChangeListener);
            }
            if (item instanceof ProgressListNode) {
                ProgressListNode progressListNode = (ProgressListNode)item;
                this.title.setText(progressListNode.title);
                this.message.textProperty().bind((ObservableValue)progressListNode.message);
                this.bar.progressProperty().bind((ObservableValue)progressListNode.progress);
                this.pane.paddingProperty().bind(TaskListPane.this.progressNodePadding);
                this.pane.setLeft(null);
                this.pane.setRight((javafx.scene.Node)this.message);
                this.pane.setBottom((javafx.scene.Node)this.bar);
            } else if (item instanceof StageNode) {
                StageNode stageNode = (StageNode)item;
                this.title.textProperty().bind((ObservableValue)stageNode.title);
                this.message.setText("");
                this.bar.setProgress(-1.0);
                this.pane.setPadding(Insets.EMPTY);
                this.pane.setLeft((javafx.scene.Node)this.left);
                this.pane.setRight((javafx.scene.Node)this.message);
                this.pane.setBottom(null);
                this.updateLeftIcon((StageNode.Status)((Object)stageNode.status.get()));
                if (this.statusChangeListener == null) {
                    this.statusChangeListener = new StatusChangeListener(this);
                }
                stageNode.status.addListener((ChangeListener)this.statusChangeListener);
                this.prevStageNodeRef = new WeakReference<StageNode>(stageNode);
            } else {
                this.title.setText("");
                this.message.setText("");
                this.bar.setProgress(-1.0);
                this.pane.setPadding(Insets.EMPTY);
                this.pane.setLeft(null);
                this.pane.setRight(null);
                this.pane.setBottom(null);
            }
        }
    }

    private static final class ProgressListNode
    extends Node {
        private final String title;
        private final StringProperty message = new SimpleStringProperty("");
        private final DoubleProperty progress = new SimpleDoubleProperty(0.0);

        private ProgressListNode(Task<?> task) {
            this.title = task.getName();
            this.progress.bind((ObservableValue)task.progressProperty());
        }

        public void unbind() {
            this.progress.unbind();
        }

        public void setThrowable(Throwable throwable) {
            this.unbind();
            this.message.set((Object)throwable.getLocalizedMessage());
            this.progress.set(0.0);
        }
    }

    private static abstract class Node {
        private Node() {
        }
    }

    private static final class StatusChangeListener
    implements ChangeListener<StageNode.Status>,
    WeakListener {
        private final WeakReference<Cell> cellRef;

        private StatusChangeListener(Cell cell) {
            this.cellRef = new WeakReference<Cell>(cell);
        }

        public boolean wasGarbageCollected() {
            return this.cellRef.get() == null;
        }

        public void changed(ObservableValue<? extends StageNode.Status> observable, StageNode.Status oldValue, StageNode.Status newValue) {
            Cell cell = (Cell)((Object)this.cellRef.get());
            if (cell == null) {
                if (observable != null) {
                    observable.removeListener((ChangeListener)this);
                }
                return;
            }
            cell.updateLeftIcon(newValue);
        }
    }
}

