/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.util.MissingResourceException;
import javafx.collections.ObservableList;
import org.jackhuang.hmcl.game.LocalizedRemoteModRepository;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.mod.curse.CurseForgeRemoteModRepository;
import org.jackhuang.hmcl.mod.modrinth.ModrinthRemoteModRepository;
import org.jackhuang.hmcl.ui.versions.DownloadListPage;
import org.jackhuang.hmcl.ui.versions.DownloadPage;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public final class HMCLLocalizedDownloadListPage
extends DownloadListPage {
    public static DownloadListPage ofMod(DownloadPage.DownloadCallback callback, boolean versionSelection) {
        return new HMCLLocalizedDownloadListPage(callback, versionSelection, RemoteModRepository.Type.MOD, CurseForgeRemoteModRepository.MODS, ModrinthRemoteModRepository.MODS);
    }

    public static DownloadListPage ofCurseForgeMod(DownloadPage.DownloadCallback callback, boolean versionSelection) {
        return new HMCLLocalizedDownloadListPage(callback, versionSelection, RemoteModRepository.Type.MOD, CurseForgeRemoteModRepository.MODS, null);
    }

    public static DownloadListPage ofModrinthMod(DownloadPage.DownloadCallback callback, boolean versionSelection) {
        return new HMCLLocalizedDownloadListPage(callback, versionSelection, RemoteModRepository.Type.MOD, null, ModrinthRemoteModRepository.MODS);
    }

    public static DownloadListPage ofModPack(DownloadPage.DownloadCallback callback, boolean versionSelection) {
        return new HMCLLocalizedDownloadListPage(callback, versionSelection, RemoteModRepository.Type.MODPACK, CurseForgeRemoteModRepository.MODPACKS, ModrinthRemoteModRepository.MODPACKS);
    }

    public static DownloadListPage ofResourcePack(DownloadPage.DownloadCallback callback, boolean versionSelection) {
        return new HMCLLocalizedDownloadListPage(callback, versionSelection, RemoteModRepository.Type.RESOURCE_PACK, CurseForgeRemoteModRepository.RESOURCE_PACKS, ModrinthRemoteModRepository.RESOURCE_PACKS);
    }

    public static DownloadListPage ofShaderPack(DownloadPage.DownloadCallback callback, boolean versionSelection) {
        HMCLLocalizedDownloadListPage page = new HMCLLocalizedDownloadListPage(callback, versionSelection, RemoteModRepository.Type.SHADER_PACK, null, ModrinthRemoteModRepository.SHADER_PACKS);
        page.supportChinese.set(false);
        return page;
    }

    private HMCLLocalizedDownloadListPage(DownloadPage.DownloadCallback callback, boolean versionSelection, RemoteModRepository.Type type, CurseForgeRemoteModRepository curseForge, ModrinthRemoteModRepository modrinth) {
        super(null, callback, versionSelection);
        this.repository = new Repository(type, curseForge, modrinth);
        this.supportChinese.set(true);
        ((ObservableList)this.downloadSources.get()).setAll((Object[])new String[]{"mods.modrinth", "mods.curseforge"});
        if (modrinth != null) {
            this.downloadSource.set((Object)"mods.modrinth");
        } else if (curseForge != null) {
            this.downloadSource.set((Object)"mods.curseforge");
        } else {
            throw new AssertionError((Object)"Should not be here.");
        }
    }

    @Override
    protected String getLocalizedCategory(String category) {
        if (category.isEmpty()) {
            return "";
        }
        String key = ("mods.modrinth".equals(this.downloadSource.get()) ? "modrinth" : "curse") + ".category." + category;
        try {
            return I18n.getResourceBundle().getString(key);
        }
        catch (MissingResourceException e) {
            Logger.LOG.warning("Cannot find key " + key + " in resource bundle");
            return category;
        }
    }

    @Override
    protected String getLocalizedOfficialPage() {
        if ("mods.modrinth".equals(this.downloadSource.get())) {
            return I18n.i18n("mods.modrinth");
        }
        return I18n.i18n("mods.curseforge");
    }

    private class Repository
    extends LocalizedRemoteModRepository {
        private final RemoteModRepository.Type type;
        private final CurseForgeRemoteModRepository curseForge;
        private final ModrinthRemoteModRepository modrinth;

        public Repository(RemoteModRepository.Type type, CurseForgeRemoteModRepository curseForge, ModrinthRemoteModRepository modrinth) {
            this.type = type;
            this.curseForge = curseForge;
            this.modrinth = modrinth;
        }

        @Override
        protected RemoteModRepository getBackedRemoteModRepository() {
            if ("mods.modrinth".equals(HMCLLocalizedDownloadListPage.this.downloadSource.get())) {
                return this.modrinth;
            }
            return this.curseForge;
        }

        @Override
        protected RemoteModRepository.SortType getBackedRemoteModRepositorySortOrder() {
            if ("mods.modrinth".equals(HMCLLocalizedDownloadListPage.this.downloadSource.get())) {
                return RemoteModRepository.SortType.NAME;
            }
            return RemoteModRepository.SortType.POPULARITY;
        }

        @Override
        public RemoteModRepository.Type getType() {
            return this.type;
        }
    }
}

