/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.skins.JFXCheckBoxSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.PaintConverter;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class JFXCheckBox
extends CheckBox {
    private static final String DEFAULT_STYLE_CLASS = "jfx-check-box";
    private StyleableObjectProperty<Paint> checkedColor;
    private static final Color DEFAULT_CHECKED_COLOR = Color.valueOf((String)"#0F9D58");
    private StyleableObjectProperty<Paint> unCheckedColor;
    private static final Color DEFAULT_UNCHECKED_COLOR = Color.valueOf((String)"#5A5A5A");

    public JFXCheckBox(String text) {
        super(text);
        this.initialize();
    }

    public JFXCheckBox() {
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXCheckBoxSkin(this);
    }

    public StyleableObjectProperty<Paint> checkedColorProperty() {
        if (this.checkedColor == null) {
            this.checkedColor = new SimpleStyleableObjectProperty(StyleableProperties.CHECKED_COLOR, (Object)this, "checkedColor", (Object)DEFAULT_CHECKED_COLOR);
        }
        return this.checkedColor;
    }

    public Paint getCheckedColor() {
        return this.checkedColor == null ? DEFAULT_CHECKED_COLOR : (Paint)this.checkedColor.get();
    }

    public void setCheckedColor(Paint color) {
        this.checkedColor.set((Object)color);
    }

    public StyleableObjectProperty<Paint> unCheckedColorProperty() {
        if (this.unCheckedColor == null) {
            this.unCheckedColor = new SimpleStyleableObjectProperty(StyleableProperties.UNCHECKED_COLOR, (Object)this, "unCheckedColor", (Object)DEFAULT_UNCHECKED_COLOR);
        }
        return this.unCheckedColor;
    }

    public Paint getUnCheckedColor() {
        return this.unCheckedColor == null ? DEFAULT_UNCHECKED_COLOR : (Paint)this.unCheckedColor.get();
    }

    public void setUnCheckedColor(Paint color) {
        this.unCheckedColor.set((Object)color);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXCheckBox.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static final class StyleableProperties {
        private static final CssMetaData<JFXCheckBox, Paint> CHECKED_COLOR = new CssMetaData<JFXCheckBox, Paint>("-jfx-checked-color", PaintConverter.getInstance(), (Paint)DEFAULT_CHECKED_COLOR){

            public boolean isSettable(JFXCheckBox control) {
                return control.checkedColor == null || !control.checkedColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXCheckBox control) {
                return control.checkedColorProperty();
            }
        };
        private static final CssMetaData<JFXCheckBox, Paint> UNCHECKED_COLOR = new CssMetaData<JFXCheckBox, Paint>("-jfx-unchecked-color", PaintConverter.getInstance(), (Paint)DEFAULT_UNCHECKED_COLOR){

            public boolean isSettable(JFXCheckBox control) {
                return control.unCheckedColor == null || !control.unCheckedColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXCheckBox control) {
                return control.unCheckedColorProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(CheckBox.getClassCssMetaData());
            Collections.addAll(styleables, CHECKED_COLOR, UNCHECKED_COLOR);
            CHILD_STYLEABLES = List.copyOf(styleables);
        }
    }
}

