/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXSlider;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.geometry.Orientation;
import javafx.scene.chart.NumberAxis;
import javafx.scene.control.Slider;
import javafx.scene.control.skin.SliderSkin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class JFXSliderSkin
extends SliderSkin {
    private static final PseudoClass MIN_VALUE = PseudoClass.getPseudoClass((String)"min");
    private static final PseudoClass MAX_VALUE = PseudoClass.getPseudoClass((String)"max");
    private final Pane mouseHandlerPane = new Pane();
    private final Text sliderValue;
    private final StackPane coloredTrack;
    private final StackPane thumb;
    private final StackPane track = (StackPane)((Slider)this.getSkinnable()).lookup(".track");
    private final StackPane animatedThumb;
    private NumberAxis tickLine;
    private Timeline timeline;
    private double indicatorRotation;
    private double horizontalRotation;
    private double shifting;

    public JFXSliderSkin(JFXSlider slider) {
        super((Slider)slider);
        this.thumb = (StackPane)((Slider)this.getSkinnable()).lookup(".thumb");
        this.tickLine = (NumberAxis)((Slider)this.getSkinnable()).lookup(".axis");
        if (this.tickLine != null) {
            this.tickLine.setAnimated(false);
        }
        this.coloredTrack = new StackPane();
        this.coloredTrack.getStyleClass().add((Object)"colored-track");
        this.coloredTrack.setMouseTransparent(true);
        this.sliderValue = new Text();
        this.sliderValue.getStyleClass().setAll((Object[])new String[]{"slider-value"});
        this.animatedThumb = new StackPane();
        this.animatedThumb.getStyleClass().add((Object)"animated-thumb");
        this.animatedThumb.getChildren().add((Object)this.sliderValue);
        this.animatedThumb.setMouseTransparent(true);
        this.animatedThumb.setScaleX(0.0);
        this.animatedThumb.setScaleY(0.0);
        this.thumb.layoutXProperty().addListener(x -> {
            if (slider.getOrientation() == Orientation.VERTICAL) {
                this.initAnimation(Orientation.VERTICAL);
            }
        });
        this.thumb.layoutYProperty().addListener(y -> {
            if (slider.getOrientation() == Orientation.HORIZONTAL) {
                this.initAnimation(Orientation.HORIZONTAL);
            }
        });
        this.addJFXChildren();
        this.getChildren().addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                c.getAddedSubList().forEach(added -> {
                    if (added instanceof NumberAxis) {
                        this.tickLine = (NumberAxis)added;
                        this.tickLine.setAnimated(false);
                    }
                });
            }
        });
        this.registerChangeListener((ObservableValue)slider.showTickMarksProperty(), e -> this.addJFXChildren());
        this.registerChangeListener((ObservableValue)slider.showTickLabelsProperty(), e -> this.addJFXChildren());
        this.registerChangeListener((ObservableValue)slider.valueFactoryProperty(), obs -> this.refreshSliderValueBinding());
        this.initListeners();
    }

    private void addJFXChildren() {
        ObservableList children = this.getChildren();
        Slider slider = (Slider)this.getSkinnable();
        if ((slider.isShowTickMarks() || slider.isShowTickLabels()) && this.tickLine != null && !children.contains((Object)this.tickLine)) {
            children.add(0, (Object)this.tickLine);
        }
        if (children.contains((Object)this.coloredTrack)) {
            return;
        }
        children.add(children.indexOf((Object)this.thumb), (Object)this.coloredTrack);
        children.add(children.indexOf((Object)this.thumb), (Object)this.animatedThumb);
        children.add(0, (Object)this.mouseHandlerPane);
    }

    private void refreshSliderValueBinding() {
        this.sliderValue.textProperty().unbind();
        if (((JFXSlider)this.getSkinnable()).getValueFactory() != null) {
            this.sliderValue.textProperty().bind((ObservableValue)((JFXSlider)this.getSkinnable()).getValueFactory().call((Object)((JFXSlider)this.getSkinnable())));
        } else {
            this.sliderValue.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                if (((Slider)this.getSkinnable()).getLabelFormatter() != null) {
                    return ((Slider)this.getSkinnable()).getLabelFormatter().toString((Object)((Slider)this.getSkinnable()).getValue());
                }
                return String.valueOf(Math.round(((Slider)this.getSkinnable()).getValue()));
            }, (Observable[])new Observable[]{((Slider)this.getSkinnable()).valueProperty()}));
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double layoutY;
        double layoutX;
        double height;
        double width;
        boolean horizontal;
        super.layoutChildren(x, y, w, h);
        if (this.timeline == null) {
            this.initAnimation(((Slider)this.getSkinnable()).getOrientation());
        }
        double prefWidth = this.animatedThumb.prefWidth(-1.0);
        this.animatedThumb.resize(prefWidth, this.animatedThumb.prefHeight(prefWidth));
        boolean bl = horizontal = ((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
        if (horizontal) {
            width = this.thumb.getLayoutX() - this.snappedLeftInset();
            height = this.track.getHeight();
            layoutX = this.track.getLayoutX();
            layoutY = this.track.getLayoutY();
            this.animatedThumb.setLayoutX(this.thumb.getLayoutX() + this.thumb.getWidth() / 2.0 - this.animatedThumb.getWidth() / 2.0);
        } else {
            height = this.track.getLayoutBounds().getMaxY() + this.track.getLayoutY() - this.thumb.getLayoutY() - this.snappedBottomInset();
            width = this.track.getWidth();
            layoutX = this.track.getLayoutX();
            layoutY = this.thumb.getLayoutY();
            this.animatedThumb.setLayoutY(this.thumb.getLayoutY() + this.thumb.getHeight() / 2.0 - this.animatedThumb.getHeight() / 2.0);
        }
        this.coloredTrack.resizeRelocate(layoutX, layoutY, width, height);
        this.mouseHandlerPane.resizeRelocate(x, y, w, h);
    }

    private void initializeVariables() {
        this.shifting = 30.0 + this.thumb.getWidth();
        if (((Slider)this.getSkinnable()).getOrientation() != Orientation.HORIZONTAL) {
            this.horizontalRotation = -90.0;
        }
        if (((JFXSlider)this.getSkinnable()).getIndicatorPosition() != JFXSlider.IndicatorPosition.LEFT) {
            this.indicatorRotation = 180.0;
            this.shifting = -this.shifting;
        }
        double rotationAngle = 45.0;
        this.sliderValue.setRotate(45.0 + this.indicatorRotation + 3.0 * this.horizontalRotation);
        this.animatedThumb.setRotate(-45.0 + this.indicatorRotation + this.horizontalRotation);
    }

    private void initListeners() {
        this.mouseHandlerPane.setOnMousePressed(this::delegateToTrack);
        this.mouseHandlerPane.setOnMouseReleased(this::delegateToTrack);
        this.mouseHandlerPane.setOnMouseDragged(this::delegateToTrack);
        this.track.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            this.timeline.setRate(1.0);
            this.timeline.play();
        });
        this.track.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> {
            this.timeline.setRate(-1.0);
            this.timeline.play();
        });
        this.thumb.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            this.timeline.setRate(1.0);
            this.timeline.play();
        });
        this.thumb.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> {
            this.timeline.setRate(-1.0);
            this.timeline.play();
        });
        this.refreshSliderValueBinding();
        this.updateValueStyleClass();
        ((Slider)this.getSkinnable()).valueProperty().addListener(observable -> this.updateValueStyleClass());
    }

    private void delegateToTrack(MouseEvent event) {
        if (!event.isConsumed()) {
            event.consume();
            this.track.fireEvent((Event)event);
        }
    }

    private void updateValueStyleClass() {
        ((Slider)this.getSkinnable()).pseudoClassStateChanged(MIN_VALUE, ((Slider)this.getSkinnable()).getMin() == ((Slider)this.getSkinnable()).getValue());
        ((Slider)this.getSkinnable()).pseudoClassStateChanged(MAX_VALUE, ((Slider)this.getSkinnable()).getMax() == ((Slider)this.getSkinnable()).getValue());
    }

    private void initAnimation(Orientation orientation) {
        DoubleProperty layoutProperty;
        double thumbNewPos;
        double thumbPos;
        this.initializeVariables();
        if (orientation == Orientation.HORIZONTAL) {
            if (((JFXSlider)this.getSkinnable()).getIndicatorPosition() == JFXSlider.IndicatorPosition.RIGHT) {
                thumbPos = this.thumb.getLayoutY() - this.thumb.getHeight();
                thumbNewPos = thumbPos - this.shifting;
            } else {
                double height = this.animatedThumb.prefHeight(this.animatedThumb.prefWidth(-1.0));
                thumbPos = this.thumb.getLayoutY() - height / 2.0;
                thumbNewPos = this.thumb.getLayoutY() - height - this.thumb.getHeight();
            }
            layoutProperty = this.animatedThumb.translateYProperty();
        } else {
            if (((JFXSlider)this.getSkinnable()).getIndicatorPosition() == JFXSlider.IndicatorPosition.RIGHT) {
                thumbPos = this.thumb.getLayoutX() - this.thumb.getWidth();
                thumbNewPos = thumbPos - this.shifting;
            } else {
                double width = this.animatedThumb.prefWidth(-1.0);
                thumbPos = this.thumb.getLayoutX() - width / 2.0;
                thumbNewPos = this.thumb.getLayoutX() - width - this.thumb.getWidth();
            }
            layoutProperty = this.animatedThumb.translateXProperty();
        }
        this.clearAnimation();
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.animatedThumb.scaleXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.animatedThumb.scaleYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)layoutProperty, (Object)thumbPos, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.2), new KeyValue[]{new KeyValue((WritableValue)this.animatedThumb.scaleXProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.animatedThumb.scaleYProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)layoutProperty, (Object)thumbNewPos, Interpolator.EASE_BOTH)})});
    }

    public void dispose() {
        super.dispose();
        this.clearAnimation();
    }

    private void clearAnimation() {
        if (this.timeline != null) {
            this.timeline.stop();
            this.timeline.getKeyFrames().clear();
            this.timeline = null;
        }
    }
}

