/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.transitions;

import com.jfoenix.transitions.JFXKeyValue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Supplier;
import javafx.util.Duration;

public class JFXKeyFrame {
    private Duration duration;
    private Set<JFXKeyValue<?>> keyValues = new CopyOnWriteArraySet();
    private Supplier<Boolean> animateCondition = null;

    public JFXKeyFrame(Duration duration, JFXKeyValue<?> ... keyValues) {
        this.duration = duration;
        for (JFXKeyValue<?> keyValue : keyValues) {
            if (keyValue == null) continue;
            this.keyValues.add(keyValue);
        }
    }

    private JFXKeyFrame() {
    }

    public final Duration getDuration() {
        return this.duration;
    }

    public final Set<JFXKeyValue<?>> getValues() {
        return this.keyValues;
    }

    public Supplier<Boolean> getAnimateCondition() {
        return this.animateCondition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Duration duration;
        private final Set<JFXKeyValue<?>> keyValues = new CopyOnWriteArraySet();
        private Supplier<Boolean> animateCondition = null;

        private Builder() {
        }

        public Builder setDuration(Duration duration) {
            this.duration = duration;
            return this;
        }

        public Builder setKeyValues(JFXKeyValue<?> ... keyValues) {
            for (JFXKeyValue<?> keyValue : keyValues) {
                if (keyValue == null) continue;
                this.keyValues.add(keyValue);
            }
            return this;
        }

        public Builder setAnimateCondition(Supplier<Boolean> animateCondition) {
            this.animateCondition = animateCondition;
            return this;
        }

        public JFXKeyFrame build() {
            JFXKeyFrame jFXKeyFrame = new JFXKeyFrame();
            jFXKeyFrame.duration = this.duration;
            jFXKeyFrame.keyValues = this.keyValues;
            jFXKeyFrame.animateCondition = this.animateCondition;
            return jFXKeyFrame;
        }
    }
}

