/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.png.image;

import java.util.Objects;
import org.glavo.png.image.ArgbImage;

public abstract class ArgbImageWrapper<T>
implements ArgbImage {
    protected final T image;
    protected final int width;
    protected final int height;

    protected ArgbImageWrapper(T image, int width, int height) {
        this.image = image;
        this.width = width;
        this.height = height;
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid picture size");
        }
    }

    public T getImage() {
        return this.image;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public static <T> ArgbImageWrapper<T> of(T image, int width, int height, final ColorExtractor<T> extractor) {
        Objects.requireNonNull(extractor);
        return new ArgbImageWrapper<T>(image, width, height){

            @Override
            public int getArgb(int x, int y) {
                return extractor.getArgb(this.image, x, y);
            }
        };
    }

    @FunctionalInterface
    public static interface ColorExtractor<T> {
        public int getArgb(T var1, int var2, int var3);
    }
}

