/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl;

import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.jackhuang.hmcl.BootProperties;
import org.jackhuang.hmcl.DesktopUtils;
import org.jackhuang.hmcl.EntryPoint;
import org.jackhuang.hmcl.util.SwingUtils;

public final class Main {
    private static final int MINIMUM_JAVA_VERSION = 17;
    private static final String DOWNLOAD_PAGE = "https://hmcl.huangyuhui.net/download/";

    private Main() {
    }

    static int findFirstNotNumber(String str, int start) {
        if (start >= str.length()) {
            return -1;
        }
        char ch = str.charAt(start);
        if (ch < '0' || ch > '9') {
            return -1;
        }
        for (int i = start + 1; i < str.length(); ++i) {
            ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return i;
        }
        return str.length();
    }

    static int getJavaFeatureVersion(String javaVersion) {
        if (javaVersion == null) {
            return -1;
        }
        try {
            int end = Main.findFirstNotNumber(javaVersion, 0);
            if (end < 0) {
                return -1;
            }
            int major = Integer.parseInt(javaVersion.substring(0, end));
            if (major > 1) {
                return major;
            }
            if (major < 1) {
                return -1;
            }
            int start = end + 1;
            if ((end = Main.findFirstNotNumber(javaVersion, start)) < 0) {
                return -1;
            }
            return Integer.parseInt(javaVersion.substring(start, end));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    static void showErrorAndExit(String[] args) {
        SwingUtils.initLookAndFeel();
        ResourceBundle resourceBundle = BootProperties.getResourceBundle();
        String errorTitle = resourceBundle.getString("boot.message.error");
        if (args.length > 0 && args[0].equals("--apply-to")) {
            String errorMessage = resourceBundle.getString("boot.manual_update");
            System.err.println(errorMessage);
            int result = JOptionPane.showOptionDialog(null, errorMessage, errorTitle, 0, 0, null, null, null);
            if (result == 0) {
                System.out.println("Open https://hmcl.huangyuhui.net/download/");
                DesktopUtils.openLink(DOWNLOAD_PAGE);
            }
        } else {
            String errorMessage = resourceBundle.getString("boot.unsupported_java_version");
            System.err.println(errorMessage);
            SwingUtils.showErrorDialog(errorMessage, errorTitle);
        }
        System.exit(1);
    }

    private static void checkDirectoryPath() {
        String currentDir = System.getProperty("user.dir", "");
        String jarPath = Main.getThisJarPath();
        if (currentDir.contains("!")) {
            SwingUtils.initLookAndFeel();
            System.err.println("The current working path contains an exclamation mark: " + currentDir);
            SwingUtils.showErrorDialog("Exclamation mark(!) is not allowed in the working path.\nThe path is " + currentDir);
            System.exit(1);
        } else if (jarPath != null && jarPath.contains("!")) {
            SwingUtils.initLookAndFeel();
            System.err.println("The jar path contains an exclamation mark: " + jarPath);
            SwingUtils.showErrorDialog("Exclamation mark(!) is not allowed in the path where HMCL is in.\nThe path is " + jarPath);
            System.exit(1);
        }
    }

    private static String getThisJarPath() {
        ProtectionDomain protectionDomain = Main.class.getProtectionDomain();
        if (protectionDomain == null) {
            return null;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null || codeSource.getLocation() == null) {
            return null;
        }
        try {
            return Paths.get(codeSource.getLocation().toURI()).toAbsolutePath().normalize().toString();
        }
        catch (IllegalArgumentException | URISyntaxException | FileSystemNotFoundException e) {
            return null;
        }
    }

    public static void main(String[] args) throws Throwable {
        Main.checkDirectoryPath();
        if (Main.getJavaFeatureVersion(System.getProperty("java.version")) >= 17) {
            EntryPoint.main(args);
        } else {
            Main.showErrorAndExit(args);
        }
    }
}

