/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.util.ArrayList;
import java.util.Map;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.GameBuilder;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.function.ExceptionalFunction;

public class DefaultGameBuilder
extends GameBuilder {
    private final DefaultDependencyManager dependencyManager;

    public DefaultGameBuilder(DefaultDependencyManager dependencyManager) {
        this.dependencyManager = dependencyManager;
    }

    public DefaultDependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    @Override
    public Task<?> buildAsync() {
        ArrayList<Task.StagesHint> hints = new ArrayList<Task.StagesHint>();
        Task<Version> libraryTask = Task.supplyAsync(() -> new Version(this.name));
        libraryTask = libraryTask.thenComposeAsync(this.libraryTaskHelper(this.gameVersion, "game", this.gameVersion));
        hints.add(new Task.StagesHint("hmcl.install.game:" + this.gameVersion));
        hints.add(new Task.StagesHint("hmcl.install.libraries"));
        hints.add(new Task.StagesHint("hmcl.install.assets"));
        for (Map.Entry entry : this.toolVersions.entrySet()) {
            libraryTask = libraryTask.thenComposeAsync(this.libraryTaskHelper(this.gameVersion, (String)entry.getKey(), (String)entry.getValue()));
            hints.add(new Task.StagesHint(String.format("hmcl.install.%s:%s", entry.getKey(), entry.getValue())));
        }
        for (RemoteVersion remoteVersion : this.remoteVersions) {
            libraryTask = libraryTask.thenComposeAsync(version -> this.dependencyManager.installLibraryAsync((Version)version, remoteVersion));
            hints.add(new Task.StagesHint(String.format("hmcl.install.%s:%s", remoteVersion.getLibraryId(), remoteVersion.getSelfVersion())));
        }
        return libraryTask.thenComposeAsync(this.dependencyManager.getGameRepository()::saveAsync).whenComplete(exception -> {
            if (exception != null) {
                this.dependencyManager.getGameRepository().removeVersionFromDisk(this.name);
            }
        }).withStagesHints(hints);
    }

    private ExceptionalFunction<Version, Task<Version>, ?> libraryTaskHelper(String gameVersion, String libraryId, String libraryVersion) {
        return version -> this.dependencyManager.installLibraryAsync(gameVersion, (Version)version, libraryId, libraryVersion);
    }
}

