/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.github.steveice10.opennbt.NBTIO;
import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.LongTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javafx.scene.image.Image;
import org.jackhuang.hmcl.game.WorldLockedException;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.io.Unzipper;
import org.jackhuang.hmcl.util.io.Zipper;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;
import org.jetbrains.annotations.Nullable;

public final class World {
    private final Path file;
    private String fileName;
    private CompoundTag levelData;
    private Image icon;
    private Path levelDataPath;

    public World(Path file) throws IOException {
        this.file = file;
        if (Files.isDirectory(file, new LinkOption[0])) {
            this.loadFromDirectory();
        } else if (Files.isRegularFile(file, new LinkOption[0])) {
            this.loadFromZip();
        } else {
            throw new IOException("Path " + String.valueOf(file) + " cannot be recognized as a Minecraft world");
        }
    }

    public Path getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getWorldName() {
        CompoundTag data = (CompoundTag)this.levelData.get("Data");
        StringTag levelNameTag = (StringTag)data.get("LevelName");
        return levelNameTag.getValue();
    }

    public void setWorldName(String worldName) throws IOException {
        CompoundTag data;
        Object t = this.levelData.get("Data");
        if (t instanceof CompoundTag && (t = (data = (CompoundTag)t).get("LevelName")) instanceof StringTag) {
            StringTag levelNameTag = (StringTag)t;
            levelNameTag.setValue(worldName);
            this.writeLevelDat(this.levelData);
        }
    }

    public Path getLevelDatFile() {
        return this.file.resolve("level.dat");
    }

    public Path getSessionLockFile() {
        return this.file.resolve("session.lock");
    }

    public CompoundTag getLevelData() {
        return this.levelData;
    }

    public long getLastPlayed() {
        CompoundTag data = (CompoundTag)this.levelData.get("Data");
        LongTag lastPlayedTag = (LongTag)data.get("LastPlayed");
        return lastPlayedTag.getValue();
    }

    @Nullable
    public GameVersionNumber getGameVersion() {
        CompoundTag versionTag;
        CompoundTag data;
        Object t = this.levelData.get("Data");
        if (t instanceof CompoundTag && (t = (data = (CompoundTag)t).get("Version")) instanceof CompoundTag && (t = (versionTag = (CompoundTag)t).get("Name")) instanceof StringTag) {
            StringTag nameTag = (StringTag)t;
            return GameVersionNumber.asGameVersion(nameTag.getValue());
        }
        return null;
    }

    @Nullable
    public Long getSeed() {
        CompoundTag worldGenSettingsTag;
        CompoundTag data = (CompoundTag)this.levelData.get("Data");
        Object t = data.get("WorldGenSettings");
        if (t instanceof CompoundTag && (t = (worldGenSettingsTag = (CompoundTag)t).get("seed")) instanceof LongTag) {
            LongTag seedTag = (LongTag)t;
            return seedTag.getValue();
        }
        t = data.get("RandomSeed");
        if (t instanceof LongTag) {
            LongTag seedTag = (LongTag)t;
            return seedTag.getValue();
        }
        return null;
    }

    public boolean isLargeBiomes() {
        CompoundTag overworldTag;
        CompoundTag dimensionsTag;
        CompoundTag worldGenSettingsTag;
        CompoundTag data = (CompoundTag)this.levelData.get("Data");
        Object t = data.get("generatorName");
        if (t instanceof StringTag) {
            StringTag generatorNameTag = (StringTag)t;
            return "largeBiomes".equals(generatorNameTag.getValue());
        }
        Object t2 = data.get("WorldGenSettings");
        if (t2 instanceof CompoundTag && (t2 = (worldGenSettingsTag = (CompoundTag)t2).get("dimensions")) instanceof CompoundTag && (t2 = (dimensionsTag = (CompoundTag)t2).get("minecraft:overworld")) instanceof CompoundTag && (t2 = (overworldTag = (CompoundTag)t2).get("generator")) instanceof CompoundTag) {
            CompoundTag biomeSourceTag;
            CompoundTag generatorTag = (CompoundTag)t2;
            Object t3 = generatorTag.get("biome_source");
            if (t3 instanceof CompoundTag && (t3 = (biomeSourceTag = (CompoundTag)t3).get("large_biomes")) instanceof ByteTag) {
                ByteTag largeBiomesTag = (ByteTag)t3;
                return largeBiomesTag.getValue() == 1;
            }
            t3 = generatorTag.get("settings");
            if (t3 instanceof StringTag) {
                StringTag settingsTag = (StringTag)t3;
                return "minecraft:large_biomes".equals(settingsTag.getValue());
            }
        }
        return false;
    }

    public Image getIcon() {
        return this.icon;
    }

    public boolean isLocked() {
        return World.isLocked(this.getSessionLockFile());
    }

    public boolean supportDatapacks() {
        return this.getGameVersion() != null && this.getGameVersion().isAtLeast("1.13", "17w43a");
    }

    public boolean supportQuickPlay() {
        return this.getGameVersion() != null && this.getGameVersion().isAtLeast("1.20", "23w14a");
    }

    public static boolean supportQuickPlay(GameVersionNumber gameVersionNumber) {
        return gameVersionNumber != null && gameVersionNumber.isAtLeast("1.20", "23w14a");
    }

    private void loadFromDirectory() throws IOException {
        this.fileName = FileUtils.getName(this.file);
        Path levelDat = this.file.resolve("level.dat");
        if (!Files.exists(levelDat, new LinkOption[0])) {
            levelDat = this.file.resolve("special_level.dat");
        }
        if (!Files.exists(levelDat, new LinkOption[0])) {
            throw new IOException("Not a valid world directory since level.dat or special_level.dat cannot be found.");
        }
        this.loadAndCheckLevelDat(levelDat);
        this.levelDataPath = levelDat;
        Path iconFile = this.file.resolve("icon.png");
        if (Files.isRegularFile(iconFile, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(iconFile, new OpenOption[0]);){
                this.icon = new Image(inputStream, 64.0, 64.0, true, false);
                if (this.icon.isError()) {
                    throw this.icon.getException();
                }
            }
            catch (Exception e) {
                Logger.LOG.warning("Failed to load world icon", e);
            }
        }
    }

    private void loadFromZipImpl(Path root) throws IOException {
        Path levelDat = root.resolve("level.dat");
        if (!Files.exists(levelDat, new LinkOption[0])) {
            levelDat = root.resolve("special_level.dat");
        }
        if (!Files.exists(levelDat, new LinkOption[0])) {
            throw new IOException("Not a valid world zip file since level.dat or special_level.dat cannot be found.");
        }
        this.loadAndCheckLevelDat(levelDat);
        Path iconFile = root.resolve("icon.png");
        if (Files.isRegularFile(iconFile, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(iconFile, new OpenOption[0]);){
                this.icon = new Image(inputStream, 64.0, 64.0, true, false);
                if (this.icon.isError()) {
                    throw this.icon.getException();
                }
            }
            catch (Exception e) {
                Logger.LOG.warning("Failed to load world icon", e);
            }
        }
    }

    private void loadFromZip() throws IOException {
        try (FileSystem fs = CompressingUtils.readonly(this.file).setAutoDetectEncoding(true).build();){
            Path levelDatPath = fs.getPath("/level.dat", new String[0]);
            if (Files.isRegularFile(levelDatPath, new LinkOption[0])) {
                this.fileName = FileUtils.getName(this.file);
                this.loadFromZipImpl(fs.getPath("/", new String[0]));
                return;
            }
            try (Stream<Path> stream = Files.list(fs.getPath("/", new String[0]));){
                Path root = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findAny().orElseThrow(() -> new IOException("Not a valid world zip file"));
                this.fileName = FileUtils.getName(root);
                this.loadFromZipImpl(root);
            }
        }
    }

    private void loadAndCheckLevelDat(Path levelDat) throws IOException {
        this.levelData = World.parseLevelDat(levelDat);
        CompoundTag data = (CompoundTag)this.levelData.get("Data");
        if (data == null) {
            throw new IOException("level.dat missing Data");
        }
        if (!(data.get("LevelName") instanceof StringTag)) {
            throw new IOException("level.dat missing LevelName");
        }
        if (!(data.get("LastPlayed") instanceof LongTag)) {
            throw new IOException("level.dat missing LastPlayed");
        }
    }

    public void reloadLevelDat() throws IOException {
        if (this.levelDataPath != null) {
            this.loadAndCheckLevelDat(this.levelDataPath);
        }
    }

    public void rename(String newName) throws IOException {
        if (!Files.isDirectory(this.file, new LinkOption[0])) {
            throw new IOException("Not a valid world directory");
        }
        CompoundTag data = (CompoundTag)this.levelData.get("Data");
        data.put(new StringTag("LevelName", newName));
        this.writeLevelDat(this.levelData);
        Files.move(this.file, this.file.resolveSibling(newName), new CopyOption[0]);
    }

    public void install(Path savesDir, String name) throws IOException {
        Path worldDir;
        try {
            worldDir = savesDir.resolve(name);
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
        if (Files.isDirectory(worldDir, new LinkOption[0])) {
            throw new FileAlreadyExistsException("World already exists");
        }
        if (Files.isRegularFile(this.file, new LinkOption[0])) {
            block20: {
                try (FileSystem fs = CompressingUtils.readonly(this.file).setAutoDetectEncoding(true).build();){
                    Path levelDatPath = fs.getPath("/level.dat", new String[0]);
                    if (Files.isRegularFile(levelDatPath, new LinkOption[0])) {
                        this.fileName = FileUtils.getName(this.file);
                        new Unzipper(this.file, worldDir).unzip();
                        break block20;
                    }
                    try (Stream<Path> stream = Files.list(fs.getPath("/", new String[0]));){
                        List<Path> subDirs = stream.toList();
                        if (subDirs.size() != 1) {
                            throw new IOException("World zip malformed");
                        }
                        String subDirectoryName = FileUtils.getName(subDirs.get(0));
                        new Unzipper(this.file, worldDir).setSubDirectory("/" + subDirectoryName + "/").unzip();
                    }
                }
            }
            new World(worldDir).rename(name);
        } else if (Files.isDirectory(this.file, new LinkOption[0])) {
            FileUtils.copyDirectory(this.file, worldDir);
        }
    }

    public void export(Path zip, String worldName) throws IOException {
        if (!Files.isDirectory(this.file, new LinkOption[0])) {
            throw new IOException();
        }
        try (Zipper zipper = new Zipper(zip);){
            zipper.putDirectory(this.file, worldName);
        }
    }

    public void delete() throws IOException {
        if (this.isLocked()) {
            throw new WorldLockedException("The world " + String.valueOf(this.getFile()) + " has been locked");
        }
        FileUtils.forceDelete(this.file);
    }

    public void copy(String newName) throws IOException {
        if (!Files.isDirectory(this.file, new LinkOption[0])) {
            throw new IOException("Not a valid world directory");
        }
        if (this.isLocked()) {
            throw new WorldLockedException("The world " + String.valueOf(this.getFile()) + " has been locked");
        }
        Path newPath = this.file.resolveSibling(newName);
        FileUtils.copyDirectory(this.file, newPath, path -> !path.contains("session.lock"));
        World newWorld = new World(newPath);
        newWorld.rename(newName);
    }

    public FileChannel lock() throws WorldLockedException {
        Path lockFile = this.getSessionLockFile();
        FileChannel channel = null;
        try {
            channel = FileChannel.open(lockFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            channel.write(ByteBuffer.wrap("\u2603".getBytes(StandardCharsets.UTF_8)));
            channel.force(true);
            FileLock fileLock = channel.tryLock();
            if (fileLock != null) {
                return channel;
            }
            IOUtils.closeQuietly(channel);
            throw new WorldLockedException("The world " + String.valueOf(this.getFile()) + " has been locked");
        }
        catch (IOException e) {
            IOUtils.closeQuietly(channel);
            throw new WorldLockedException(e);
        }
    }

    public void writeLevelDat(CompoundTag nbt) throws IOException {
        if (!Files.isDirectory(this.file, new LinkOption[0])) {
            throw new IOException("Not a valid world directory");
        }
        FileUtils.saveSafely(this.getLevelDatFile(), os -> {
            try (GZIPOutputStream gos = new GZIPOutputStream((OutputStream)os);){
                NBTIO.writeTag(gos, (Tag)nbt);
            }
        });
    }

    private static CompoundTag parseLevelDat(Path path) throws IOException {
        try (GZIPInputStream is = new GZIPInputStream(Files.newInputStream(path, new OpenOption[0]));){
            Tag nbt = NBTIO.readTag(is);
            if (nbt instanceof CompoundTag) {
                CompoundTag compoundTag;
                CompoundTag compoundTag2 = compoundTag = (CompoundTag)nbt;
                return compoundTag2;
            }
            throw new IOException("level.dat malformed");
        }
    }

    private static boolean isLocked(Path sessionLockFile) {
        boolean bl;
        block10: {
            FileChannel fileChannel = FileChannel.open(sessionLockFile, StandardOpenOption.WRITE);
            try {
                boolean bl2 = bl = fileChannel.tryLock() == null;
                if (fileChannel == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (OverlappingFileLockException | AccessDeniedException accessDeniedException) {
                    return true;
                }
                catch (NoSuchFileException noSuchFileException) {
                    return false;
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to open the lock file " + String.valueOf(sessionLockFile), e);
                    return false;
                }
            }
            fileChannel.close();
        }
        return bl;
    }

    public static List<World> getWorlds(Path savesDir) {
        if (Files.exists(savesDir, new LinkOption[0])) {
            List<World> list;
            block9: {
                Stream<Path> stream = Files.list(savesDir);
                try {
                    list = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(world -> {
                        try {
                            return Stream.of(new World(world.toAbsolutePath().normalize()));
                        }
                        catch (IOException e) {
                            Logger.LOG.warning("Failed to read world " + String.valueOf(world), e);
                            return Stream.empty();
                        }
                    }).toList();
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Failed to read saves", e);
                    }
                }
                stream.close();
            }
            return list;
        }
        return List.of();
    }
}

