/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.terracotta;

import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.terracotta.TerracottaBundle;
import org.jackhuang.hmcl.terracotta.provider.AbstractTerracottaProvider;
import org.jackhuang.hmcl.terracotta.provider.GeneralProvider;
import org.jackhuang.hmcl.terracotta.provider.MacOSProvider;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.i18n.LocaleUtils;
import org.jackhuang.hmcl.util.i18n.LocalizedText;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OSVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.jackhuang.hmcl.util.versioning.VersionRange;
import org.jetbrains.annotations.Nullable;

public final class TerracottaMetadata {
    public static final AbstractTerracottaProvider PROVIDER;
    public static final String PACKAGE_NAME;
    public static final List<Link> PACKAGE_LINKS;
    public static final String FEEDBACK_LINK;
    private static final String LATEST;

    private TerracottaMetadata() {
    }

    @Nullable
    private static AbstractTerracottaProvider locateProvider(TerracottaBundle bundle, Options options) {
        String prefix = options.replace("terracotta-${version}-${classifier}");
        return switch (OperatingSystem.CURRENT_OS) {
            case OperatingSystem.WINDOWS -> {
                if (!OperatingSystem.SYSTEM_VERSION.isAtLeast(OSVersion.WINDOWS_10)) {
                    yield null;
                }
                yield new GeneralProvider(bundle, bundle.locate(prefix + ".exe"));
            }
            case OperatingSystem.LINUX, OperatingSystem.FREEBSD -> new GeneralProvider(bundle, bundle.locate(prefix));
            case OperatingSystem.MACOS -> new MacOSProvider(bundle, bundle.locate(prefix), bundle.locate(prefix + ".pkg"));
            default -> null;
        };
    }

    public static void removeLegacyVersionFiles() {
        try (DirectoryStream<Path> terracotta = TerracottaMetadata.collectLegacyVersionFiles();){
            if (terracotta == null) {
                return;
            }
            for (Path path : terracotta) {
                try {
                    FileUtils.deleteDirectory(path);
                }
                catch (IOException e) {
                    Logger.LOG.warning(String.format("Unable to remove legacy terracotta files: %s", path), e);
                }
            }
        }
        catch (IOException e) {
            Logger.LOG.warning("Unable to remove legacy terracotta files.", e);
        }
    }

    public static boolean hasLegacyVersionFiles() throws IOException {
        try (DirectoryStream<Path> terracotta = TerracottaMetadata.collectLegacyVersionFiles();){
            boolean bl = terracotta != null && terracotta.iterator().hasNext();
            return bl;
        }
    }

    @Nullable
    private static DirectoryStream<Path> collectLegacyVersionFiles() throws IOException {
        Path terracottaDir = Metadata.DEPENDENCIES_DIRECTORY.resolve("terracotta");
        if (Files.notExists(terracottaDir, new LinkOption[0])) {
            return null;
        }
        VersionRange<VersionNumber> range = VersionNumber.atMost(LATEST);
        return Files.newDirectoryStream(terracottaDir, path -> {
            String name = FileUtils.getName(path);
            return !LATEST.equals(name) && range.contains(VersionNumber.asVersion(name));
        });
    }

    static {
        AbstractTerracottaProvider provider;
        Config config;
        FEEDBACK_LINK = NetworkUtils.withQuery("https://docs.hmcl.net/multiplayer/feedback.html", Map.of("v", "v1", "launcher_version", Metadata.VERSION));
        try (InputStream is = TerracottaMetadata.class.getResourceAsStream("/assets/terracotta.json");){
            config = JsonUtils.fromNonNullJsonFully(is, Config.class);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        LATEST = config.latest;
        Options options = new Options(config.latest, OperatingSystem.CURRENT_OS.getCheckedName() + "-" + Architecture.SYSTEM_ARCH.getCheckedName());
        TerracottaBundle bundle = config.resolve(options);
        if (bundle == null || (provider = TerracottaMetadata.locateProvider(bundle, options)) == null) {
            PROVIDER = null;
            PACKAGE_NAME = null;
            PACKAGE_LINKS = null;
        } else {
            PROVIDER = provider;
            PACKAGE_NAME = options.replace("terracotta-${version}-${classifier}-pkg.tar.gz");
            List packageLinks = config.links.stream().map(link -> new Link(link.description, options.replace(link.link))).collect(Collectors.toList());
            Collections.shuffle(packageLinks);
            PACKAGE_LINKS = Collections.unmodifiableList(packageLinks);
        }
    }

    private record Options(String version, String classifier) {
        public String replace(String value) {
            return value.replace("${version}", this.version).replace("${classifier}", this.classifier);
        }
    }

    public record Link(@SerializedName(value="desc") LocalizedText description, @SerializedName(value="link") String link) {
    }

    private record Config(@SerializedName(value="version_latest") String latest, @SerializedName(value="packages") Map<String, Package> pkgs, @SerializedName(value="downloads") List<String> downloads, @SerializedName(value="downloads_CN") List<String> downloadsCN, @SerializedName(value="links") List<Link> links) {
        @Nullable
        private TerracottaBundle resolve(Options options) {
            Package pkg = this.pkgs.get(options.classifier);
            if (pkg == null) {
                return null;
            }
            Stream stream = this.downloads.stream();
            Stream streamCN = this.downloadsCN.stream();
            List<URI> links = (LocaleUtils.IS_CHINA_MAINLAND ? Stream.concat(streamCN, stream) : Stream.concat(stream, streamCN)).map(link -> URI.create(options.replace((String)link))).toList();
            Map<String, FileDownloadTask.IntegrityCheck> files = pkg.files.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> new FileDownloadTask.IntegrityCheck("SHA-512", (String)entry.getValue())));
            return new TerracottaBundle(Metadata.DEPENDENCIES_DIRECTORY.resolve(options.replace("terracotta/${version}")).toAbsolutePath(), links, new FileDownloadTask.IntegrityCheck("SHA-512", pkg.hash), files);
        }
    }

    private record Package(@SerializedName(value="hash") String hash, @SerializedName(value="files") Map<String, String> files) {
    }
}

