/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import org.jackhuang.hmcl.ui.FXUtils;

public class ImageContainer
extends StackPane {
    private static final String DEFAULT_STYLE_CLASS = "image-container";
    private final ImageView imageView = new ImageView();
    private final Rectangle clip = new Rectangle();
    private static final double DEFAULT_CORNER_RADIUS = 6.0;
    private StyleableDoubleProperty cornerRadius;

    public ImageContainer(double size) {
        this(size, size);
    }

    public ImageContainer(double width, double height) {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        FXUtils.setLimitWidth((Region)this, width);
        FXUtils.setLimitHeight((Region)this, height);
        this.imageView.setPreserveRatio(true);
        FXUtils.limitSize(this.imageView, width, height);
        StackPane.setAlignment((Node)this.imageView, (Pos)Pos.CENTER);
        this.clip.setWidth(width);
        this.clip.setHeight(height);
        this.updateCornerRadius(this.getCornerRadius());
        this.setClip((Node)this.clip);
        this.getChildren().setAll((Object[])new Node[]{this.imageView});
    }

    private void updateCornerRadius(double radius) {
        this.clip.setArcWidth(radius);
        this.clip.setArcHeight(radius);
    }

    public StyleableDoubleProperty cornerRadiusProperty() {
        if (this.cornerRadius == null) {
            this.cornerRadius = new StyleableDoubleProperty(){

                public Object getBean() {
                    return ImageContainer.this;
                }

                public String getName() {
                    return "cornerRadius";
                }

                public CssMetaData<? extends Styleable, Number> getCssMetaData() {
                    return StyleableProperties.CORNER_RADIUS;
                }

                protected void invalidated() {
                    ImageContainer.this.updateCornerRadius(this.get());
                }
            };
        }
        return this.cornerRadius;
    }

    public double getCornerRadius() {
        return this.cornerRadius == null ? 6.0 : this.cornerRadius.get();
    }

    public void setCornerRadius(double radius) {
        this.cornerRadiusProperty().set(radius);
    }

    public ObjectProperty<Image> imageProperty() {
        return this.imageView.imageProperty();
    }

    public Image getImage() {
        return this.imageView.getImage();
    }

    public void setImage(Image image) {
        this.imageView.setImage(image);
    }

    public BooleanProperty smoothProperty() {
        return this.imageView.smoothProperty();
    }

    public boolean isSmooth() {
        return this.imageView.isSmooth();
    }

    public void setSmooth(boolean smooth) {
        this.imageView.setSmooth(smooth);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static final class StyleableProperties {
        private static final CssMetaData<ImageContainer, Number> CORNER_RADIUS = new CssMetaData<ImageContainer, Number>("-jfx-corner-radius", SizeConverter.getInstance(), (Number)6.0){

            public boolean isSettable(ImageContainer control) {
                return control.cornerRadius == null || !control.cornerRadius.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(ImageContainer control) {
                return control.cornerRadiusProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<ImageContainer, Number>> styleables = new ArrayList<CssMetaData<ImageContainer, Number>>(StackPane.getClassCssMetaData());
            styleables.add(CORNER_RADIUS);
            STYLEABLES = List.copyOf(styleables);
        }
    }
}

