/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import java.util.Locale;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.Navigator;
import org.jackhuang.hmcl.ui.construct.PageAware;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.ui.construct.TabHeader;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.main.AboutPage;
import org.jackhuang.hmcl.ui.main.DownloadSettingsPage;
import org.jackhuang.hmcl.ui.main.FeedbackPage;
import org.jackhuang.hmcl.ui.main.HelpPage;
import org.jackhuang.hmcl.ui.main.JavaManagementPage;
import org.jackhuang.hmcl.ui.main.PersonalizationPage;
import org.jackhuang.hmcl.ui.main.SettingsPage;
import org.jackhuang.hmcl.ui.versions.VersionSettingsPage;
import org.jackhuang.hmcl.util.i18n.I18n;

public class LauncherSettingsPage
extends DecoratorAnimatedPage
implements DecoratorPage,
PageAware {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(I18n.i18n("settings")));
    private final TabHeader tab;
    private final TabControl.Tab<VersionSettingsPage> gameTab = new TabControl.Tab("versionSettingsPage");
    private final TabControl.Tab<JavaManagementPage> javaManagementTab = new TabControl.Tab("javaManagementPage");
    private final TabControl.Tab<SettingsPage> settingsTab = new TabControl.Tab("settingsPage");
    private final TabControl.Tab<PersonalizationPage> personalizationTab = new TabControl.Tab("personalizationPage");
    private final TabControl.Tab<DownloadSettingsPage> downloadTab = new TabControl.Tab("downloadSettingsPage");
    private final TabControl.Tab<HelpPage> helpTab = new TabControl.Tab("helpPage");
    private final TabControl.Tab<AboutPage> aboutTab = new TabControl.Tab("aboutPage");
    private final TabControl.Tab<FeedbackPage> feedbackTab = new TabControl.Tab("feedbackPage");
    private final TransitionPane transitionPane = new TransitionPane();

    public LauncherSettingsPage() {
        this.gameTab.setNodeSupplier(() -> new VersionSettingsPage(true));
        this.javaManagementTab.setNodeSupplier(JavaManagementPage::new);
        this.settingsTab.setNodeSupplier(SettingsPage::new);
        this.personalizationTab.setNodeSupplier(PersonalizationPage::new);
        this.downloadTab.setNodeSupplier(DownloadSettingsPage::new);
        this.helpTab.setNodeSupplier(HelpPage::new);
        this.feedbackTab.setNodeSupplier(FeedbackPage::new);
        this.aboutTab.setNodeSupplier(AboutPage::new);
        this.tab = new TabHeader(this.transitionPane, this.gameTab, this.javaManagementTab, this.settingsTab, this.personalizationTab, this.downloadTab, this.helpTab, this.feedbackTab, this.aboutTab);
        this.tab.select(this.gameTab);
        this.addEventHandler(Navigator.NavigationEvent.NAVIGATED, event -> this.gameTab.getNode().loadVersion(Profiles.getSelectedProfile(), null));
        AdvancedListBox sideBar = new AdvancedListBox().addNavigationDrawerTab(this.tab, this.gameTab, I18n.i18n("settings.type.global.manage"), SVG.STADIA_CONTROLLER, SVG.STADIA_CONTROLLER_FILL).addNavigationDrawerTab(this.tab, this.javaManagementTab, I18n.i18n("java.management"), SVG.LOCAL_CAFE, SVG.LOCAL_CAFE_FILL).startCategory(I18n.i18n("launcher").toUpperCase(Locale.ROOT)).addNavigationDrawerTab(this.tab, this.settingsTab, I18n.i18n("settings.launcher.general"), SVG.TUNE).addNavigationDrawerTab(this.tab, this.personalizationTab, I18n.i18n("settings.launcher.appearance"), SVG.STYLE, SVG.STYLE_FILL).addNavigationDrawerTab(this.tab, this.downloadTab, I18n.i18n("download"), SVG.DOWNLOAD).startCategory(I18n.i18n("help").toUpperCase(Locale.ROOT)).addNavigationDrawerTab(this.tab, this.helpTab, I18n.i18n("help"), SVG.HELP, SVG.HELP_FILL).addNavigationDrawerTab(this.tab, this.feedbackTab, I18n.i18n("contact"), SVG.FEEDBACK, SVG.FEEDBACK_FILL).addNavigationDrawerTab(this.tab, this.aboutTab, I18n.i18n("about"), SVG.INFO, SVG.INFO_FILL);
        FXUtils.setLimitWidth((Region)sideBar, 200.0);
        this.setLeft(new Node[]{sideBar});
        this.setCenter(new Node[]{this.transitionPane});
    }

    @Override
    public void onPageShown() {
        this.tab.onPageShown();
    }

    @Override
    public void onPageHidden() {
        this.tab.onPageHidden();
    }

    public void showGameSettings(Profile profile) {
        this.gameTab.getNode().loadVersion(profile, null);
        this.tab.select(this.gameTab, false);
    }

    public void showFeedback() {
        this.tab.select(this.feedbackTab, false);
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }
}

