/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXRadioButton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.EnumCommonDirectory;
import org.jackhuang.hmcl.setting.Settings;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.ComponentSublist;
import org.jackhuang.hmcl.ui.construct.LineSelectButton;
import org.jackhuang.hmcl.ui.construct.LineToggleButton;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.MultiFileItem;
import org.jackhuang.hmcl.upgrade.RemoteVersion;
import org.jackhuang.hmcl.upgrade.UpdateChannel;
import org.jackhuang.hmcl.upgrade.UpdateChecker;
import org.jackhuang.hmcl.upgrade.UpdateHandler;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.i18n.SupportedLocale;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.javafx.ExtendedProperties;
import org.jackhuang.hmcl.util.logging.Logger;
import org.tukaani.xz.XZInputStream;

public final class SettingsPage
extends ScrollPane {
    private final ToggleGroup updateChannelGroup;
    private final InvalidationListener updateListener;

    public SettingsPage() {
        this.setFitToWidth(true);
        VBox rootPane = new VBox();
        rootPane.setPadding(new Insets(10.0));
        this.setContent((Node)rootPane);
        FXUtils.smoothScrolling(this);
        ComponentList settingsPane = new ComponentList();
        StackPane sponsorPane = new StackPane();
        sponsorPane.setCursor(Cursor.HAND);
        FXUtils.onClicked((Node)sponsorPane, this::onSponsor);
        sponsorPane.setPadding(new Insets(8.0, 0.0, 8.0, 0.0));
        GridPane gridPane = new GridPane();
        ColumnConstraints col = new ColumnConstraints();
        col.setHgrow(Priority.SOMETIMES);
        col.setMaxWidth(Double.POSITIVE_INFINITY);
        gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{col});
        RowConstraints row = new RowConstraints();
        row.setMinHeight(Double.NEGATIVE_INFINITY);
        row.setValignment(VPos.TOP);
        row.setVgrow(Priority.SOMETIMES);
        gridPane.getRowConstraints().setAll((Object[])new RowConstraints[]{row});
        Label label = new Label(I18n.i18n("sponsor.hmcl"));
        label.setWrapText(true);
        label.setTextAlignment(TextAlignment.JUSTIFY);
        GridPane.setRowIndex((Node)label, (Integer)0);
        GridPane.setColumnIndex((Node)label, (Integer)0);
        gridPane.getChildren().add((Object)label);
        sponsorPane.getChildren().setAll((Object[])new Node[]{gridPane});
        settingsPane.getContent().add((Object)sponsorPane);
        ComponentSublist updatePane = new ComponentSublist();
        updatePane.setTitle(I18n.i18n("update"));
        updatePane.setHasSubtitle(true);
        VBox headerLeft = new VBox();
        Label lblUpdate = new Label(I18n.i18n("update"));
        lblUpdate.getStyleClass().add((Object)"title-label");
        Label lblUpdateSub = new Label();
        lblUpdateSub.getStyleClass().add((Object)"subtitle-label");
        headerLeft.getChildren().setAll((Object[])new Node[]{lblUpdate, lblUpdateSub});
        updatePane.setHeaderLeft((Node)headerLeft);
        JFXButton btnUpdate = FXUtils.newToggleButton4(SVG.UPDATE, 20);
        btnUpdate.setOnAction(e -> this.onUpdate());
        FXUtils.installFastTooltip((Node)btnUpdate, I18n.i18n("update.tooltip"));
        this.updateListener = any -> {
            btnUpdate.setVisible(UpdateChecker.isOutdated());
            if (UpdateChecker.isOutdated()) {
                lblUpdateSub.setText(I18n.i18n("update.newest_version", UpdateChecker.getLatestVersion().getVersion()));
                lblUpdateSub.getStyleClass().setAll((Object[])new String[]{"update-label"});
                lblUpdate.setText(I18n.i18n("update.found"));
                lblUpdate.getStyleClass().setAll((Object[])new String[]{"update-label"});
            } else if (UpdateChecker.isCheckingUpdate()) {
                lblUpdateSub.setText(I18n.i18n("update.checking"));
                lblUpdateSub.getStyleClass().setAll((Object[])new String[]{"subtitle-label"});
                lblUpdate.setText(I18n.i18n("update"));
                lblUpdate.getStyleClass().setAll((Object[])new String[]{"title-label"});
            } else {
                lblUpdateSub.setText(I18n.i18n("update.latest"));
                lblUpdateSub.getStyleClass().setAll((Object[])new String[]{"subtitle-label"});
                lblUpdate.setText(I18n.i18n("update"));
                lblUpdate.getStyleClass().setAll((Object[])new String[]{"title-label"});
            }
        };
        UpdateChecker.latestVersionProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.updateListener));
        UpdateChecker.outdatedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.updateListener));
        UpdateChecker.checkingUpdateProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.updateListener));
        this.updateListener.invalidated(null);
        updatePane.setHeaderRight((Node)btnUpdate);
        VBox content = new VBox(12.0);
        content.setPadding(new Insets(8.0, 0.0, 0.0, 0.0));
        this.updateChannelGroup = new ToggleGroup();
        JFXRadioButton chkUpdateStable = new JFXRadioButton(I18n.i18n("update.channel.stable"));
        chkUpdateStable.setUserData((Object)UpdateChannel.STABLE);
        chkUpdateStable.setToggleGroup(this.updateChannelGroup);
        JFXRadioButton chkUpdateDev = new JFXRadioButton(I18n.i18n("update.channel.dev"));
        chkUpdateDev.setUserData((Object)UpdateChannel.DEVELOPMENT);
        chkUpdateDev.setToggleGroup(this.updateChannelGroup);
        Label noteWrapper = new Label(I18n.i18n("update.note"));
        VBox.setMargin((Node)noteWrapper, (Insets)new Insets(8.0, 0.0, 0.0, 0.0));
        content.getChildren().setAll((Object[])new Node[]{chkUpdateStable, chkUpdateDev, noteWrapper});
        updatePane.getContent().add((Object)content);
        settingsPane.getContent().add((Object)updatePane);
        LineToggleButton previewPane = new LineToggleButton();
        previewPane.setTitle(I18n.i18n("update.preview"));
        previewPane.setSubtitle(I18n.i18n("update.preview.subtitle"));
        previewPane.selectedProperty().bindBidirectional((Property)ConfigHolder.config().acceptPreviewUpdateProperty());
        ObjectProperty<UpdateChannel> updateChannel = ExtendedProperties.selectedItemPropertyFor(this.updateChannelGroup, UpdateChannel.class);
        updateChannel.set((Object)UpdateChannel.getChannel());
        InvalidationListener checkUpdateListener = e -> UpdateChecker.requestCheckUpdate((UpdateChannel)((Object)((Object)updateChannel.get())), previewPane.isSelected());
        updateChannel.addListener(checkUpdateListener);
        previewPane.selectedProperty().addListener(checkUpdateListener);
        settingsPane.getContent().add((Object)previewPane);
        MultiFileItem fileCommonLocation = new MultiFileItem();
        fileCommonLocation.loadChildren(Arrays.asList(new MultiFileItem.Option<EnumCommonDirectory>(I18n.i18n("launcher.cache_directory.default"), EnumCommonDirectory.DEFAULT), new MultiFileItem.FileOption<EnumCommonDirectory>(I18n.i18n("settings.custom"), EnumCommonDirectory.CUSTOM).setChooserTitle(I18n.i18n("launcher.cache_directory.choose")).setDirectory(true).bindBidirectional((Property<String>)ConfigHolder.config().commonDirectoryProperty())));
        fileCommonLocation.selectedDataProperty().bindBidirectional(ConfigHolder.config().commonDirTypeProperty());
        ComponentSublist fileCommonLocationSublist = new ComponentSublist();
        fileCommonLocationSublist.getContent().add(fileCommonLocation);
        fileCommonLocationSublist.setTitle(I18n.i18n("launcher.cache_directory"));
        fileCommonLocationSublist.setHasSubtitle(true);
        fileCommonLocationSublist.subtitleProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> Optional.ofNullable(Settings.instance().getCommonDirectory()).orElse(I18n.i18n("launcher.cache_directory.disabled")), (Observable[])new Observable[]{ConfigHolder.config().commonDirectoryProperty(), ConfigHolder.config().commonDirTypeProperty()}));
        JFXButton cleanButton = FXUtils.newBorderButton(I18n.i18n("launcher.cache_directory.clean"));
        cleanButton.setOnAction(e -> this.clearCacheDirectory());
        fileCommonLocationSublist.setHeaderRight((Node)cleanButton);
        settingsPane.getContent().add((Object)fileCommonLocationSublist);
        LineSelectButton<SupportedLocale> chooseLanguagePane = new LineSelectButton<SupportedLocale>();
        chooseLanguagePane.setTitle(I18n.i18n("settings.launcher.language"));
        chooseLanguagePane.setSubtitle(I18n.i18n("settings.take_effect_after_restart"));
        SupportedLocale currentLocale = I18n.getLocale();
        chooseLanguagePane.setConverter(locale -> {
            if (locale.isDefault()) {
                return locale.getDisplayName(currentLocale);
            }
            if (locale.isSameLanguage(currentLocale)) {
                return locale.getDisplayName((SupportedLocale)locale);
            }
            return locale.getDisplayName(currentLocale) + " - " + locale.getDisplayName((SupportedLocale)locale);
        });
        chooseLanguagePane.setItems((Collection<SupportedLocale>)SupportedLocale.getSupportedLocales());
        chooseLanguagePane.valueProperty().bindBidirectional(ConfigHolder.config().localizationProperty());
        settingsPane.getContent().add(chooseLanguagePane);
        LineToggleButton disableAutoGameOptionsPane = new LineToggleButton();
        disableAutoGameOptionsPane.setTitle(I18n.i18n("settings.launcher.disable_auto_game_options"));
        disableAutoGameOptionsPane.selectedProperty().bindBidirectional((Property)ConfigHolder.config().disableAutoGameOptionsProperty());
        settingsPane.getContent().add((Object)disableAutoGameOptionsPane);
        BorderPane debugPane = new BorderPane();
        Label left = new Label(I18n.i18n("settings.launcher.debug"));
        BorderPane.setAlignment((Node)left, (Pos)Pos.CENTER_LEFT);
        debugPane.setLeft((Node)left);
        JFXButton openLogFolderButton = new JFXButton(I18n.i18n("settings.launcher.launcher_log.reveal"));
        openLogFolderButton.setOnAction(e -> this.openLogFolder());
        openLogFolderButton.getStyleClass().add((Object)"jfx-button-border");
        if (Logger.LOG.getLogFile() == null) {
            openLogFolderButton.setDisable(true);
        }
        JFXButton logButton = FXUtils.newBorderButton(I18n.i18n("settings.launcher.launcher_log.export"));
        logButton.setOnAction(e -> this.onExportLogs());
        HBox buttonBox = new HBox();
        buttonBox.setSpacing(10.0);
        buttonBox.getChildren().addAll((Object[])new Node[]{openLogFolderButton, logButton});
        BorderPane.setAlignment((Node)buttonBox, (Pos)Pos.CENTER_RIGHT);
        debugPane.setRight((Node)buttonBox);
        settingsPane.getContent().add((Object)debugPane);
        rootPane.getChildren().add((Object)settingsPane);
    }

    private void openLogFolder() {
        FXUtils.openFolder(Logger.LOG.getLogFile().getParent());
    }

    private void onUpdate() {
        RemoteVersion target = UpdateChecker.getLatestVersion();
        if (target == null) {
            return;
        }
        UpdateHandler.updateFrom(target);
    }

    private static String getEntryName(Set<String> entryNames, String name) {
        if (entryNames.add(name)) {
            return name;
        }
        long i = 1L;
        String newName;
        while (!entryNames.add(newName = name + "." + i)) {
            ++i;
        }
        return newName;
    }

    private static boolean exportLogFile(ZipOutputStream output, Path file, String entryName, InputStream input, byte[] buffer) throws IOException {
        try {
            output.putNextEntry(new ZipEntry(entryName));
            while (true) {
                int read;
                try {
                    read = input.read(buffer);
                    if (read <= 0) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (Throwable ex) {
                    Logger.LOG.warning("Failed to decompress log file " + String.valueOf(file), ex);
                    boolean bl = false;
                    return bl;
                }
                output.write(buffer, 0, read);
            }
        }
        finally {
            try {
                input.close();
            }
            catch (Throwable ex) {
                Logger.LOG.warning("Failed to close log file " + String.valueOf(file), ex);
            }
            output.closeEntry();
        }
    }

    private void onExportLogs() {
        Lang.thread(() -> {
            Path outputFile;
            block26: {
                String nameBase = "hmcl-exported-logs-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss"));
                List<Path> recentLogFiles = Logger.LOG.findRecentLogFiles(5);
                try {
                    if (recentLogFiles.isEmpty()) {
                        outputFile = Metadata.CURRENT_DIRECTORY.resolve(nameBase + ".log");
                        Logger.LOG.info("Exporting latest logs to " + String.valueOf(outputFile));
                        try (OutputStream output = Files.newOutputStream(outputFile, new OpenOption[0]);){
                            Logger.LOG.exportLogs(output);
                            break block26;
                        }
                    }
                    outputFile = Metadata.CURRENT_DIRECTORY.resolve(nameBase + ".zip");
                    Logger.LOG.info("Exporting latest logs to " + String.valueOf(outputFile));
                    byte[] buffer = new byte[8192];
                    try (OutputStream os = Files.newOutputStream(outputFile, new OpenOption[0]);
                         ZipOutputStream zos = new ZipOutputStream(os);){
                        HashSet<String> entryNames = new HashSet<String>();
                        for (Path path : recentLogFiles) {
                            InputStream input;
                            String fileName = FileUtils.getName(path);
                            String extension = StringUtils.substringAfterLast(fileName, '.');
                            if ("gz".equals(extension) || "xz".equals(extension)) {
                                input = null;
                                try {
                                    input = Files.newInputStream(path, new OpenOption[0]);
                                    input = "gz".equals(extension) ? new GZIPInputStream(input) : new XZInputStream(input);
                                }
                                catch (Throwable ex) {
                                    Logger.LOG.warning("Failed to open log file " + String.valueOf(path), ex);
                                    IOUtils.closeQuietly(input, ex);
                                    input = null;
                                }
                                String entryName = SettingsPage.getEntryName(entryNames, StringUtils.substringBeforeLast(fileName, "."));
                                if (input != null && SettingsPage.exportLogFile(zos, path, entryName, input, buffer)) continue;
                            }
                            try {
                                input = Files.newInputStream(path, new OpenOption[0]);
                            }
                            catch (Throwable ex) {
                                Logger.LOG.warning("Failed to open log file " + String.valueOf(path), ex);
                                continue;
                            }
                            SettingsPage.exportLogFile(zos, path, SettingsPage.getEntryName(entryNames, fileName), input, buffer);
                        }
                        zos.putNextEntry(new ZipEntry(SettingsPage.getEntryName(entryNames, "hmcl-latest.log")));
                        Logger.LOG.exportLogs(zos);
                        zos.closeEntry();
                    }
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to export logs", e);
                    Platform.runLater(() -> Controllers.dialog(I18n.i18n("settings.launcher.launcher_log.export.failed") + "\n" + StringUtils.getStackTrace(e), null, MessageDialogPane.MessageType.ERROR));
                    return;
                }
            }
            Platform.runLater(() -> Controllers.dialog(I18n.i18n("settings.launcher.launcher_log.export.success", outputFile)));
            FXUtils.showFileInExplorer(outputFile);
        });
    }

    private void onSponsor() {
        FXUtils.openLink("https://github.com/HMCL-dev/HMCL");
    }

    private void clearCacheDirectory() {
        String commonDirectory = Settings.instance().getCommonDirectory();
        if (commonDirectory != null) {
            FileUtils.cleanDirectoryQuietly(Path.of(commonDirectory, "cache"));
        }
    }
}

