/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXListView;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.Skin;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.resourcepack.ResourcepackFile;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.construct.ImageContainer;
import org.jackhuang.hmcl.ui.construct.MDListCell;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class ResourcepackListPage
extends ListPageBase<ResourcepackInfoObject>
implements VersionPage.VersionLoadable {
    private Path resourcepackDirectory;

    public ResourcepackListPage() {
        FXUtils.applyDragListener((Node)this, file -> file.getFileName().toString().endsWith(".zip"), this::addFiles);
    }

    protected Skin<?> createDefaultSkin() {
        return new ResourcepackListPageSkin(this);
    }

    @Override
    public void loadVersion(Profile profile, String version) {
        this.resourcepackDirectory = profile.getRepository().getResourcepacksDirectory(version);
        try {
            if (!Files.exists(this.resourcepackDirectory, new LinkOption[0])) {
                Files.createDirectories(this.resourcepackDirectory, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to create resourcepack directory" + String.valueOf(this.resourcepackDirectory), e);
        }
        this.refresh();
    }

    public void refresh() {
        if (this.resourcepackDirectory == null || !Files.isDirectory(this.resourcepackDirectory, new LinkOption[0])) {
            return;
        }
        this.setLoading(true);
        Task.supplyAsync(Schedulers.io(), () -> {
            try (Stream<Path> stream = Files.list(this.resourcepackDirectory);){
                List list = stream.sorted(Comparator.comparing(FileUtils::getName)).flatMap(item -> {
                    try {
                        return Stream.of(ResourcepackFile.parse(item)).filter(Objects::nonNull).map(ResourcepackInfoObject::new);
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Failed to load resourcepack " + String.valueOf(item), e);
                        return Stream.empty();
                    }
                }).toList();
                return list;
            }
        }).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception == null) {
                this.getItems().setAll((Collection)result);
            } else {
                Logger.LOG.warning("Failed to load resourcepacks", exception);
                this.getItems().clear();
            }
            this.setLoading(false);
        }).start();
    }

    public void addFiles(List<Path> files) {
        if (this.resourcepackDirectory == null) {
            return;
        }
        try {
            for (Path file : files) {
                Path target = this.resourcepackDirectory.resolve(file.getFileName());
                if (Files.exists(target, new LinkOption[0])) continue;
                Files.copy(file, target, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to add resourcepacks", e);
            Controllers.dialog(I18n.i18n("resourcepack.add.failed"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
        }
        this.refresh();
    }

    public void onAddFiles() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(I18n.i18n("resourcepack.add.title"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("extension.resourcepack"), new String[]{"*.zip"}));
        List<Path> files = FileUtils.toPaths(fileChooser.showOpenMultipleDialog((Window)Controllers.getStage()));
        if (files != null && !files.isEmpty()) {
            this.addFiles(files);
        }
    }

    private void onDownload() {
        Controllers.getDownloadPage().showResourcepackDownloads();
        Controllers.navigate((Node)Controllers.getDownloadPage());
    }

    private static final class ResourcepackListPageSkin
    extends ToolbarListPageSkin<ResourcepackInfoObject, ResourcepackListPage> {
        public ResourcepackListPageSkin(ResourcepackListPage control) {
            super(control);
        }

        @Override
        protected List<Node> initializeToolbar(ResourcepackListPage skinnable) {
            return List.of(ResourcepackListPageSkin.createToolbarButton2(I18n.i18n("button.refresh"), SVG.REFRESH, skinnable::refresh), ResourcepackListPageSkin.createToolbarButton2(I18n.i18n("resourcepack.add"), SVG.ADD, skinnable::onAddFiles), ResourcepackListPageSkin.createToolbarButton2(I18n.i18n("resourcepack.download"), SVG.DOWNLOAD, skinnable::onDownload));
        }

        @Override
        protected ListCell<ResourcepackInfoObject> createListCell(JFXListView<ResourcepackInfoObject> listView) {
            return new ResourcepackListCell(listView, (ResourcepackListPage)this.getSkinnable());
        }
    }

    private static final class ResourcepackListCell
    extends MDListCell<ResourcepackInfoObject> {
        private final ImageContainer imageView = new ImageContainer(32.0);
        private final TwoLineListItem content = new TwoLineListItem();
        private final JFXButton btnReveal = FXUtils.newToggleButton4(SVG.FOLDER_OPEN);
        private final JFXButton btnDelete = FXUtils.newToggleButton4(SVG.DELETE_FOREVER);
        private final ResourcepackListPage page;

        public ResourcepackListCell(JFXListView<ResourcepackInfoObject> listView, ResourcepackListPage page) {
            super(listView);
            this.page = page;
            BorderPane root = new BorderPane();
            root.getStyleClass().add((Object)"md-list-cell");
            root.setPadding(new Insets(8.0));
            HBox left = new HBox(8.0);
            left.setAlignment(Pos.CENTER);
            left.getChildren().add((Object)this.imageView);
            left.setPadding(new Insets(0.0, 8.0, 0.0, 0.0));
            FXUtils.setLimitWidth((Region)left, 48.0);
            root.setLeft((Node)left);
            HBox.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
            root.setCenter((Node)this.content);
            HBox right = new HBox(8.0);
            right.setAlignment(Pos.CENTER_RIGHT);
            right.getChildren().setAll((Object[])new Node[]{this.btnReveal, this.btnDelete});
            root.setRight((Node)right);
            this.getContainer().getChildren().add((Object)new RipplerContainer((Node)root));
        }

        @Override
        protected void updateControl(ResourcepackInfoObject item, boolean empty) {
            if (empty || item == null) {
                return;
            }
            ResourcepackFile file = item.getFile();
            this.imageView.setImage(item.getIcon());
            this.content.setTitle(file.getName());
            LocalModFile.Description description = file.getDescription();
            this.content.setSubtitle(description != null ? description.toString() : "");
            FXUtils.installFastTooltip((Node)this.btnReveal, I18n.i18n("reveal.in_file_manager"));
            this.btnReveal.setOnAction(event -> FXUtils.showFileInExplorer(file.getPath()));
            this.btnDelete.setOnAction(event -> Controllers.confirm(I18n.i18n("button.remove.confirm"), I18n.i18n("button.remove"), () -> this.onDelete(file), null));
        }

        private void onDelete(ResourcepackFile file) {
            try {
                if (Files.isDirectory(file.getPath(), new LinkOption[0])) {
                    FileUtils.deleteDirectory(file.getPath());
                } else {
                    Files.delete(file.getPath());
                }
                this.page.refresh();
            }
            catch (IOException e) {
                Controllers.dialog(I18n.i18n("resourcepack.delete.failed", e.getMessage()), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
                Logger.LOG.warning("Failed to delete resourcepack", e);
            }
        }
    }

    public static class ResourcepackInfoObject {
        private final ResourcepackFile file;
        private WeakReference<Image> iconCache;

        public ResourcepackInfoObject(ResourcepackFile file) {
            this.file = file;
        }

        public ResourcepackFile getFile() {
            return this.file;
        }

        Image getIcon() {
            Image image = null;
            if (this.iconCache != null && (image = (Image)this.iconCache.get()) != null) {
                return image;
            }
            byte[] iconData = this.file.getIcon();
            if (iconData != null) {
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(iconData);){
                    image = new Image((InputStream)inputStream, 64.0, 64.0, true, true);
                }
                catch (Exception e) {
                    Logger.LOG.warning("Failed to load resourcepack icon " + String.valueOf(this.file.getPath()), e);
                }
            }
            if (image == null || image.isError() || image.getWidth() <= 0.0 || image.getHeight() <= 0.0 || Math.abs(image.getWidth() - image.getHeight()) >= 1.0) {
                image = FXUtils.newBuiltinImage("/assets/img/unknown_pack.png");
            }
            this.iconCache = new WeakReference<Image>(image);
            return image;
        }
    }
}

