/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.versioning;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.util.ToStringBuilder;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.jackhuang.hmcl.util.versioning.VersionRange;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class GameVersionNumber
implements Comparable<GameVersionNumber> {
    final String value;
    final String normalized;

    public static String[] getDefaultGameVersions() {
        return Versions.DEFAULT_GAME_VERSIONS;
    }

    public static GameVersionNumber asGameVersion(String version) {
        GameVersionNumber versionNumber = Versions.SPECIALS.get(version);
        if (versionNumber != null) {
            return versionNumber;
        }
        try {
            if (!version.isEmpty()) {
                char ch = version.charAt(0);
                switch (ch) {
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'i': 
                    case 'r': {
                        return Old.parse(version);
                    }
                }
                if (version.equals("0.0")) {
                    return Release.ZERO;
                }
                if (version.length() >= 6 && version.charAt(2) == 'w') {
                    return LegacySnapshot.parse(version);
                }
                return Release.parse(version);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new Special(version, version);
    }

    public static GameVersionNumber asGameVersion(Optional<String> version) {
        return version.isPresent() ? GameVersionNumber.asGameVersion(version.get()) : GameVersionNumber.unknown();
    }

    public static GameVersionNumber unknown() {
        return Release.ZERO;
    }

    public static int compare(String version1, String version2) {
        return GameVersionNumber.asGameVersion(version1).compareTo(GameVersionNumber.asGameVersion(version2));
    }

    public static VersionRange<GameVersionNumber> between(String minimum, String maximum) {
        return VersionRange.between(GameVersionNumber.asGameVersion(minimum), GameVersionNumber.asGameVersion(maximum));
    }

    public static VersionRange<GameVersionNumber> atLeast(String minimum) {
        return VersionRange.atLeast(GameVersionNumber.asGameVersion(minimum));
    }

    public static VersionRange<GameVersionNumber> atMost(String maximum) {
        return VersionRange.atMost(GameVersionNumber.asGameVersion(maximum));
    }

    GameVersionNumber(String value, String normalized) {
        this.value = value;
        this.normalized = normalized;
    }

    public boolean isAprilFools() {
        if (this instanceof Special) {
            String normalizedVersion = this.toNormalizedString();
            return !normalizedVersion.startsWith("1.") && !normalizedVersion.equals("13w12~") || normalizedVersion.equals("1.RV-Pre1");
        }
        GameVersionNumber gameVersionNumber = this;
        if (gameVersionNumber instanceof LegacySnapshot) {
            LegacySnapshot snapshot = (LegacySnapshot)gameVersionNumber;
            return snapshot.intValue == LegacySnapshot.toInt(15, 14, 'a', false);
        }
        return false;
    }

    abstract Type getType();

    abstract int compareToImpl(@NotNull GameVersionNumber var1);

    @Override
    public int compareTo(@NotNull String other) {
        return this.compareTo(GameVersionNumber.asGameVersion(other));
    }

    @Override
    public int compareTo(@NotNull GameVersionNumber other) {
        if (this.getType() != other.getType()) {
            return Integer.compare(this.getType().ordinal(), other.getType().ordinal());
        }
        return this.compareToImpl(other);
    }

    public boolean isAtLeast(@NotNull String releaseVersion, @NotNull String snapshotVersion) {
        return this.isAtLeast(releaseVersion, snapshotVersion, false);
    }

    public boolean isAtLeast(@NotNull String releaseVersion, @NotNull String snapshotVersion, boolean strictReleaseVersion) {
        GameVersionNumber gameVersionNumber = this;
        if (gameVersionNumber instanceof Release) {
            Release self = (Release)gameVersionNumber;
            Release other = strictReleaseVersion ? Release.parse(releaseVersion) : Release.parseSimple(releaseVersion);
            return self.compareToRelease(other) >= 0;
        }
        return this.compareTo(LegacySnapshot.parse(snapshotVersion)) >= 0;
    }

    public String toNormalizedString() {
        return this.normalized;
    }

    public String toString() {
        return this.value;
    }

    protected ToStringBuilder buildDebugString() {
        return new ToStringBuilder(this).append("value", this.value).append("normalized", this.normalized).append("type", (Object)this.getType());
    }

    public final String toDebugString() {
        return this.buildDebugString().toString();
    }

    static final class Versions {
        static final HashMap<String, Special> SPECIALS;
        static final String[] DEFAULT_GAME_VERSIONS;
        static final int[] SNAPSHOT_INTS;
        static final Release[] SNAPSHOT_PREV;

        Versions() {
        }

        static {
            BufferedReader reader;
            SPECIALS = new HashMap();
            ArrayDeque<String> defaultGameVersions = new ArrayDeque<String>(64);
            ArrayList<LegacySnapshot> snapshots = new ArrayList<LegacySnapshot>(1024);
            ArrayList<Release> snapshotPrev = new ArrayList<Release>(1024);
            try {
                reader = new BufferedReader(new InputStreamReader(GameVersionNumber.class.getResourceAsStream("/assets/game/versions.txt"), StandardCharsets.US_ASCII));
                try {
                    String line;
                    Release currentRelease = null;
                    GameVersionNumber prev = null;
                    while ((line = reader.readLine()) != null) {
                        if (line.isEmpty()) continue;
                        GameVersionNumber version = GameVersionNumber.asGameVersion(line);
                        if (currentRelease == null) {
                            currentRelease = (Release)version;
                        }
                        if (version instanceof LegacySnapshot) {
                            LegacySnapshot snapshot = (LegacySnapshot)version;
                            snapshots.add(snapshot);
                            snapshotPrev.add(currentRelease);
                        } else if (version instanceof Release) {
                            Release release;
                            currentRelease = release = (Release)version;
                            if (currentRelease.eaType == Release.ReleaseType.GA && currentRelease.additional == Release.Additional.NONE) {
                                defaultGameVersions.addFirst(currentRelease.value);
                            }
                        } else if (version instanceof Special) {
                            Special special = (Special)version;
                            special.prev = prev;
                            SPECIALS.put(special.value, special);
                        } else {
                            throw new AssertionError((Object)("version: " + String.valueOf(version)));
                        }
                        prev = version;
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            try {
                reader = new BufferedReader(new InputStreamReader(GameVersionNumber.class.getResourceAsStream("/assets/game/version-alias.csv"), StandardCharsets.US_ASCII));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.isEmpty()) continue;
                        String[] parts = line.split(",");
                        if (parts.length < 2) {
                            Logger.LOG.warning("Invalid line: " + line);
                            continue;
                        }
                        String normalized = parts[0];
                        Special normalizedVersion = SPECIALS.get(normalized);
                        if (normalizedVersion == null) {
                            Logger.LOG.warning("Unknown special version: " + normalized);
                            continue;
                        }
                        for (int i = 1; i < parts.length; ++i) {
                            String version = parts[i];
                            Special versionNumber = new Special(version, normalized);
                            versionNumber.prev = normalizedVersion.prev;
                            SPECIALS.put(version, versionNumber);
                        }
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            DEFAULT_GAME_VERSIONS = defaultGameVersions.toArray(new String[0]);
            SNAPSHOT_INTS = new int[snapshots.size()];
            for (int i = 0; i < snapshots.size(); ++i) {
                Versions.SNAPSHOT_INTS[i] = ((LegacySnapshot)snapshots.get((int)i)).intValue;
            }
            SNAPSHOT_PREV = snapshotPrev.toArray(new Release[SNAPSHOT_INTS.length]);
        }
    }

    public static final class Old
    extends GameVersionNumber {
        final Type type;
        final VersionNumber versionNumber;

        static Old parse(String value) {
            Type type;
            if (value.isEmpty()) {
                throw new IllegalArgumentException("Empty old version number");
            }
            int prefixLength = 1;
            switch (value.charAt(0)) {
                case 'r': {
                    if (!value.startsWith("rd-")) {
                        throw new IllegalArgumentException(value);
                    }
                    type = Type.PRE_CLASSIC;
                    prefixLength = "rd-".length();
                    break;
                }
                case 'i': {
                    if (value.startsWith("inf-")) {
                        type = Type.INFDEV;
                        prefixLength = "inf-".length();
                        break;
                    }
                    if (value.startsWith("in-")) {
                        type = Type.INDEV;
                        prefixLength = "in-".length();
                        break;
                    }
                    throw new IllegalArgumentException(value);
                }
                case 'a': {
                    type = Type.ALPHA;
                    break;
                }
                case 'b': {
                    type = Type.BETA;
                    break;
                }
                case 'c': {
                    type = Type.CLASSIC;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(value);
                }
            }
            if (value.length() < prefixLength + 1 || !Character.isDigit(value.charAt(prefixLength))) {
                throw new IllegalArgumentException(value);
            }
            return new Old(value, type, VersionNumber.asVersion(value.substring(prefixLength)));
        }

        private Old(String value, Type type, VersionNumber versionNumber) {
            super(value, value);
            this.type = type;
            this.versionNumber = versionNumber;
        }

        @Override
        Type getType() {
            return this.type;
        }

        @Override
        int compareToImpl(@NotNull GameVersionNumber other) {
            return this.versionNumber.compareTo(((Old)other).versionNumber);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.versionNumber});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof Old)) return false;
            Old that = (Old)o;
            if (this.type != that.type) return false;
            if (!this.versionNumber.equals(that.versionNumber)) return false;
            return true;
        }
    }

    public static final class Release
    extends GameVersionNumber {
        private static final int MINIMUM_YEAR_MAJOR_VERSION = 25;
        static final Release ZERO = new Release("0.0", "0.0", 0, 0, 0, ReleaseType.UNKNOWN, VersionNumber.ZERO, Additional.NONE);
        private static final Pattern VERSION_PATTERN = Pattern.compile("(?<prefix>(?<major>1|[1-9]\\d+)\\.(?<minor>\\d+)(\\.(?<patch>[0-9]+))?)(?<suffix>.*)");
        private final int major;
        private final int minor;
        private final int patch;
        private final ReleaseType eaType;
        private final VersionNumber eaVersion;
        private final Additional additional;

        static Release parse(String value) {
            String normalized;
            VersionNumber eaVersion;
            ReleaseType releaseType;
            Matcher matcher = VERSION_PATTERN.matcher(value);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(value);
            }
            int major = Integer.parseInt(matcher.group("major"));
            if (major != 1 && major < 25) {
                throw new IllegalArgumentException(value);
            }
            int minor = Integer.parseInt(matcher.group("minor"));
            String patchString = matcher.group("patch");
            int patch = patchString != null ? Integer.parseInt(patchString) : 0;
            String suffix = matcher.group("suffix");
            Additional additional = Additional.NONE;
            boolean needNormalize = false;
            if (suffix.endsWith("_unobfuscated")) {
                suffix = suffix.substring(0, suffix.length() - "_unobfuscated".length());
                additional = Additional.UNOBFUSCATED;
            } else if (suffix.endsWith(" Unobfuscated")) {
                needNormalize = true;
                suffix = suffix.substring(0, suffix.length() - " Unobfuscated".length());
                additional = Additional.UNOBFUSCATED;
            }
            if (suffix.isEmpty()) {
                releaseType = ReleaseType.GA;
                eaVersion = VersionNumber.ZERO;
            } else if (suffix.startsWith("-snapshot-")) {
                releaseType = ReleaseType.SNAPSHOT;
                eaVersion = VersionNumber.asVersion(suffix.substring("-snapshot-".length()));
            } else if (suffix.startsWith(" Snapshot ")) {
                needNormalize = true;
                releaseType = ReleaseType.SNAPSHOT;
                eaVersion = VersionNumber.asVersion(suffix.substring(" Snapshot ".length()));
            } else if (suffix.startsWith("-pre")) {
                releaseType = ReleaseType.PRE_RELEASE;
                eaVersion = VersionNumber.asVersion(suffix.substring("-pre".length()));
            } else if (suffix.startsWith(" Pre-Release ")) {
                needNormalize = true;
                releaseType = ReleaseType.PRE_RELEASE;
                eaVersion = VersionNumber.asVersion(suffix.substring(" Pre-Release ".length()));
            } else if (suffix.startsWith(" Pre-release ")) {
                needNormalize = true;
                releaseType = ReleaseType.PRE_RELEASE;
                eaVersion = VersionNumber.asVersion(suffix.substring(" Pre-release ".length()));
            } else if (suffix.startsWith("-rc")) {
                releaseType = ReleaseType.RELEASE_CANDIDATE;
                eaVersion = VersionNumber.asVersion(suffix.substring("-rc".length()));
            } else if (suffix.startsWith(" Release Candidate ")) {
                needNormalize = true;
                releaseType = ReleaseType.RELEASE_CANDIDATE;
                eaVersion = VersionNumber.asVersion(suffix.substring(" Release Candidate ".length()));
            } else {
                throw new IllegalArgumentException(value);
            }
            if (needNormalize) {
                StringBuilder builder = new StringBuilder(value.length());
                builder.append(matcher.group("prefix"));
                if (releaseType != ReleaseType.GA) {
                    builder.append(releaseType.infix);
                    builder.append(eaVersion);
                }
                builder.append(additional.suffix);
                normalized = builder.toString();
            } else {
                normalized = value;
            }
            return new Release(value, normalized, major, minor, patch, releaseType, eaVersion, additional);
        }

        static Release parseSimple(String value) {
            int majorLength = Release.getNumberLength(value, 0);
            if (majorLength == 0 || value.length() < majorLength + 2 || value.charAt(majorLength) != '.') {
                throw new IllegalArgumentException(value);
            }
            int major = Integer.parseInt(value, 0, majorLength, 10);
            if (major != 1 && major < 25) {
                throw new IllegalArgumentException(value);
            }
            int minorOffset = majorLength + 1;
            int minorLength = Release.getNumberLength(value, minorOffset);
            if (minorLength == 0) {
                throw new IllegalArgumentException(value);
            }
            try {
                int minor = Integer.parseInt(value, minorOffset, minorOffset + minorLength, 10);
                int patch = 0;
                if (minorOffset + minorLength < value.length()) {
                    int patchOffset = minorOffset + minorLength + 1;
                    if (patchOffset >= value.length() || value.charAt(patchOffset - 1) != '.') {
                        throw new IllegalArgumentException(value);
                    }
                    patch = Integer.parseInt(value, patchOffset, value.length(), 10);
                }
                return new Release(value, value, major, minor, patch, ReleaseType.UNKNOWN, VersionNumber.ZERO, Additional.NONE);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(value);
            }
        }

        private static int getNumberLength(String value, int offset) {
            char ch;
            int current;
            for (current = offset; current < value.length() && (ch = value.charAt(current)) >= '0' && ch <= '9'; ++current) {
            }
            return current - offset;
        }

        Release(String value, String normalized, int major, int minor, int patch, ReleaseType eaType, VersionNumber eaVersion, Additional additional) {
            super(value, normalized);
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.eaType = eaType;
            this.eaVersion = eaVersion;
            this.additional = additional;
        }

        @Override
        Type getType() {
            return Type.NEW;
        }

        int compareToRelease(Release other) {
            int c = Integer.compare(this.major, other.major);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.minor, other.minor);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.patch, other.patch);
            if (c != 0) {
                return c;
            }
            c = this.eaType.compareTo(other.eaType);
            if (c != 0) {
                return c;
            }
            c = this.eaVersion.compareTo(other.eaVersion);
            if (c != 0) {
                return c;
            }
            return this.additional.compareTo(other.additional);
        }

        int compareToSnapshot(LegacySnapshot other) {
            if (this.major == 0) {
                return -1;
            }
            if (this.major == 1) {
                int idx = Arrays.binarySearch(Versions.SNAPSHOT_INTS, other.intValue);
                if (idx >= 0) {
                    return this.compareToRelease(Versions.SNAPSHOT_PREV[idx]) <= 0 ? -1 : 1;
                }
                if ((idx = -(idx + 1)) == Versions.SNAPSHOT_INTS.length) {
                    return -1;
                }
                return this.compareToRelease(Versions.SNAPSHOT_PREV[idx]) <= 0 ? -1 : 1;
            }
            return 1;
        }

        @Override
        int compareToImpl(@NotNull GameVersionNumber other) {
            if (other instanceof Release) {
                Release release = (Release)other;
                return this.compareToRelease(release);
            }
            if (other instanceof LegacySnapshot) {
                LegacySnapshot snapshot = (LegacySnapshot)other;
                return this.compareToSnapshot(snapshot);
            }
            if (other instanceof Special) {
                Special special = (Special)other;
                return -special.compareToReleaseOrSnapshot(this);
            }
            throw new AssertionError(other.getClass());
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }

        public ReleaseType getEaType() {
            return this.eaType;
        }

        public VersionNumber getEaVersion() {
            return this.eaVersion;
        }

        public Additional getAdditional() {
            return this.additional;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.major, this.minor, this.patch, this.eaType, this.eaVersion, this.additional});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof Release)) return false;
            Release that = (Release)o;
            if (this.major != that.major) return false;
            if (this.minor != that.minor) return false;
            if (this.patch != that.patch) return false;
            if (this.eaType != that.eaType) return false;
            if (!this.eaVersion.equals(that.eaVersion)) return false;
            if (this.additional != that.additional) return false;
            return true;
        }

        @Override
        protected ToStringBuilder buildDebugString() {
            return super.buildDebugString().append("major", this.major).append("minor", this.minor).append("patch", this.patch).append("eaType", (Object)this.eaType).append("eaVersion", this.eaVersion).append("additional", (Object)this.additional);
        }

        public static enum Additional {
            NONE(""),
            UNOBFUSCATED("_unobfuscated");

            private final String suffix;

            private Additional(String suffix) {
                this.suffix = suffix;
            }
        }

        public static enum ReleaseType {
            UNKNOWN(""),
            SNAPSHOT("-snapshot-"),
            PRE_RELEASE("-pre"),
            RELEASE_CANDIDATE("-rc"),
            GA("");

            private final String infix;

            private ReleaseType(String infix) {
                this.infix = infix;
            }
        }
    }

    public static final class LegacySnapshot
    extends GameVersionNumber {
        final int intValue;

        static LegacySnapshot parse(String value) {
            int week;
            int year;
            Object normalized;
            boolean unobfuscated;
            int prefixLength;
            if (value.length() < 6 || value.charAt(2) != 'w') {
                throw new IllegalArgumentException(value);
            }
            if (value.endsWith("_unobfuscated")) {
                prefixLength = value.length() - "_unobfuscated".length();
                unobfuscated = true;
                normalized = value;
            } else if (value.endsWith(" Unobfuscated")) {
                prefixLength = value.length() - " Unobfuscated".length();
                unobfuscated = true;
                normalized = value.substring(0, prefixLength) + "_unobfuscated";
            } else {
                prefixLength = value.length();
                unobfuscated = false;
                normalized = value;
            }
            if (prefixLength != 6) {
                throw new IllegalArgumentException(value);
            }
            try {
                year = Integer.parseInt(value, 0, 2, 10);
                week = Integer.parseInt(value, 3, 5, 10);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(value);
            }
            char suffix = value.charAt(5);
            if (suffix < 'a' || suffix > 'z') {
                throw new IllegalArgumentException(value);
            }
            return new LegacySnapshot(value, (String)normalized, year, week, suffix, unobfuscated);
        }

        static int toInt(int year, int week, char suffix, boolean unobfuscated) {
            return year << 24 | week << 16 | suffix << 8 | (unobfuscated ? 1 : 0);
        }

        LegacySnapshot(String value, String normalized, int year, int week, char suffix, boolean unobfuscated) {
            super(value, normalized);
            this.intValue = LegacySnapshot.toInt(year, week, suffix, unobfuscated);
        }

        @Override
        Type getType() {
            return Type.NEW;
        }

        @Override
        int compareToImpl(@NotNull GameVersionNumber other) {
            if (other instanceof Release) {
                Release otherRelease = (Release)other;
                return -otherRelease.compareToSnapshot(this);
            }
            if (other instanceof LegacySnapshot) {
                LegacySnapshot otherSnapshot = (LegacySnapshot)other;
                return Integer.compare(this.intValue, otherSnapshot.intValue);
            }
            if (other instanceof Special) {
                Special otherSpecial = (Special)other;
                return -otherSpecial.compareToReleaseOrSnapshot(this);
            }
            throw new AssertionError(other.getClass());
        }

        public int getYear() {
            return this.intValue >> 24 & 0xFF;
        }

        public int getWeek() {
            return this.intValue >> 16 & 0xFF;
        }

        public char getSuffix() {
            return (char)(this.intValue >> 8 & 0xFF);
        }

        public boolean isUnobfuscated() {
            return (this.intValue & 1) != 0;
        }

        public int hashCode() {
            return this.intValue;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof LegacySnapshot)) return false;
            LegacySnapshot that = (LegacySnapshot)o;
            if (this.intValue != that.intValue) return false;
            return true;
        }

        @Override
        protected ToStringBuilder buildDebugString() {
            return super.buildDebugString().append("year", this.getYear()).append("week", this.getWeek()).append("suffix", Character.valueOf(this.getSuffix())).append("unobfuscated", this.isUnobfuscated());
        }
    }

    public static final class Special
    extends GameVersionNumber {
        private VersionNumber versionNumber;
        private GameVersionNumber prev;

        Special(String value, String normalized) {
            super(value, normalized);
        }

        @Override
        Type getType() {
            return Type.NEW;
        }

        boolean isUnknown() {
            return this.prev == null;
        }

        VersionNumber asVersionNumber() {
            if (this.versionNumber != null) {
                return this.versionNumber;
            }
            this.versionNumber = VersionNumber.asVersion(this.normalized);
            return this.versionNumber;
        }

        GameVersionNumber getPrevNormalVersion() {
            GameVersionNumber v = this.prev;
            while (v instanceof Special) {
                Special special = (Special)v;
                v = special.prev;
            }
            if (v == null) {
                throw new AssertionError((Object)("version: " + this.value));
            }
            return v;
        }

        int compareToReleaseOrSnapshot(GameVersionNumber other) {
            if (this.isUnknown()) {
                return 1;
            }
            if (this.getPrevNormalVersion().compareTo(other) >= 0) {
                return 1;
            }
            return -1;
        }

        int compareToSpecial(Special other) {
            if (this.isUnknown()) {
                return other.isUnknown() ? this.asVersionNumber().compareTo(other.asVersionNumber()) : 1;
            }
            if (other.isUnknown()) {
                return -1;
            }
            if (this.normalized.equals(other.normalized)) {
                return 0;
            }
            int c = this.getPrevNormalVersion().compareTo(other.getPrevNormalVersion());
            if (c != 0) {
                return c;
            }
            GameVersionNumber v = this.prev;
            while (v instanceof Special) {
                Special special = (Special)v;
                if (v == other) {
                    return 1;
                }
                v = special.prev;
            }
            return -1;
        }

        @Override
        int compareToImpl(@NotNull GameVersionNumber o) {
            if (o instanceof Release || o instanceof LegacySnapshot) {
                return this.compareToReleaseOrSnapshot(o);
            }
            if (o instanceof Special) {
                Special special = (Special)o;
                return this.compareToSpecial(special);
            }
            throw new AssertionError(o.getClass());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof Special)) return false;
            Special that = (Special)o;
            if (!this.normalized.equals(that.normalized)) return false;
            return true;
        }

        public int hashCode() {
            return this.normalized.hashCode();
        }
    }

    static enum Type {
        PRE_CLASSIC,
        CLASSIC,
        INDEV,
        INFDEV,
        ALPHA,
        BETA,
        NEW;

    }
}

