/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.jfoenix.controls.JFXButton;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import org.jackhuang.hmcl.java.JavaManager;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public final class JavaRestorePage
extends ListPageBase<DisabledJavaItem>
implements DecoratorPage {
    private final ObjectProperty<DecoratorPage.State> state = new SimpleObjectProperty((Object)DecoratorPage.State.fromTitle(I18n.i18n("java.disabled.management")));
    private final InvalidationListener listener = o -> {
        ArrayList<DisabledJavaItem> result = new ArrayList<DisabledJavaItem>(disabledJava.size());
        for (String path : disabledJava) {
            Path realPath = null;
            try {
                realPath = Paths.get(path, new String[0]).toRealPath(new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            result.add(new DisabledJavaItem(disabledJava, path, realPath));
        }
        result.sort((a, b) -> {
            if (a.realPath == null && b.realPath != null) {
                return -1;
            }
            if (a.realPath != null && b.realPath == null) {
                return 1;
            }
            return a.path.compareTo(b.path);
        });
        this.setItems(FXCollections.observableList(result));
    };

    public JavaRestorePage(ObservableSet<String> disabledJava) {
        disabledJava.addListener((InvalidationListener)new WeakInvalidationListener(this.listener));
        this.listener.invalidated(disabledJava);
    }

    protected Skin<?> createDefaultSkin() {
        return new JavaRestorePageSkin(this);
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state;
    }

    private static final class JavaRestorePageSkin
    extends ToolbarListPageSkin<DisabledJavaItem, JavaRestorePage> {
        JavaRestorePageSkin(JavaRestorePage skinnable) {
            super(skinnable);
        }

        @Override
        protected List<Node> initializeToolbar(JavaRestorePage skinnable) {
            return Collections.emptyList();
        }
    }

    static final class DisabledJavaItem
    extends Control {
        final ObservableSet<String> disabledJava;
        final String path;
        final Path realPath;

        DisabledJavaItem(ObservableSet<String> disabledJava, String path, Path realPath) {
            this.disabledJava = disabledJava;
            this.path = path;
            this.realPath = realPath;
        }

        protected Skin<?> createDefaultSkin() {
            return new DisabledJavaItemSkin(this);
        }

        void onReveal() {
            if (this.realPath != null) {
                Path parent = this.realPath.getParent();
                Path target = parent != null && parent.getParent() != null && parent.getFileName() != null && parent.getFileName().toString().equals("bin") && Files.exists(parent.getParent().resolve("release"), new LinkOption[0]) ? parent.getParent() : this.realPath;
                FXUtils.showFileInExplorer(target);
            }
        }

        void onRestore() {
            this.disabledJava.remove((Object)this.path);
            JavaManager.getAddJavaTask(this.realPath).whenComplete(Schedulers.javafx(), exception -> {
                if (exception != null) {
                    Logger.LOG.warning("Failed to add java", exception);
                    Controllers.dialog(I18n.i18n("java.add.failed"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
                }
            }).start();
        }

        void onRemove() {
            this.disabledJava.remove((Object)this.path);
        }
    }

    private static final class DisabledJavaItemSkin
    extends SkinBase<DisabledJavaItem> {
        DisabledJavaItemSkin(DisabledJavaItem skinnable) {
            super((Control)skinnable);
            BorderPane root = new BorderPane();
            Label label = new Label(skinnable.path);
            BorderPane.setAlignment((Node)label, (Pos)Pos.CENTER_LEFT);
            root.setCenter((Node)label);
            HBox right = new HBox();
            right.setAlignment(Pos.CENTER_RIGHT);
            JFXButton revealButton = new JFXButton();
            revealButton.getStyleClass().add((Object)"toggle-icon4");
            revealButton.setGraphic(FXUtils.limitingSize(SVG.FOLDER_OPEN.createIcon(24.0), 24.0, 24.0));
            revealButton.setOnAction(e -> skinnable.onReveal());
            FXUtils.installFastTooltip((Node)revealButton, I18n.i18n("reveal.in_file_manager"));
            if (skinnable.realPath == null) {
                revealButton.setDisable(true);
                JFXButton removeButton = new JFXButton();
                removeButton.getStyleClass().add((Object)"toggle-icon4");
                removeButton.setGraphic(FXUtils.limitingSize(SVG.DELETE.createIcon(24.0), 24.0, 24.0));
                removeButton.setOnAction(e -> skinnable.onRemove());
                FXUtils.installFastTooltip((Node)removeButton, I18n.i18n("java.disabled.management.remove"));
                right.getChildren().setAll((Object[])new Node[]{revealButton, removeButton});
            } else {
                JFXButton restoreButton = new JFXButton();
                restoreButton.getStyleClass().add((Object)"toggle-icon4");
                restoreButton.setGraphic(FXUtils.limitingSize(SVG.RESTORE.createIcon(24.0), 24.0, 24.0));
                restoreButton.setOnAction(e -> skinnable.onRestore());
                FXUtils.installFastTooltip((Node)restoreButton, I18n.i18n("java.disabled.management.restore"));
                right.getChildren().setAll((Object[])new Node[]{revealButton, restoreButton});
            }
            root.setRight((Node)right);
            root.getStyleClass().add((Object)"md-list-cell");
            root.setPadding(new Insets(8.0));
            this.getChildren().setAll((Object[])new Node[]{new RipplerContainer((Node)root)});
        }
    }
}

