/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.fxgson.adapters.properties.primitives;

import com.google.gson.TypeAdapter;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.SimpleFloatProperty;
import org.hildan.fxgson.adapters.properties.primitives.PrimitivePropertyTypeAdapter;
import org.jetbrains.annotations.NotNull;

public class FloatPropertyTypeAdapter
extends PrimitivePropertyTypeAdapter<Float, FloatProperty> {
    public FloatPropertyTypeAdapter(TypeAdapter<Float> delegate, boolean throwOnNullProperty, boolean crashOnNullValue) {
        super(delegate, throwOnNullProperty, crashOnNullValue);
    }

    @Override
    @NotNull
    protected Float extractPrimitiveValue(FloatProperty property) {
        return Float.valueOf(property.get());
    }

    @Override
    @NotNull
    protected FloatProperty createDefaultProperty() {
        return new SimpleFloatProperty();
    }

    @Override
    @NotNull
    protected FloatProperty wrapNonNullPrimitiveValue(@NotNull Float deserializedValue) {
        return new SimpleFloatProperty(deserializedValue.floatValue());
    }
}

