/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.skins.JFXTextAreaSkin;
import com.jfoenix.validation.base.ValidatorBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.TextArea;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class JFXTextArea
extends TextArea {
    private static final String DEFAULT_STYLE_CLASS = "jfx-text-area";
    private ReadOnlyObjectWrapper<ValidatorBase> activeValidator = new ReadOnlyObjectWrapper();
    private ObservableList<ValidatorBase> validators = FXCollections.observableArrayList();
    private StyleableBooleanProperty labelFloat = new SimpleStyleableBooleanProperty(StyleableProperties.access$000(), (Object)this, "lableFloat", false);
    private StyleableObjectProperty<Paint> unFocusColor = new SimpleStyleableObjectProperty(StyleableProperties.access$100(), (Object)this, "unFocusColor", (Object)Color.rgb((int)77, (int)77, (int)77));
    private StyleableObjectProperty<Paint> focusColor = new SimpleStyleableObjectProperty(StyleableProperties.access$200(), (Object)this, "focusColor", (Object)Color.valueOf((String)"#4059A9"));
    private StyleableBooleanProperty disableAnimation = new SimpleStyleableBooleanProperty(StyleableProperties.access$300(), (Object)this, "disableAnimation", false);
    private List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public JFXTextArea() {
        this.initialize();
    }

    public JFXTextArea(String text) {
        super(text);
        this.initialize();
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXTextAreaSkin(this);
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        if ("dalvik".equals(System.getProperty("java.vm.name").toLowerCase())) {
            this.setStyle("-fx-skin: \"com.jfoenix.android.skins.JFXTextAreaSkinAndroid\";");
        }
    }

    public ValidatorBase getActiveValidator() {
        return this.activeValidator == null ? null : (ValidatorBase)((Object)this.activeValidator.get());
    }

    public ReadOnlyObjectProperty<ValidatorBase> activeValidatorProperty() {
        return this.activeValidator.getReadOnlyProperty();
    }

    public ObservableList<ValidatorBase> getValidators() {
        return this.validators;
    }

    public void setValidators(ValidatorBase ... validators) {
        this.validators.addAll((Object[])validators);
    }

    public boolean validate() {
        for (ValidatorBase validator : this.validators) {
            if (validator.getSrcControl() == null) {
                validator.setSrcControl((Node)this);
            }
            validator.validate();
            if (!validator.getHasErrors()) continue;
            this.activeValidator.set((Object)validator);
            return false;
        }
        this.activeValidator.set(null);
        return true;
    }

    public void resetValidation() {
        this.pseudoClassStateChanged(ValidatorBase.PSEUDO_CLASS_ERROR, false);
        this.activeValidator.set(null);
    }

    public final StyleableBooleanProperty labelFloatProperty() {
        return this.labelFloat;
    }

    public final boolean isLabelFloat() {
        return this.labelFloatProperty().get();
    }

    public final void setLabelFloat(boolean labelFloat) {
        this.labelFloatProperty().set(labelFloat);
    }

    public Paint getUnFocusColor() {
        return this.unFocusColor == null ? Color.rgb((int)77, (int)77, (int)77) : (Paint)this.unFocusColor.get();
    }

    public StyleableObjectProperty<Paint> unFocusColorProperty() {
        return this.unFocusColor;
    }

    public void setUnFocusColor(Paint color) {
        this.unFocusColor.set((Object)color);
    }

    public Paint getFocusColor() {
        return this.focusColor == null ? Color.valueOf((String)"#4059A9") : (Paint)this.focusColor.get();
    }

    public StyleableObjectProperty<Paint> focusColorProperty() {
        return this.focusColor;
    }

    public void setFocusColor(Paint color) {
        this.focusColor.set((Object)color);
    }

    public final StyleableBooleanProperty disableAnimationProperty() {
        return this.disableAnimation;
    }

    public final Boolean isDisableAnimation() {
        return this.disableAnimation != null && this.disableAnimationProperty().get();
    }

    public final void setDisableAnimation(Boolean disabled) {
        this.disableAnimationProperty().set(disabled.booleanValue());
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        if (this.STYLEABLES == null) {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            styleables.addAll(JFXTextArea.getClassCssMetaData());
            styleables.addAll(TextArea.getClassCssMetaData());
            this.STYLEABLES = Collections.unmodifiableList(styleables);
        }
        return this.STYLEABLES;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.setNeedsLayout(false);
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXTextArea, Paint> UNFOCUS_COLOR = new CssMetaData<JFXTextArea, Paint>("-jfx-unfocus-color", StyleConverter.getPaintConverter(), (Paint)Color.rgb((int)77, (int)77, (int)77)){

            public boolean isSettable(JFXTextArea control) {
                return control.unFocusColor == null || !control.unFocusColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXTextArea control) {
                return control.unFocusColorProperty();
            }
        };
        private static final CssMetaData<JFXTextArea, Paint> FOCUS_COLOR = new CssMetaData<JFXTextArea, Paint>("-jfx-focus-color", StyleConverter.getPaintConverter(), (Paint)Color.valueOf((String)"#4059A9")){

            public boolean isSettable(JFXTextArea control) {
                return control.focusColor == null || !control.focusColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXTextArea control) {
                return control.focusColorProperty();
            }
        };
        private static final CssMetaData<JFXTextArea, Boolean> LABEL_FLOAT = new CssMetaData<JFXTextArea, Boolean>("-jfx-label-float", StyleConverter.getBooleanConverter(), Boolean.valueOf(false)){

            public boolean isSettable(JFXTextArea control) {
                return control.labelFloat == null || !control.labelFloat.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXTextArea control) {
                return control.labelFloatProperty();
            }
        };
        private static final CssMetaData<JFXTextArea, Boolean> DISABLE_ANIMATION = new CssMetaData<JFXTextArea, Boolean>("-jfx-disable-animation", StyleConverter.getBooleanConverter(), Boolean.valueOf(false)){

            public boolean isSettable(JFXTextArea control) {
                return control.disableAnimation == null || !control.disableAnimation.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXTextArea control) {
                return control.disableAnimationProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return LABEL_FLOAT;
        }

        static /* synthetic */ CssMetaData access$100() {
            return UNFOCUS_COLOR;
        }

        static /* synthetic */ CssMetaData access$200() {
            return FOCUS_COLOR;
        }

        static /* synthetic */ CssMetaData access$300() {
            return DISABLE_ANIMATION;
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, UNFOCUS_COLOR, FOCUS_COLOR, LABEL_FLOAT, DISABLE_ANIMATION);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

