/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.task;

import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.jackhuang.hmcl.task.FetchTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public final class GetTask
extends FetchTask<String> {
    public GetTask(String uri) {
        this(NetworkUtils.toURI(uri));
    }

    public GetTask(URI url) {
        this(List.of(url));
        this.setName(url.toString());
    }

    public GetTask(List<URI> url) {
        super(url);
        this.setName(url.get(0).toString());
    }

    @Override
    protected FetchTask.EnumCheckETag shouldCheckETag() {
        return FetchTask.EnumCheckETag.CHECK_E_TAG;
    }

    @Override
    protected void useCachedResult(Path cachedFile) throws IOException {
        this.setResult(Files.readString(cachedFile));
    }

    @Override
    protected FetchTask.Context getContext(final HttpResponse<?> response, final boolean checkETag, String bmclapiHash) {
        long length = -1L;
        if (response != null) {
            length = response.headers().firstValueAsLong("content-length").orElse(-1L);
        }
        final ByteArrayOutputStream baos = new ByteArrayOutputStream(length <= 0L ? 8192 : (int)length);
        return new FetchTask.Context(){

            @Override
            public void write(byte[] buffer, int offset, int len) {
                baos.write(buffer, offset, len);
            }

            @Override
            public void close() throws IOException {
                if (!this.isSuccess()) {
                    return;
                }
                Charset charset = StandardCharsets.UTF_8;
                if (response != null) {
                    charset = NetworkUtils.getCharsetFromContentType(response.headers().firstValue("content-type").orElse(null));
                }
                String result = baos.toString(charset);
                GetTask.this.setResult(result);
                if (checkETag) {
                    GetTask.this.repository.cacheText(response, result);
                }
            }
        };
    }

    public <T> Task<T> thenGetJsonAsync(Class<T> type) {
        return this.thenGetJsonAsync(TypeToken.get(type));
    }

    public <T> Task<T> thenGetJsonAsync(TypeToken<T> type) {
        return this.thenApplyAsync(jsonString -> JsonUtils.fromNonNullJson(jsonString, type));
    }
}

