/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.util.i18n.I18n;

@DefaultProperty(value="image")
public final class ImagePickerItem
extends BorderPane {
    private final ImageView imageView;
    private final StringProperty title = new SimpleStringProperty((Object)this, "title");
    private final ObjectProperty<EventHandler<ActionEvent>> onSelectButtonClicked = new SimpleObjectProperty((Object)this, "onSelectButtonClicked");
    private final ObjectProperty<EventHandler<ActionEvent>> onDeleteButtonClicked = new SimpleObjectProperty((Object)this, "onDeleteButtonClicked");
    private final ObjectProperty<Image> image = new SimpleObjectProperty((Object)this, "image");

    public ImagePickerItem() {
        this.imageView = new ImageView();
        this.imageView.setSmooth(false);
        this.imageView.setPreserveRatio(true);
        JFXButton selectButton = new JFXButton();
        selectButton.setGraphic(SVG.EDIT.createIcon((Paint)Theme.blackFill(), 20.0));
        selectButton.onActionProperty().bind(this.onSelectButtonClicked);
        selectButton.getStyleClass().add((Object)"toggle-icon4");
        JFXButton deleteButton = new JFXButton();
        deleteButton.setGraphic(SVG.CLOSE.createIcon((Paint)Theme.blackFill(), 20.0));
        deleteButton.onActionProperty().bind(this.onDeleteButtonClicked);
        deleteButton.getStyleClass().add((Object)"toggle-icon4");
        FXUtils.installFastTooltip((Node)selectButton, I18n.i18n("button.edit"));
        HBox hBox = new HBox();
        hBox.getChildren().setAll((Object[])new Node[]{this.imageView, selectButton, deleteButton});
        hBox.setAlignment(Pos.CENTER_RIGHT);
        hBox.setSpacing(8.0);
        this.setRight((Node)hBox);
        VBox vBox = new VBox();
        Label label = new Label();
        label.textProperty().bind((ObservableValue)this.title);
        vBox.getChildren().setAll((Object[])new Node[]{label});
        vBox.setAlignment(Pos.CENTER_LEFT);
        this.setLeft((Node)vBox);
        this.imageView.imageProperty().bind(this.image);
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public EventHandler<ActionEvent> getOnSelectButtonClicked() {
        return (EventHandler)this.onSelectButtonClicked.get();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onSelectButtonClickedProperty() {
        return this.onSelectButtonClicked;
    }

    public void setOnSelectButtonClicked(EventHandler<ActionEvent> onSelectButtonClicked) {
        this.onSelectButtonClicked.set(onSelectButtonClicked);
    }

    public EventHandler<ActionEvent> getOnDeleteButtonClicked() {
        return (EventHandler)this.onDeleteButtonClicked.get();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onDeleteButtonClickedProperty() {
        return this.onDeleteButtonClicked;
    }

    public void setOnDeleteButtonClicked(EventHandler<ActionEvent> onDeleteButtonClicked) {
        this.onDeleteButtonClicked.set(onDeleteButtonClicked);
    }

    public Image getImage() {
        return (Image)this.image.get();
    }

    public ObjectProperty<Image> imageProperty() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image.set((Object)image);
    }

    public ImageView getImageView() {
        return this.imageView;
    }
}

