/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.i18n;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.i18n.DefaultResourceBundleControl;
import org.jackhuang.hmcl.util.i18n.LocaleUtils;
import org.jackhuang.hmcl.util.i18n.TextDirection;
import org.jackhuang.hmcl.util.i18n.translator.Translator;
import org.jackhuang.hmcl.util.logging.Logger;

@JsonAdapter(value=TypeAdapter.class)
public final class SupportedLocale {
    public static final SupportedLocale DEFAULT = new SupportedLocale();
    private static final ConcurrentMap<Locale, SupportedLocale> LOCALES = new ConcurrentHashMap<Locale, SupportedLocale>();
    private final boolean isDefault;
    private final String name;
    private final Locale locale;
    private final TextDirection textDirection;
    private ResourceBundle resourceBundle;
    private ResourceBundle localeNamesBundle;
    private List<Locale> candidateLocales;
    private Translator translator;

    public static List<SupportedLocale> getSupportedLocales() {
        ArrayList<SupportedLocale> list = new ArrayList<SupportedLocale>();
        list.add(DEFAULT);
        InputStream locales = SupportedLocale.class.getResourceAsStream("/assets/lang/languages.json");
        if (locales != null) {
            try (InputStream inputStream = locales;){
                list.addAll((Collection)JsonUtils.fromNonNullJsonFully(locales, JsonUtils.listTypeOf(SupportedLocale.class)));
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to load languages.json", e);
            }
        }
        return List.copyOf(list);
    }

    public static SupportedLocale getLocale(Locale locale) {
        return LOCALES.computeIfAbsent(locale, SupportedLocale::new);
    }

    public static SupportedLocale getLocaleByName(String name) {
        if (name == null || name.isBlank() || "def".equals(name) || "default".equals(name)) {
            return DEFAULT;
        }
        return SupportedLocale.getLocale(Locale.forLanguageTag(name.trim().replace('_', '-')));
    }

    SupportedLocale() {
        this.isDefault = true;
        this.name = "def";
        String language = System.getenv("HMCL_LANGUAGE");
        this.locale = StringUtils.isBlank(language) ? LocaleUtils.SYSTEM_DEFAULT : Locale.forLanguageTag(language);
        this.textDirection = LocaleUtils.getTextDirection(this.locale);
    }

    SupportedLocale(Locale locale) {
        this.isDefault = false;
        this.name = locale.toLanguageTag();
        this.locale = locale;
        this.textDirection = LocaleUtils.getTextDirection(locale);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getName() {
        return this.name;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TextDirection getTextDirection() {
        return this.textDirection;
    }

    public String getDisplayName(SupportedLocale inLocale) {
        String subLanguage;
        if (this.isDefault()) {
            try {
                return inLocale.getResourceBundle().getString("lang.default");
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to get localized name for default locale", e);
                return "Default";
            }
        }
        Locale currentLocale = this.getLocale();
        String language = currentLocale.getLanguage();
        String parentLanguage = LocaleUtils.getParentLanguage(language);
        if (parentLanguage != null) {
            subLanguage = language;
            language = parentLanguage;
        } else {
            subLanguage = "";
        }
        ResourceBundle localeNames = inLocale.getLocaleNamesBundle();
        String languageDisplayName = language;
        try {
            languageDisplayName = localeNames.getString(language);
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to get localized name for language " + language, e);
        }
        List<String> subTags = Stream.of(subLanguage, currentLocale.getScript()).filter(it -> !it.isEmpty()).map(it -> {
            try {
                return localeNames.getString((String)it);
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to get localized name of " + it, e);
                return it;
            }
        }).toList();
        return subTags.isEmpty() ? languageDisplayName : languageDisplayName + " (" + String.join((CharSequence)", ", subTags) + ")";
    }

    public ResourceBundle getResourceBundle() {
        ResourceBundle bundle = this.resourceBundle;
        if (this.resourceBundle == null) {
            this.resourceBundle = bundle = ResourceBundle.getBundle("assets.lang.I18N", this.locale, DefaultResourceBundleControl.INSTANCE);
        }
        return bundle;
    }

    public ResourceBundle getLocaleNamesBundle() {
        ResourceBundle bundle = this.localeNamesBundle;
        if (this.localeNamesBundle == null) {
            this.localeNamesBundle = bundle = ResourceBundle.getBundle("assets.lang.LocaleNames", this.locale, DefaultResourceBundleControl.INSTANCE);
        }
        return bundle;
    }

    public List<Locale> getCandidateLocales() {
        if (this.candidateLocales == null) {
            this.candidateLocales = List.copyOf(LocaleUtils.getCandidateLocales(this.locale));
        }
        return this.candidateLocales;
    }

    public String i18n(String key, Object ... formatArgs) {
        try {
            return String.format(this.getResourceBundle().getString(key), formatArgs);
        }
        catch (MissingResourceException e) {
            Logger.LOG.error("Cannot find key " + key + " in resource bundle", e);
        }
        catch (IllegalFormatException e) {
            Logger.LOG.error("Illegal format string, key=" + key + ", args=" + Arrays.toString(formatArgs), e);
        }
        return key + Arrays.toString(formatArgs);
    }

    public String i18n(String key) {
        try {
            return this.getResourceBundle().getString(key);
        }
        catch (MissingResourceException e) {
            Logger.LOG.error("Cannot find key " + key + " in resource bundle", e);
            return key;
        }
    }

    public String getFcMatchPattern() {
        String language = this.locale.getLanguage();
        String region = this.locale.getCountry();
        if (LocaleUtils.isEnglish(this.locale)) {
            return "";
        }
        if (LocaleUtils.isChinese(this.locale)) {
            String charset;
            String lang;
            String script;
            switch (script = LocaleUtils.getScript(this.locale)) {
                case "Hans": {
                    lang = region.equals("SG") || region.equals("MY") ? "zh-" + region : "zh-CN";
                    charset = "0x6e38,0x620f";
                    break;
                }
                case "Hant": {
                    lang = region.equals("HK") || region.equals("MO") ? "zh-" + region : "zh-TW";
                    charset = "0x904a,0x6232";
                    break;
                }
                default: {
                    return "";
                }
            }
            return ":lang=" + lang + ":charset=" + charset;
        }
        return region.isEmpty() ? language : language + "-" + region;
    }

    public Translator getTranslator() {
        Translator translator = this.translator;
        if (translator != null) {
            return translator;
        }
        List<Locale> candidateLocales = this.getCandidateLocales();
        for (Locale candidateLocale : candidateLocales) {
            String className = DefaultResourceBundleControl.INSTANCE.toBundleName(Translator.class.getSimpleName(), candidateLocale);
            if (Translator.class.getResource(className + ".class") == null) continue;
            try {
                Class<?> clazz = Class.forName(Translator.class.getPackageName() + "." + className);
                MethodHandle constructor = MethodHandles.publicLookup().findConstructor(clazz, MethodType.methodType(Void.TYPE, SupportedLocale.class));
                this.translator = constructor.invoke(this);
                return this.translator;
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to create instance for " + className, e);
            }
        }
        this.translator = new Translator(this);
        return this.translator;
    }

    public boolean isSameLanguage(SupportedLocale other) {
        return LocaleUtils.getRootLanguage(this.getLocale()).equals(LocaleUtils.getRootLanguage(other.getLocale()));
    }

    public static final class TypeAdapter
    extends com.google.gson.TypeAdapter<SupportedLocale> {
        @Override
        public void write(JsonWriter out, SupportedLocale value) throws IOException {
            out.value(value.getName());
        }

        @Override
        public SupportedLocale read(JsonReader in) throws IOException {
            String language;
            if (in.peek() == JsonToken.NULL) {
                return DEFAULT;
            }
            return SupportedLocale.getLocaleByName(switch (language = in.nextString()) {
                case "zh_CN" -> "zh-Hans";
                case "zh" -> "zh-Hant";
                default -> language;
            });
        }
    }
}

