/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.i18n.translator;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.util.i18n.SupportedLocale;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public class Translator {
    protected final SupportedLocale supportedLocale;
    protected final Locale locale;
    protected DateTimeFormatter dateTimeFormatter;

    public Translator(SupportedLocale supportedLocale) {
        this.supportedLocale = supportedLocale;
        this.locale = supportedLocale.getLocale();
    }

    public final SupportedLocale getSupportedLocale() {
        return this.supportedLocale;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public String getDisplayVersion(RemoteVersion remoteVersion) {
        return remoteVersion.getSelfVersion();
    }

    public String getDisplayVersion(GameVersionNumber versionNumber) {
        return versionNumber.toNormalizedString();
    }

    public String formatDateTime(TemporalAccessor time) {
        DateTimeFormatter formatter = this.dateTimeFormatter;
        if (formatter == null) {
            formatter = this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.supportedLocale.getResourceBundle().getString("datetime.format")).withZone(ZoneId.systemDefault());
        }
        return formatter.format(time);
    }

    public String formatSpeed(long bytes) {
        if (bytes < 1024L) {
            return this.supportedLocale.i18n("download.speed.byte_per_second", bytes);
        }
        if (bytes < 0x100000L) {
            return this.supportedLocale.i18n("download.speed.kibibyte_per_second", (double)bytes / 1024.0);
        }
        return this.supportedLocale.i18n("download.speed.megabyte_per_second", (double)bytes / 1048576.0);
    }
}

