/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform;

import java.util.List;
import org.jackhuang.hmcl.util.DataSizeUnit;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.hardware.CentralProcessor;
import org.jackhuang.hmcl.util.platform.hardware.GraphicsCard;
import org.jackhuang.hmcl.util.platform.hardware.HardwareDetector;
import org.jackhuang.hmcl.util.platform.hardware.PhysicalMemoryStatus;
import org.jackhuang.hmcl.util.platform.linux.LinuxHardwareDetector;
import org.jackhuang.hmcl.util.platform.macos.MacOSHardwareDetector;
import org.jackhuang.hmcl.util.platform.windows.WindowsHardwareDetector;
import org.jetbrains.annotations.Nullable;

public final class SystemInfo {
    public static void initialize() {
        List<GraphicsCard> graphicsCards;
        StringBuilder builder = new StringBuilder("System Info:");
        CentralProcessor cpu = SystemInfo.getCentralProcessor();
        if (cpu != null) {
            builder.append("\n - CPU: ").append(cpu);
        }
        if ((graphicsCards = SystemInfo.getGraphicsCards()) != null) {
            if (graphicsCards.isEmpty()) {
                builder.append("\n - GPU: Not Found");
            } else if (graphicsCards.size() == 1) {
                builder.append("\n - GPU: ").append(graphicsCards.get(0));
            } else {
                int index = 1;
                for (GraphicsCard graphicsCard : graphicsCards) {
                    builder.append("\n - GPU ").append(index++).append(": ").append(graphicsCard);
                }
            }
        }
        long totalMemorySize = SystemInfo.getTotalMemorySize();
        long usedMemorySize = SystemInfo.getUsedMemorySize();
        builder.append("\n - Memory: ").append(DataSizeUnit.format(usedMemorySize)).append(" / ").append(DataSizeUnit.format(totalMemorySize));
        if (totalMemorySize > 0L && usedMemorySize > 0L) {
            builder.append(" (").append((int)((double)usedMemorySize / (double)totalMemorySize * 100.0)).append("%)");
        }
        Logger.LOG.info(builder.toString());
    }

    public static PhysicalMemoryStatus getPhysicalMemoryStatus() {
        long totalMemorySize = SystemInfo.getTotalMemorySize();
        long freeMemorySize = SystemInfo.getFreeMemorySize();
        return totalMemorySize > 0L && freeMemorySize >= 0L ? new PhysicalMemoryStatus(totalMemorySize, freeMemorySize) : PhysicalMemoryStatus.INVALID;
    }

    public static long getTotalMemorySize() {
        return Holder.TOTAL_MEMORY;
    }

    public static long getFreeMemorySize() {
        return Holder.DETECTOR.getFreeMemorySize();
    }

    public static long getUsedMemorySize() {
        long totalMemorySize = SystemInfo.getTotalMemorySize();
        if (totalMemorySize <= 0L) {
            return 0L;
        }
        return Long.max(0L, totalMemorySize - SystemInfo.getFreeMemorySize());
    }

    @Nullable
    public static CentralProcessor getCentralProcessor() {
        return Holder.CENTRAL_PROCESSOR;
    }

    @Nullable
    public static List<GraphicsCard> getGraphicsCards() {
        return Holder.GRAPHICS_CARDS;
    }

    private SystemInfo() {
    }

    private static final class Holder {
        public static final HardwareDetector DETECTOR = OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? new WindowsHardwareDetector() : (OperatingSystem.CURRENT_OS == OperatingSystem.LINUX ? new LinuxHardwareDetector() : (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS ? new MacOSHardwareDetector() : new HardwareDetector()));
        public static final long TOTAL_MEMORY = DETECTOR.getTotalMemorySize();
        @Nullable
        public static final CentralProcessor CENTRAL_PROCESSOR = DETECTOR.detectCentralProcessor();
        @Nullable
        public static final List<GraphicsCard> GRAPHICS_CARDS = DETECTOR.detectGraphicsCards();

        private Holder() {
        }
    }
}

