/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform.windows;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.LongByReference;
import java.util.Arrays;
import java.util.List;

public interface WinTypes {

    public static final class GROUP_RELATIONSHIP
    extends Structure {
        public short maximumGroupCount;
        public short activeGroupCount;
        public byte[] reserved = new byte[20];
        public PROCESSOR_GROUP_INFO[] groupInfo = new PROCESSOR_GROUP_INFO[1];

        public GROUP_RELATIONSHIP() {
        }

        public GROUP_RELATIONSHIP(Pointer memory) {
            super(memory);
        }

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("maximumGroupCount", "activeGroupCount", "reserved", "groupInfo");
        }

        @Override
        public void read() {
            this.readField("activeGroupCount");
            if (this.activeGroupCount != this.groupInfo.length) {
                this.groupInfo = new PROCESSOR_GROUP_INFO[this.activeGroupCount];
            }
            super.read();
        }
    }

    public static final class PROCESSOR_RELATIONSHIP
    extends Structure {
        public byte flags;
        public byte efficiencyClass;
        public byte[] reserved = new byte[20];
        public short groupCount;
        public GROUP_AFFINITY[] groupMask = new GROUP_AFFINITY[1];

        public PROCESSOR_RELATIONSHIP() {
        }

        public PROCESSOR_RELATIONSHIP(Pointer memory) {
            super(memory);
        }

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("flags", "efficiencyClass", "reserved", "groupCount", "groupMask");
        }

        @Override
        public void read() {
            this.readField("groupCount");
            if (this.groupCount != this.groupMask.length) {
                this.groupMask = new GROUP_AFFINITY[this.groupCount];
            }
            super.read();
        }
    }

    public static final class PROCESSOR_GROUP_INFO
    extends Structure {
        public byte maximumProcessorCount;
        public byte activeProcessorCount;
        public byte[] reserved = new byte[38];
        public LongByReference activeProcessorMask;

        public PROCESSOR_GROUP_INFO(Pointer memory) {
            super(memory);
        }

        public PROCESSOR_GROUP_INFO() {
        }

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("maximumProcessorCount", "activeProcessorCount", "reserved", "activeProcessorMask");
        }
    }

    public static final class GROUP_AFFINITY
    extends Structure {
        public LongByReference mask;
        public short group;
        public short[] reserved = new short[3];

        public GROUP_AFFINITY(Pointer memory) {
            super(memory);
        }

        public GROUP_AFFINITY() {
        }

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("mask", "group", "reserved");
        }
    }

    public static final class MEMORYSTATUSEX
    extends Structure {
        public int dwLength = this.size();
        public int dwMemoryLoad;
        public long ullTotalPhys;
        public long ullAvailPhys;
        public long ullTotalPageFile;
        public long ullAvailPageFile;
        public long ullTotalVirtual;
        public long ullAvailVirtual;
        public long ullAvailExtendedVirtual;

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("dwLength", "dwMemoryLoad", "ullTotalPhys", "ullAvailPhys", "ullTotalPageFile", "ullAvailPageFile", "ullTotalVirtual", "ullAvailVirtual", "ullAvailExtendedVirtual");
        }
    }

    public static final class OSVERSIONINFOEXW
    extends Structure {
        public int dwOSVersionInfoSize;
        public int dwMajorVersion;
        public int dwMinorVersion;
        public int dwBuildNumber;
        public int dwPlatformId;
        public char[] szCSDVersion = new char[128];
        public short wServicePackMajor;
        public short wServicePackMinor;
        public short wSuiteMask;
        public byte wProductType;
        public byte wReserved;

        public OSVERSIONINFOEXW() {
            this.dwOSVersionInfoSize = this.size();
        }

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("dwOSVersionInfoSize", "dwMajorVersion", "dwMinorVersion", "dwBuildNumber", "dwPlatformId", "szCSDVersion", "wServicePackMajor", "wServicePackMinor", "wSuiteMask", "wProductType", "wReserved");
        }
    }
}

