/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.pci.ids.internal;

public final class ArgumentValidator {
    public static void requireNonBlank(String arg, String msg) {
        if (arg == null || arg.trim().isEmpty()) {
            throw new IllegalArgumentException(msg + ": " + arg);
        }
    }

    public static void requireStringLength(String arg, int len, NumberCompare comp, String name) {
        boolean result;
        ArgumentValidator.requireNonNull(arg, "String to test");
        switch (comp.ordinal()) {
            case 0: {
                result = arg.length() == len;
                break;
            }
            case 1: {
                result = arg.length() > len;
                break;
            }
            case 2: {
                result = arg.length() >= len;
                break;
            }
            case 3: {
                result = arg.length() < len;
                break;
            }
            case 4: {
                result = arg.length() <= len;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown value of NumberCompare: " + (Object)((Object)comp));
            }
        }
        if (!result) {
            String msg = "String length violation (" + name + "): string(" + arg.length() + ") " + comp.getOperator() + " " + len;
            throw new IllegalArgumentException(msg);
        }
    }

    public static void requireNonNull(Object arg, String msg) {
        if (arg == null) {
            throw new IllegalArgumentException("NULL: " + msg);
        }
    }

    public static void requireUnsignedByte(int arg, String name) {
        if (arg < 0 || arg > 255) {
            throw new IllegalArgumentException(name + " (" + arg + ") should be between 0 and 0xff");
        }
    }

    public static void requireUnsignedShort(int arg, String name) {
        if (arg < 0 || arg > 65535) {
            throw new IllegalArgumentException(name + " (" + arg + ") should be between 0 and 0xffff");
        }
    }

    private ArgumentValidator() {
    }

    public static enum NumberCompare {
        EQUAL("=="),
        GREATER(">"),
        GREATER_EQUAL(">="),
        LESS("<"),
        LESS_EQUAL("<=");

        private final String operator;

        public String getOperator() {
            return this.operator;
        }

        private NumberCompare(String op) {
            this.operator = op;
        }
    }
}

