/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.task.Task;

public abstract class GameBuilder {
    protected String name = "";
    protected String gameVersion = "";
    protected final Map<String, String> toolVersions = new HashMap<String, String>();
    protected final Set<RemoteVersion> remoteVersions = new HashSet<RemoteVersion>();

    public String getName() {
        return this.name;
    }

    public GameBuilder name(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    public GameBuilder gameVersion(String version) {
        this.gameVersion = Objects.requireNonNull(version);
        return this;
    }

    public GameBuilder version(String id, String version) {
        if ("game".equals(id)) {
            this.gameVersion(version);
        } else {
            this.toolVersions.put(id, version);
        }
        return this;
    }

    public GameBuilder version(RemoteVersion remoteVersion) {
        this.remoteVersions.add(remoteVersion);
        return this;
    }

    public abstract Task<?> buildAsync();
}

