/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.svg.SVGGlyph;
import java.util.ArrayList;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;

public class JFXDecorator
extends VBox {
    private Stage primaryStage;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private double newX;
    private double newY;
    private double initX;
    private double initY;
    private boolean allowMove = false;
    private boolean isDragging = false;
    private Timeline windowDecoratorAnimation;
    private StackPane contentPlaceHolder = new StackPane();
    private HBox buttonsContainer;
    private ObjectProperty<Runnable> onCloseButtonAction = new SimpleObjectProperty(() -> this.primaryStage.close());
    private BooleanProperty customMaximize = new SimpleBooleanProperty(false);
    private boolean maximized = false;
    private BoundingBox originalBox;
    private BoundingBox maximizedBox;
    private JFXButton btnMax;

    public JFXDecorator(Stage stage, Node node) {
        this(stage, node, true, true, true);
    }

    public JFXDecorator(Stage stage, Node node, boolean fullScreen, boolean max, boolean min) {
        this.primaryStage = stage;
        this.primaryStage.initStyle(StageStyle.UNDECORATED);
        this.setPickOnBounds(false);
        this.getStyleClass().add((Object)"jfx-decorator");
        SVGGlyph full = new SVGGlyph(0, "FULLSCREEN", "M598 214h212v212h-84v-128h-128v-84zM726 726v-128h84v212h-212v-84h128zM214 426v-212h212v84h-128v128h-84zM298 598v128h128v84h-212v-212h84z", (Paint)Color.WHITE);
        full.setSize(16.0, 16.0);
        SVGGlyph minus = new SVGGlyph(0, "MINUS", "M804.571 420.571v109.714q0 22.857-16 38.857t-38.857 16h-694.857q-22.857 0-38.857-16t-16-38.857v-109.714q0-22.857 16-38.857t38.857-16h694.857q22.857 0 38.857 16t16 38.857z", (Paint)Color.WHITE);
        minus.setSize(12.0, 2.0);
        minus.setTranslateY(4.0);
        SVGGlyph resizeMax = new SVGGlyph(0, "RESIZE_MAX", "M726 810v-596h-428v596h428zM726 44q34 0 59 25t25 59v768q0 34-25 60t-59 26h-428q-34 0-59-26t-25-60v-768q0-34 25-60t59-26z", (Paint)Color.WHITE);
        resizeMax.setSize(12.0, 12.0);
        SVGGlyph resizeMin = new SVGGlyph(0, "RESIZE_MIN", "M80.842 943.158v-377.264h565.894v377.264h-565.894zM0 404.21v619.79h727.578v-619.79h-727.578zM377.264 161.684h565.894v377.264h-134.736v80.842h215.578v-619.79h-727.578v323.37h80.842v-161.686z", (Paint)Color.WHITE);
        resizeMin.setSize(12.0, 12.0);
        SVGGlyph close = new SVGGlyph(0, "CLOSE", "M810 274l-238 238 238 238-60 60-238-238-238 238-60-60 238-238-238-238 60-60 238 238 238-238z", (Paint)Color.WHITE);
        close.setSize(12.0, 12.0);
        JFXButton btnFull = new JFXButton();
        btnFull.getStyleClass().add((Object)"jfx-decorator-button");
        btnFull.setCursor(Cursor.HAND);
        btnFull.setOnAction(action -> this.primaryStage.setFullScreen(!this.primaryStage.isFullScreen()));
        btnFull.setGraphic((Node)full);
        btnFull.setTranslateX(-30.0);
        btnFull.setRipplerFill((Paint)Color.WHITE);
        JFXButton btnClose = new JFXButton();
        btnClose.getStyleClass().add((Object)"jfx-decorator-button");
        btnClose.setCursor(Cursor.HAND);
        btnClose.setOnAction(action -> ((Runnable)this.onCloseButtonAction.get()).run());
        btnClose.setGraphic((Node)close);
        btnClose.setRipplerFill((Paint)Color.WHITE);
        JFXButton btnMin = new JFXButton();
        btnMin.getStyleClass().add((Object)"jfx-decorator-button");
        btnMin.setCursor(Cursor.HAND);
        btnMin.setOnAction(action -> this.primaryStage.setIconified(true));
        btnMin.setGraphic((Node)minus);
        btnMin.setRipplerFill((Paint)Color.WHITE);
        this.btnMax = new JFXButton();
        this.btnMax.getStyleClass().add((Object)"jfx-decorator-button");
        this.btnMax.setCursor(Cursor.HAND);
        this.btnMax.setRipplerFill((Paint)Color.WHITE);
        this.btnMax.setOnAction(action -> {
            if (!this.isCustomMaximize()) {
                this.primaryStage.setMaximized(!this.primaryStage.isMaximized());
                this.maximized = this.primaryStage.isMaximized();
                if (this.primaryStage.isMaximized()) {
                    this.btnMax.setGraphic((Node)resizeMin);
                    this.btnMax.setTooltip(new Tooltip("Restore Down"));
                } else {
                    this.btnMax.setGraphic((Node)resizeMax);
                    this.btnMax.setTooltip(new Tooltip("Maximize"));
                }
            } else {
                if (!this.maximized) {
                    this.originalBox = new BoundingBox(stage.getX(), stage.getY(), stage.getWidth(), stage.getHeight());
                    Screen screen = (Screen)Screen.getScreensForRectangle((double)stage.getX(), (double)stage.getY(), (double)stage.getWidth(), (double)stage.getHeight()).get(0);
                    Rectangle2D bounds = screen.getVisualBounds();
                    this.maximizedBox = new BoundingBox(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
                    stage.setX(this.maximizedBox.getMinX());
                    stage.setY(this.maximizedBox.getMinY());
                    stage.setWidth(this.maximizedBox.getWidth());
                    stage.setHeight(this.maximizedBox.getHeight());
                    this.btnMax.setGraphic((Node)resizeMin);
                    this.btnMax.setTooltip(new Tooltip("Restore Down"));
                } else {
                    stage.setX(this.originalBox.getMinX());
                    stage.setY(this.originalBox.getMinY());
                    stage.setWidth(this.originalBox.getWidth());
                    stage.setHeight(this.originalBox.getHeight());
                    this.originalBox = null;
                    this.btnMax.setGraphic((Node)resizeMax);
                    this.btnMax.setTooltip(new Tooltip("Maximize"));
                }
                this.maximized = !this.maximized;
            }
        });
        this.btnMax.setGraphic((Node)resizeMax);
        this.buttonsContainer = new HBox();
        this.buttonsContainer.getStyleClass().add((Object)"jfx-decorator-buttons-container");
        this.buttonsContainer.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.buttonsContainer.setPadding(new Insets(4.0));
        this.buttonsContainer.setAlignment(Pos.CENTER_RIGHT);
        this.buttonsContainer.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
            if (mouseEvent.getClickCount() == 2) {
                this.btnMax.fire();
            }
        });
        ArrayList<JFXButton> btns = new ArrayList<JFXButton>();
        if (fullScreen) {
            btns.add(btnFull);
        }
        if (min) {
            btns.add(btnMin);
        }
        if (max) {
            btns.add(this.btnMax);
        }
        btns.add(btnClose);
        this.buttonsContainer.getChildren().addAll(btns);
        this.buttonsContainer.addEventHandler(MouseEvent.MOUSE_ENTERED, enter -> {
            this.allowMove = true;
        });
        this.buttonsContainer.addEventHandler(MouseEvent.MOUSE_EXITED, enter -> {
            if (!this.isDragging) {
                this.allowMove = false;
            }
        });
        this.buttonsContainer.setMinWidth(180.0);
        this.contentPlaceHolder.getStyleClass().add((Object)"jfx-decorator-content-container");
        this.contentPlaceHolder.setMinSize(0.0, 0.0);
        this.contentPlaceHolder.getChildren().add((Object)node);
        ((Region)node).setMinSize(0.0, 0.0);
        VBox.setVgrow((Node)this.contentPlaceHolder, (Priority)Priority.ALWAYS);
        this.contentPlaceHolder.getStyleClass().add((Object)"resize-border");
        this.contentPlaceHolder.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(0.0, 4.0, 4.0, 4.0))}));
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)((Region)node).widthProperty());
        clip.heightProperty().bind((ObservableValue)((Region)node).heightProperty());
        node.setClip((Node)clip);
        this.getChildren().addAll((Object[])new Node[]{this.buttonsContainer, this.contentPlaceHolder});
        this.primaryStage.fullScreenProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.contentPlaceHolder.getStyleClass().remove((Object)"resize-border");
                this.contentPlaceHolder.borderProperty().unbind();
                this.contentPlaceHolder.setBorder(Border.EMPTY);
                if (this.windowDecoratorAnimation != null) {
                    this.windowDecoratorAnimation.stop();
                }
                this.windowDecoratorAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)320.0), new KeyValue[]{new KeyValue((WritableValue)this.translateYProperty(), (Object)(-this.buttonsContainer.getHeight()), Interpolator.EASE_BOTH)})});
                this.windowDecoratorAnimation.setOnFinished(finish -> {
                    this.getChildren().remove((Object)this.buttonsContainer);
                    this.setTranslateY(0.0);
                });
                this.windowDecoratorAnimation.play();
            } else {
                if (this.windowDecoratorAnimation != null) {
                    if (this.windowDecoratorAnimation.getStatus() == Animation.Status.RUNNING) {
                        this.windowDecoratorAnimation.stop();
                    } else {
                        this.getChildren().add(0, (Object)this.buttonsContainer);
                    }
                }
                this.setTranslateY(-this.buttonsContainer.getHeight());
                this.windowDecoratorAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)320.0), new KeyValue[]{new KeyValue((WritableValue)this.translateYProperty(), (Object)0, Interpolator.EASE_BOTH)})});
                this.windowDecoratorAnimation.setOnFinished(finish -> {
                    this.contentPlaceHolder.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(0.0, 4.0, 4.0, 4.0))}));
                    this.contentPlaceHolder.getStyleClass().add((Object)"resize-border");
                });
                this.windowDecoratorAnimation.play();
            }
        });
        this.setOnMouseMoved(mouseEvent -> {
            if (this.primaryStage.isMaximized() || this.primaryStage.isFullScreen() || this.maximized) {
                this.setCursor(Cursor.DEFAULT);
                return;
            }
            if (!this.primaryStage.isResizable()) {
                this.updateInitMouseValues((MouseEvent)mouseEvent);
                return;
            }
            double x = mouseEvent.getX();
            double y = mouseEvent.getY();
            Bounds boundsInParent = this.getBoundsInParent();
            if (this.contentPlaceHolder.getBorder() != null && this.contentPlaceHolder.getBorder().getStrokes().size() > 0) {
                double borderWidth = this.contentPlaceHolder.snappedLeftInset();
                if (this.isRightEdge(x, y, boundsInParent)) {
                    if (y < borderWidth) {
                        this.setCursor(Cursor.NE_RESIZE);
                    } else if (y > this.getHeight() - borderWidth) {
                        this.setCursor(Cursor.SE_RESIZE);
                    } else {
                        this.setCursor(Cursor.E_RESIZE);
                    }
                } else if (this.isLeftEdge(x, y, boundsInParent)) {
                    if (y < borderWidth) {
                        this.setCursor(Cursor.NW_RESIZE);
                    } else if (y > this.getHeight() - borderWidth) {
                        this.setCursor(Cursor.SW_RESIZE);
                    } else {
                        this.setCursor(Cursor.W_RESIZE);
                    }
                } else if (this.isTopEdge(x, y, boundsInParent)) {
                    this.setCursor(Cursor.N_RESIZE);
                } else if (this.isBottomEdge(x, y, boundsInParent)) {
                    this.setCursor(Cursor.S_RESIZE);
                } else {
                    this.setCursor(Cursor.DEFAULT);
                }
                this.updateInitMouseValues((MouseEvent)mouseEvent);
            }
        });
        this.setOnMouseReleased(mouseEvent -> {
            this.isDragging = false;
        });
        this.setOnMouseDragged(mouseEvent -> {
            this.isDragging = true;
            if (!mouseEvent.isPrimaryButtonDown() || this.xOffset == -1.0 && this.yOffset == -1.0) {
                return;
            }
            if (this.primaryStage.isFullScreen() || mouseEvent.isStillSincePress() || this.primaryStage.isMaximized() || this.maximized) {
                return;
            }
            this.newX = mouseEvent.getScreenX();
            this.newY = mouseEvent.getScreenY();
            double deltax = this.newX - this.initX;
            double deltay = this.newY - this.initY;
            Cursor cursor = this.getCursor();
            if (Cursor.E_RESIZE.equals(cursor)) {
                this.setStageWidth(this.primaryStage.getWidth() + deltax);
                mouseEvent.consume();
            } else if (Cursor.NE_RESIZE.equals(cursor)) {
                if (this.setStageHeight(this.primaryStage.getHeight() - deltay)) {
                    this.primaryStage.setY(this.primaryStage.getY() + deltay);
                }
                this.setStageWidth(this.primaryStage.getWidth() + deltax);
                mouseEvent.consume();
            } else if (Cursor.SE_RESIZE.equals(cursor)) {
                this.setStageWidth(this.primaryStage.getWidth() + deltax);
                this.setStageHeight(this.primaryStage.getHeight() + deltay);
                mouseEvent.consume();
            } else if (Cursor.S_RESIZE.equals(cursor)) {
                this.setStageHeight(this.primaryStage.getHeight() + deltay);
                mouseEvent.consume();
            } else if (Cursor.W_RESIZE.equals(cursor)) {
                if (this.setStageWidth(this.primaryStage.getWidth() - deltax)) {
                    this.primaryStage.setX(this.primaryStage.getX() + deltax);
                }
                mouseEvent.consume();
            } else if (Cursor.SW_RESIZE.equals(cursor)) {
                if (this.setStageWidth(this.primaryStage.getWidth() - deltax)) {
                    this.primaryStage.setX(this.primaryStage.getX() + deltax);
                }
                this.setStageHeight(this.primaryStage.getHeight() + deltay);
                mouseEvent.consume();
            } else if (Cursor.NW_RESIZE.equals(cursor)) {
                if (this.setStageWidth(this.primaryStage.getWidth() - deltax)) {
                    this.primaryStage.setX(this.primaryStage.getX() + deltax);
                }
                if (this.setStageHeight(this.primaryStage.getHeight() - deltay)) {
                    this.primaryStage.setY(this.primaryStage.getY() + deltay);
                }
                mouseEvent.consume();
            } else if (Cursor.N_RESIZE.equals(cursor)) {
                if (this.setStageHeight(this.primaryStage.getHeight() - deltay)) {
                    this.primaryStage.setY(this.primaryStage.getY() + deltay);
                }
                mouseEvent.consume();
            } else if (this.allowMove) {
                this.primaryStage.setX(mouseEvent.getScreenX() - this.xOffset);
                this.primaryStage.setY(mouseEvent.getScreenY() - this.yOffset);
                mouseEvent.consume();
            }
        });
    }

    private void updateInitMouseValues(MouseEvent mouseEvent) {
        this.initX = mouseEvent.getScreenX();
        this.initY = mouseEvent.getScreenY();
        this.xOffset = mouseEvent.getSceneX();
        this.yOffset = mouseEvent.getSceneY();
    }

    private boolean isRightEdge(double x, double y, Bounds boundsInParent) {
        return x < this.getWidth() && x > this.getWidth() - this.contentPlaceHolder.snappedLeftInset();
    }

    private boolean isTopEdge(double x, double y, Bounds boundsInParent) {
        return y >= 0.0 && y < this.contentPlaceHolder.snappedLeftInset();
    }

    private boolean isBottomEdge(double x, double y, Bounds boundsInParent) {
        return y < this.getHeight() && y > this.getHeight() - this.contentPlaceHolder.snappedLeftInset();
    }

    private boolean isLeftEdge(double x, double y, Bounds boundsInParent) {
        return x >= 0.0 && x < this.contentPlaceHolder.snappedLeftInset();
    }

    boolean setStageWidth(double width) {
        if (width >= this.primaryStage.getMinWidth() && width >= this.buttonsContainer.getMinWidth()) {
            this.primaryStage.setWidth(width);
            this.initX = this.newX;
            return true;
        }
        if (width >= this.primaryStage.getMinWidth() && width <= this.buttonsContainer.getMinWidth()) {
            width = this.buttonsContainer.getMinWidth();
            this.primaryStage.setWidth(width);
        }
        return false;
    }

    boolean setStageHeight(double height) {
        if (height >= this.primaryStage.getMinHeight() && height >= this.buttonsContainer.getHeight()) {
            this.primaryStage.setHeight(height);
            this.initY = this.newY;
            return true;
        }
        if (height >= this.primaryStage.getMinHeight() && height <= this.buttonsContainer.getHeight()) {
            height = this.buttonsContainer.getHeight();
            this.primaryStage.setHeight(height);
        }
        return false;
    }

    public void setOnCloseButtonAction(Runnable onCloseButtonAction) {
        this.onCloseButtonAction.set((Object)onCloseButtonAction);
    }

    public final BooleanProperty customMaximizeProperty() {
        return this.customMaximize;
    }

    public final boolean isCustomMaximize() {
        return this.customMaximizeProperty().get();
    }

    public final void setCustomMaximize(boolean customMaximize) {
        this.customMaximizeProperty().set(customMaximize);
    }

    public void setMaximized(boolean maximized) {
        if (this.maximized != maximized) {
            Platform.runLater(() -> this.btnMax.fire());
        }
    }

    public void setContent(Node content) {
        this.contentPlaceHolder.getChildren().setAll((Object[])new Node[]{content});
    }
}

