/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.animation.alert;

import com.jfoenix.animation.alert.CenterTransition;
import com.jfoenix.animation.alert.HorizontalTransition;
import com.jfoenix.animation.alert.VerticalTransition;
import java.util.function.Function;
import javafx.animation.Animation;
import javafx.animation.Transition;
import javafx.scene.Node;

public interface JFXAlertAnimation {
    public static final Function<Transition, Transition> inverseAnimation = transition -> {
        transition.jumpTo(transition.getCycleDuration());
        transition.setRate(-1.0);
        return transition;
    };
    public static final JFXAlertAnimation LEFT_ANIMATION = new JFXAlertAnimation(){

        @Override
        public void initAnimation(Node contentContainer, Node overlay) {
            overlay.setOpacity(0.0);
            contentContainer.setTranslateX(-(contentContainer.getLayoutX() + contentContainer.getLayoutBounds().getMaxX()));
        }

        @Override
        public Animation createShowingAnimation(Node contentContainer, Node overlay) {
            return new HorizontalTransition(true, contentContainer, overlay);
        }

        @Override
        public Animation createHidingAnimation(Node contentContainer, Node overlay) {
            return (Animation)inverseAnimation.apply(new HorizontalTransition(true, contentContainer, overlay));
        }
    };
    public static final JFXAlertAnimation RIGHT_ANIMATION = new JFXAlertAnimation(){

        @Override
        public void initAnimation(Node contentContainer, Node overlay) {
            overlay.setOpacity(0.0);
            contentContainer.setTranslateX(contentContainer.getLayoutX() + contentContainer.getLayoutBounds().getMaxX());
        }

        @Override
        public Animation createShowingAnimation(Node contentContainer, Node overlay) {
            return new HorizontalTransition(false, contentContainer, overlay);
        }

        @Override
        public Animation createHidingAnimation(Node contentContainer, Node overlay) {
            return (Animation)inverseAnimation.apply(new HorizontalTransition(false, contentContainer, overlay));
        }
    };
    public static final JFXAlertAnimation TOP_ANIMATION = new JFXAlertAnimation(){

        @Override
        public void initAnimation(Node contentContainer, Node overlay) {
            overlay.setOpacity(0.0);
            contentContainer.setTranslateY(-(contentContainer.getLayoutY() + contentContainer.getLayoutBounds().getMaxY()));
        }

        @Override
        public Animation createShowingAnimation(Node contentContainer, Node overlay) {
            return new VerticalTransition(true, contentContainer, overlay);
        }

        @Override
        public Animation createHidingAnimation(Node contentContainer, Node overlay) {
            return (Animation)inverseAnimation.apply(new VerticalTransition(true, contentContainer, overlay));
        }
    };
    public static final JFXAlertAnimation BOTTOM_ANIMATION = new JFXAlertAnimation(){

        @Override
        public void initAnimation(Node contentContainer, Node overlay) {
            overlay.setOpacity(0.0);
            contentContainer.setTranslateY(contentContainer.getLayoutY() + contentContainer.getLayoutBounds().getMaxY());
        }

        @Override
        public Animation createShowingAnimation(Node contentContainer, Node overlay) {
            return new VerticalTransition(false, contentContainer, overlay);
        }

        @Override
        public Animation createHidingAnimation(Node contentContainer, Node overlay) {
            return (Animation)inverseAnimation.apply(new VerticalTransition(false, contentContainer, overlay));
        }
    };
    public static final JFXAlertAnimation CENTER_ANIMATION = new JFXAlertAnimation(){

        @Override
        public void initAnimation(Node contentContainer, Node overlay) {
            overlay.setOpacity(0.0);
            contentContainer.setScaleX(0.0);
            contentContainer.setScaleY(0.0);
        }

        @Override
        public Animation createShowingAnimation(Node contentContainer, Node overlay) {
            return new CenterTransition(contentContainer, overlay);
        }

        @Override
        public Animation createHidingAnimation(Node contentContainer, Node overlay) {
            return (Animation)inverseAnimation.apply(new CenterTransition(contentContainer, overlay));
        }
    };

    public void initAnimation(Node var1, Node var2);

    public Animation createShowingAnimation(Node var1, Node var2);

    public Animation createHidingAnimation(Node var1, Node var2);
}

