/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.pci.ids.model;

import java.util.Objects;
import org.glavo.pci.ids.internal.ArgumentValidator;

public final class Subsystem
implements Comparable<Subsystem> {
    private final int id;
    private final String name;
    private final String comment;
    private final int vendorId;

    public Subsystem(int id, String name, String comment, int vendorId) {
        ArgumentValidator.requireUnsignedShort(vendorId, "Subsystem vendor ID");
        ArgumentValidator.requireUnsignedShort(id, "Subsystem ID");
        ArgumentValidator.requireNonBlank(name, "Subsystem name");
        this.id = id;
        this.name = name;
        this.comment = comment;
        this.vendorId = vendorId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public int getVendorId() {
        return this.vendorId;
    }

    @Override
    public int compareTo(Subsystem t) {
        if (this.vendorId == t.vendorId) {
            return Integer.compare(this.id, t.id);
        }
        return Integer.compare(this.vendorId, t.vendorId);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Subsystem)) {
            return false;
        }
        Subsystem subsystem = (Subsystem)o;
        return Objects.equals(this.id, subsystem.id) && Objects.equals(this.name, subsystem.name) && Objects.equals(this.vendorId, subsystem.vendorId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.vendorId);
    }

    public String toString() {
        return String.format("Subsystem[id=%04x, name=%s, comment=%s, vendorId=%04x]", this.getId(), this.getName(), this.getComment(), this.getVendorId());
    }
}

