/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.scene.Parent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.util.Duration;

public class JFXSpinner
extends StackPane {
    private Color greenColor;
    private Color redColor;
    private Color yellowColor;
    private Color blueColor;
    private Timeline timeline;
    private Arc arc;
    private boolean initialized;
    private static final String DEFAULT_STYLE_CLASS = "jfx-spinner";
    private StyleableDoubleProperty radius = new SimpleStyleableDoubleProperty(StyleableProperties.access$000(), (Object)this, "radius", Double.valueOf(12.0));
    private StyleableDoubleProperty startingAngle = new SimpleStyleableDoubleProperty(StyleableProperties.access$100(), (Object)this, "starting_angle", Double.valueOf(360.0 - Math.random() * 720.0));
    private List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public JFXSpinner() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.initialize();
    }

    private void initialize() {
        this.blueColor = Color.valueOf((String)"#4285f4");
        this.redColor = Color.valueOf((String)"#db4437");
        this.yellowColor = Color.valueOf((String)"#f4b400");
        this.greenColor = Color.valueOf((String)"#0F9D58");
        this.arc = new Arc(0.0, 0.0, 12.0, 12.0, 0.0, 360.0);
        this.arc.setFill((Paint)Color.TRANSPARENT);
        this.arc.setStrokeWidth(3.0);
        this.arc.getStyleClass().addAll((Object[])new String[]{"arc"});
        this.arc.radiusXProperty().bindBidirectional((Property)this.radius);
        this.arc.radiusYProperty().bindBidirectional((Property)this.radius);
        this.getChildren().add((Object)this.arc);
        this.minWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.getRadius() * 2.0 + this.arc.getStrokeWidth() + 5.0, (Observable[])new Observable[]{this.radius, this.arc.strokeWidthProperty()}));
        this.maxWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.getRadius() * 2.0 + this.arc.getStrokeWidth() + 5.0, (Observable[])new Observable[]{this.radius, this.arc.strokeWidthProperty()}));
        this.minHeightProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.getRadius() * 2.0 + this.arc.getStrokeWidth() + 5.0, (Observable[])new Observable[]{this.radius, this.arc.strokeWidthProperty()}));
        this.maxHeightProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.getRadius() * 2.0 + this.arc.getStrokeWidth() + 5.0, (Observable[])new Observable[]{this.radius, this.arc.strokeWidthProperty()}));
    }

    private KeyFrame[] getKeyFrames(double angle, double duration, Color color) {
        KeyFrame[] frames = new KeyFrame[]{new KeyFrame(Duration.seconds((double)duration), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)5, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(angle + 45.0 + this.getStartingAngle()), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)(duration + 0.4)), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)250, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(angle + 90.0 + this.getStartingAngle()), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)(duration + 0.7)), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)250, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(angle + 135.0 + this.getStartingAngle()), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)(duration + 1.1)), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)5, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(angle + 435.0 + this.getStartingAngle()), Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.strokeProperty(), (Object)color, Interpolator.EASE_BOTH)})};
        return frames;
    }

    protected void layoutChildren() {
        if (!this.initialized) {
            super.layoutChildren();
            Color initialColor = (Color)this.arc.getStroke();
            if (initialColor == null) {
                this.arc.setStroke((Paint)this.blueColor);
            }
            KeyFrame[] blueFrame = this.getKeyFrames(0.0, 0.0, initialColor == null ? this.blueColor : initialColor);
            KeyFrame[] redFrame = this.getKeyFrames(450.0, 1.4, initialColor == null ? this.redColor : initialColor);
            KeyFrame[] yellowFrame = this.getKeyFrames(900.0, 2.8, initialColor == null ? this.yellowColor : initialColor);
            KeyFrame[] greenFrame = this.getKeyFrames(1350.0, 4.2, initialColor == null ? this.greenColor : initialColor);
            KeyFrame endingFrame = new KeyFrame(Duration.seconds((double)5.6), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)5, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(1845.0 + this.getStartingAngle()), Interpolator.LINEAR)});
            if (this.timeline != null) {
                this.timeline.stop();
            }
            this.timeline = new Timeline(new KeyFrame[]{blueFrame[0], blueFrame[1], blueFrame[2], blueFrame[3], redFrame[0], redFrame[1], redFrame[2], redFrame[3], yellowFrame[0], yellowFrame[1], yellowFrame[2], yellowFrame[3], greenFrame[0], greenFrame[1], greenFrame[2], greenFrame[3], endingFrame});
            this.timeline.setCycleCount(-1);
            this.timeline.setRate(1.0);
            this.timeline.play();
            this.initialized = true;
        }
    }

    public final StyleableDoubleProperty radiusProperty() {
        return this.radius;
    }

    public final double getRadius() {
        return this.radiusProperty().get();
    }

    public final void setRadius(double radius) {
        this.radiusProperty().set(radius);
    }

    public final StyleableDoubleProperty startingAngleProperty() {
        return this.startingAngle;
    }

    public final double getStartingAngle() {
        return this.startingAngleProperty().get();
    }

    public final void setStartingAngle(double startingAngle) {
        this.startingAngleProperty().set(startingAngle);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        if (this.STYLEABLES == null) {
            ArrayList styleables = new ArrayList(Parent.getClassCssMetaData());
            styleables.addAll(JFXSpinner.getClassCssMetaData());
            styleables.addAll(StackPane.getClassCssMetaData());
            this.STYLEABLES = Collections.unmodifiableList(styleables);
        }
        return this.STYLEABLES;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXSpinner, Number> RADIUS = new CssMetaData<JFXSpinner, Number>("-jfx-radius", StyleConverter.getSizeConverter(), (Number)12){

            public boolean isSettable(JFXSpinner control) {
                return control.radius == null || !control.radius.isBound();
            }

            public StyleableDoubleProperty getStyleableProperty(JFXSpinner control) {
                return control.radius;
            }
        };
        private static final CssMetaData<JFXSpinner, Number> STARTING_ANGLE = new CssMetaData<JFXSpinner, Number>("-jfx-starting-angle", StyleConverter.getSizeConverter(), (Number)(360.0 - Math.random() * 720.0)){

            public boolean isSettable(JFXSpinner control) {
                return control.startingAngle == null || !control.startingAngle.isBound();
            }

            public StyleableDoubleProperty getStyleableProperty(JFXSpinner control) {
                return control.startingAngle;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return RADIUS;
        }

        static /* synthetic */ CssMetaData access$100() {
            return STARTING_ANGLE;
        }

        static {
            ArrayList styleables = new ArrayList(Parent.getClassCssMetaData());
            Collections.addAll(styleables, RADIUS, STARTING_ANGLE);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

