/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth;

import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.yggdrasil.Texture;
import org.jackhuang.hmcl.auth.yggdrasil.TextureType;
import org.jackhuang.hmcl.util.ToStringBuilder;
import org.jackhuang.hmcl.util.javafx.ObservableHelper;

public abstract class Account
implements Observable {
    private final BooleanProperty portable = new SimpleBooleanProperty(false);
    private final ObservableHelper helper = new ObservableHelper(this);

    public abstract String getUsername();

    public abstract String getCharacter();

    public abstract UUID getUUID();

    public abstract AuthInfo logIn() throws AuthenticationException;

    public abstract AuthInfo playOffline() throws AuthenticationException;

    public boolean canUploadSkin() {
        return false;
    }

    public void uploadSkin(boolean isSlim, Path file) throws AuthenticationException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Unsupported Operation");
    }

    public abstract Map<Object, Object> toStorage();

    public void clearCache() {
    }

    public BooleanProperty portableProperty() {
        return this.portable;
    }

    public boolean isPortable() {
        return this.portable.get();
    }

    public void setPortable(boolean value) {
        this.portable.set(value);
    }

    public abstract String getIdentifier();

    public void addListener(InvalidationListener listener) {
        this.helper.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.helper.removeListener(listener);
    }

    protected void invalidate() {
        Platform.runLater(this.helper::invalidate);
    }

    public ObjectBinding<Optional<Map<TextureType, Texture>>> getTextures() {
        return Bindings.createObjectBinding(Optional::empty, (Observable[])new Observable[0]);
    }

    public int hashCode() {
        return Objects.hash(this.portable);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Account)) {
            return false;
        }
        Account another = (Account)obj;
        return this.isPortable() == another.isPortable();
    }

    public String toString() {
        return new ToStringBuilder(this).append("username", this.getUsername()).append("character", this.getCharacter()).append("uuid", this.getUUID()).append("portable", this.isPortable()).toString();
    }
}

