/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.microsoft;

import java.util.Map;
import java.util.Objects;
import org.jackhuang.hmcl.auth.AccountFactory;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CharacterSelector;
import org.jackhuang.hmcl.auth.OAuth;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftAccount;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftService;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftSession;

public class MicrosoftAccountFactory
extends AccountFactory<MicrosoftAccount> {
    private final MicrosoftService service;

    public MicrosoftAccountFactory(MicrosoftService service) {
        this.service = service;
    }

    @Override
    public AccountFactory.AccountLoginType getLoginType() {
        return AccountFactory.AccountLoginType.NONE;
    }

    @Override
    public MicrosoftAccount create(CharacterSelector selector, String username, String password, AccountFactory.ProgressCallback progressCallback, Object additionalData) throws AuthenticationException {
        return new MicrosoftAccount(this.service, (OAuth.GrantFlow)((Object)additionalData));
    }

    @Override
    public MicrosoftAccount fromStorage(Map<Object, Object> storage) {
        Objects.requireNonNull(storage);
        MicrosoftSession session = MicrosoftSession.fromStorage(storage);
        return new MicrosoftAccount(this.service, session);
    }
}

