/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import java.util.Locale;
import java.util.function.Consumer;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;

public class HintPane
extends VBox {
    private final Text label = new Text();
    private final StringProperty text = new SimpleStringProperty((Object)this, "text");
    private final TextFlow flow = new TextFlow();

    public HintPane() {
        this(MessageDialogPane.MessageType.INFO);
    }

    public HintPane(MessageDialogPane.MessageType type) {
        this.setFillWidth(true);
        this.getStyleClass().addAll((Object[])new String[]{"hint", type.name().toLowerCase(Locale.ROOT)});
        HBox hbox = new HBox(new Node[]{type.getIcon().createIcon(16.0), new Text(type.getDisplayName())});
        hbox.setAlignment(Pos.CENTER_LEFT);
        hbox.setSpacing(2.0);
        this.flow.getChildren().setAll((Object[])new Node[]{this.label});
        this.getChildren().setAll((Object[])new Node[]{hbox, this.flow});
        this.label.textProperty().bind((ObservableValue)this.text);
        VBox.setMargin((Node)this.flow, (Insets)new Insets(2.0, 2.0, 0.0, 2.0));
    }

    public String getText() {
        return (String)this.text.get();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }

    public void setSegment(String segment) {
        this.setSegment(segment, Controllers::onHyperlinkAction);
    }

    public void setSegment(String segment, Consumer<String> hyperlinkAction) {
        this.flow.getChildren().setAll(FXUtils.parseSegment(segment, hyperlinkAction));
    }

    public void setChildren(Node ... children) {
        this.flow.getChildren().setAll((Object[])children);
    }
}

