/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.image.Image;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class GameItem {
    private static final ThreadPoolExecutor POOL_VERSION_RESOLVE = Lang.threadPool("VersionResolve", true, 1, 10L, TimeUnit.SECONDS);
    protected final Profile profile;
    protected final String id;
    private boolean initialized = false;
    private StringProperty title;
    private StringProperty tag;
    private StringProperty subtitle;
    private ObjectProperty<Image> image;

    public GameItem(Profile profile, String id) {
        this.profile = profile;
        this.id = id;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getId() {
        return this.id;
    }

    private void init() {
        record Result(@Nullable String gameVersion, @Nullable String tag) {
        }
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.title = new SimpleStringProperty();
        this.tag = new SimpleStringProperty();
        this.subtitle = new SimpleStringProperty();
        this.image = new SimpleObjectProperty();
        CompletableFuture.supplyAsync(() -> {
            Optional<String> gameVersion = this.profile.getRepository().getGameVersion(this.id);
            String modPackVersion = null;
            try {
                ModpackConfiguration<?> config = this.profile.getRepository().readModpackConfiguration(this.id);
                modPackVersion = config != null ? config.getVersion() : null;
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to read modpack configuration from " + this.id, e);
            }
            return new Result(gameVersion.orElse(null), modPackVersion);
        }, POOL_VERSION_RESOLVE).whenCompleteAsync((result, exception) -> {
            if (exception == null) {
                if (result.tag != null) {
                    this.tag.set((Object)result.tag);
                }
                StringBuilder libraries = new StringBuilder(Objects.requireNonNullElse(result.gameVersion, I18n.i18n("message.unknown")));
                LibraryAnalyzer analyzer = LibraryAnalyzer.analyze(this.profile.getRepository().getResolvedPreservingPatchesVersion(this.id), result.gameVersion);
                for (LibraryAnalyzer.LibraryMark mark : analyzer) {
                    String libraryId = mark.getLibraryId();
                    String libraryVersion = mark.getLibraryVersion();
                    if (libraryId.equals(LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId()) || !I18n.hasKey("install.installer." + libraryId)) continue;
                    libraries.append(", ").append(I18n.i18n("install.installer." + libraryId));
                    if (libraryVersion == null) continue;
                    libraries.append(": ").append(libraryVersion.replaceAll("(?i)" + libraryId, ""));
                }
                this.subtitle.set((Object)libraries.toString());
            } else {
                Logger.LOG.warning("Failed to read version info from " + this.id, (Throwable)exception);
            }
        }, Schedulers.javafx());
        this.title.set((Object)this.id);
        this.image.set((Object)this.profile.getRepository().getVersionIconImage(this.id));
    }

    public ReadOnlyStringProperty titleProperty() {
        this.init();
        return this.title;
    }

    public ReadOnlyStringProperty tagProperty() {
        this.init();
        return this.tag;
    }

    public ReadOnlyStringProperty subtitleProperty() {
        this.init();
        return this.subtitle;
    }

    public ReadOnlyObjectProperty<Image> imageProperty() {
        this.init();
        return this.image;
    }
}

