/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.ui.versions.GameItem;
import org.jackhuang.hmcl.ui.versions.Versions;

public class GameListItem
extends GameItem {
    private final boolean isModpack;
    private final BooleanProperty selected = new SimpleBooleanProperty((Object)this, "selected");

    public GameListItem(Profile profile, String id) {
        super(profile, id);
        this.isModpack = profile.getRepository().isModpack(id);
        this.selected.bind((ObservableValue)profile.selectedVersionProperty().isEqualTo(id));
    }

    public ReadOnlyBooleanProperty selectedProperty() {
        return this.selected;
    }

    public void rename() {
        Versions.renameVersion(this.profile, this.id);
    }

    public void duplicate() {
        Versions.duplicateVersion(this.profile, this.id);
    }

    public void remove() {
        Versions.deleteVersion(this.profile, this.id);
    }

    public void export() {
        Versions.exportVersion(this.profile, this.id);
    }

    public void browse() {
        Versions.openFolder(this.profile, this.id);
    }

    public void testGame() {
        Versions.testGame(this.profile, this.id);
    }

    public void launch() {
        Versions.launch(this.profile, this.id, new Consumer[0]);
    }

    public void modifyGameSettings() {
        Versions.modifyGameSettings(this.profile, this.id);
    }

    public void generateLaunchScript() {
        Versions.generateLaunchScript(this.profile, this.id, new Consumer[0]);
    }

    public boolean canUpdate() {
        return this.isModpack;
    }

    public void update() {
        Versions.updateVersion(this.profile, this.id);
    }
}

