/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXPopup;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.event.EventBus;
import org.jackhuang.hmcl.event.EventPriority;
import org.jackhuang.hmcl.event.RefreshedVersionsEvent;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.IconedMenuItem;
import org.jackhuang.hmcl.ui.construct.MenuSeparator;
import org.jackhuang.hmcl.ui.construct.Navigator;
import org.jackhuang.hmcl.ui.construct.PageCloseEvent;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.ui.construct.TabHeader;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.versions.InstallerListPage;
import org.jackhuang.hmcl.ui.versions.ModListPage;
import org.jackhuang.hmcl.ui.versions.ResourcepackListPage;
import org.jackhuang.hmcl.ui.versions.SchematicsPage;
import org.jackhuang.hmcl.ui.versions.VersionSettingsPage;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.ui.versions.WorldListPage;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;

public class VersionPage
extends DecoratorAnimatedPage
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper();
    private final TabHeader tab;
    private final TabControl.Tab<VersionSettingsPage> versionSettingsTab = new TabControl.Tab("versionSettingsTab");
    private final TabControl.Tab<InstallerListPage> installerListTab = new TabControl.Tab("installerListTab");
    private final TabControl.Tab<ModListPage> modListTab = new TabControl.Tab("modListTab");
    private final TabControl.Tab<WorldListPage> worldListTab = new TabControl.Tab("worldList");
    private final TabControl.Tab<SchematicsPage> schematicsTab = new TabControl.Tab("schematicsTab");
    private final TabControl.Tab<ResourcepackListPage> resourcePackTab = new TabControl.Tab("resourcePackTab");
    private final TransitionPane transitionPane = new TransitionPane();
    private final BooleanProperty currentVersionUpgradable = new SimpleBooleanProperty();
    private final ObjectProperty<Profile.ProfileVersion> version = new SimpleObjectProperty();
    private final WeakListenerHolder listenerHolder = new WeakListenerHolder();
    private String preferredVersionName = null;

    public VersionPage() {
        this.versionSettingsTab.setNodeSupplier(this.loadVersionFor(() -> new VersionSettingsPage(false)));
        this.installerListTab.setNodeSupplier(this.loadVersionFor(InstallerListPage::new));
        this.modListTab.setNodeSupplier(this.loadVersionFor(ModListPage::new));
        this.resourcePackTab.setNodeSupplier(this.loadVersionFor(ResourcepackListPage::new));
        this.worldListTab.setNodeSupplier(this.loadVersionFor(WorldListPage::new));
        this.schematicsTab.setNodeSupplier(this.loadVersionFor(SchematicsPage::new));
        this.tab = new TabHeader(this.transitionPane, this.versionSettingsTab, this.installerListTab, this.modListTab, this.resourcePackTab, this.worldListTab, this.schematicsTab);
        this.tab.select(this.versionSettingsTab);
        this.addEventHandler(Navigator.NavigationEvent.NAVIGATED, this::onNavigated);
        this.listenerHolder.add(EventBus.EVENT_BUS.channel(RefreshedVersionsEvent.class).registerWeak(event -> this.checkSelectedVersion(), EventPriority.HIGHEST));
    }

    private void checkSelectedVersion() {
        FXUtils.runInFX(() -> {
            if (this.version.get() == null) {
                return;
            }
            HMCLGameRepository repository = ((Profile.ProfileVersion)this.version.get()).getProfile().getRepository();
            if (!repository.hasVersion(((Profile.ProfileVersion)this.version.get()).getVersion())) {
                if (this.preferredVersionName != null) {
                    this.loadVersion(this.preferredVersionName, ((Profile.ProfileVersion)this.version.get()).getProfile());
                } else {
                    this.fireEvent(new PageCloseEvent());
                }
            }
        });
    }

    private <T extends Node> Supplier<T> loadVersionFor(Supplier<T> nodeSupplier) {
        return () -> {
            Node node = (Node)nodeSupplier.get();
            if (this.version.get() != null && node instanceof VersionLoadable) {
                ((VersionLoadable)node).loadVersion(((Profile.ProfileVersion)this.version.get()).getProfile(), ((Profile.ProfileVersion)this.version.get()).getVersion());
            }
            return node;
        };
    }

    public void showInstanceSettings() {
        this.tab.select(this.versionSettingsTab, false);
    }

    public void setVersion(String version, Profile profile) {
        this.version.set((Object)new Profile.ProfileVersion(profile, version));
    }

    public void loadVersion(String version, Profile profile) {
        if (!(this.version.get() == null || this.getProfile().getRepository().isLoaded() && this.getProfile().getRepository().hasVersion(version))) {
            Platform.runLater(() -> this.fireEvent(new PageCloseEvent()));
            return;
        }
        this.setVersion(version, profile);
        this.preferredVersionName = version;
        if (this.versionSettingsTab.isInitialized()) {
            this.versionSettingsTab.getNode().loadVersion(profile, version);
        }
        if (this.installerListTab.isInitialized()) {
            this.installerListTab.getNode().loadVersion(profile, version);
        }
        if (this.modListTab.isInitialized()) {
            this.modListTab.getNode().loadVersion(profile, version);
        }
        if (this.resourcePackTab.isInitialized()) {
            this.resourcePackTab.getNode().loadVersion(profile, version);
        }
        if (this.worldListTab.isInitialized()) {
            this.worldListTab.getNode().loadVersion(profile, version);
        }
        if (this.schematicsTab.isInitialized()) {
            this.schematicsTab.getNode().loadVersion(profile, version);
        }
        this.currentVersionUpgradable.set(profile.getRepository().isModpack(version));
    }

    private void onNavigated(Navigator.NavigationEvent event) {
        if (this.version.get() == null) {
            throw new IllegalStateException();
        }
        if (!this.getProfile().getRepository().isLoaded() || !this.getProfile().getRepository().hasVersion(this.getVersion())) {
            Platform.runLater(() -> this.fireEvent(new PageCloseEvent()));
            return;
        }
        this.loadVersion(this.getVersion(), this.getProfile());
    }

    private void onBrowse(String sub) {
        FXUtils.openFolder(this.getProfile().getRepository().getRunDirectory(this.getVersion()).resolve(sub));
    }

    private void redownloadAssetIndex() {
        Versions.updateGameAssets(this.getProfile(), this.getVersion());
    }

    private void clearLibraries() {
        FileUtils.deleteDirectoryQuietly(this.getProfile().getRepository().getBaseDirectory().resolve("libraries"));
    }

    private void clearAssets() {
        HMCLGameRepository baseDirectory = this.getProfile().getRepository();
        FileUtils.deleteDirectoryQuietly(baseDirectory.getBaseDirectory().resolve("assets"));
        if (this.version.get() != null) {
            FileUtils.deleteDirectoryQuietly(baseDirectory.getRunDirectory(((Profile.ProfileVersion)this.version.get()).getVersion()).resolve("resources"));
        }
    }

    private void clearJunkFiles() {
        Versions.cleanVersion(this.getProfile(), this.getVersion());
    }

    private void testGame() {
        Versions.testGame(this.getProfile(), this.getVersion());
    }

    private void updateGame() {
        Versions.updateVersion(this.getProfile(), this.getVersion());
    }

    private void generateLaunchScript() {
        Versions.generateLaunchScript(this.getProfile(), this.getVersion(), new Consumer[0]);
    }

    private void export() {
        Versions.exportVersion(this.getProfile(), this.getVersion());
    }

    private void rename() {
        Versions.renameVersion(this.getProfile(), this.getVersion()).thenApply(newVersionName -> {
            this.preferredVersionName = newVersionName;
            return this.preferredVersionName;
        });
    }

    private void remove() {
        Versions.deleteVersion(this.getProfile(), this.getVersion());
    }

    private void duplicate() {
        Versions.duplicateVersion(this.getProfile(), this.getVersion());
    }

    public Profile getProfile() {
        return Optional.ofNullable((Profile.ProfileVersion)this.version.get()).map(Profile.ProfileVersion::getProfile).orElse(null);
    }

    public String getVersion() {
        return Optional.ofNullable((Profile.ProfileVersion)this.version.get()).map(Profile.ProfileVersion::getVersion).orElse(null);
    }

    protected Skin createDefaultSkin() {
        return new Skin(this);
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    public static class Skin
    extends DecoratorAnimatedPage.DecoratorAnimatedPageSkin<VersionPage> {
        protected Skin(VersionPage control) {
            super(control);
            AdvancedListBox sideBar = new AdvancedListBox().addNavigationDrawerTab(control.tab, control.versionSettingsTab, I18n.i18n("settings.game"), SVG.SETTINGS, SVG.SETTINGS_FILL).addNavigationDrawerTab(control.tab, control.installerListTab, I18n.i18n("settings.tabs.installers"), SVG.DEPLOYED_CODE, SVG.DEPLOYED_CODE_FILL).addNavigationDrawerTab(control.tab, control.modListTab, I18n.i18n("mods.manage"), SVG.EXTENSION, SVG.EXTENSION_FILL).addNavigationDrawerTab(control.tab, control.resourcePackTab, I18n.i18n("resourcepack.manage"), SVG.TEXTURE).addNavigationDrawerTab(control.tab, control.worldListTab, I18n.i18n("world.manage"), SVG.PUBLIC).addNavigationDrawerTab(control.tab, control.schematicsTab, I18n.i18n("schematics.manage"), SVG.SCHEMA, SVG.SCHEMA_FILL);
            VBox.setVgrow((Node)sideBar, (Priority)Priority.ALWAYS);
            PopupMenu browseList = new PopupMenu();
            JFXPopup browsePopup = new JFXPopup((Region)browseList);
            browseList.getContent().setAll((Object[])new Node[]{new IconedMenuItem(SVG.STADIA_CONTROLLER, I18n.i18n("folder.game"), () -> control.onBrowse(""), browsePopup), new IconedMenuItem(SVG.EXTENSION, I18n.i18n("folder.mod"), () -> control.onBrowse("mods"), browsePopup), new IconedMenuItem(SVG.TEXTURE, I18n.i18n("folder.resourcepacks"), () -> control.onBrowse("resourcepacks"), browsePopup), new IconedMenuItem(SVG.PUBLIC, I18n.i18n("folder.saves"), () -> control.onBrowse("saves"), browsePopup), new IconedMenuItem(SVG.SCHEMA, I18n.i18n("folder.schematics"), () -> control.onBrowse("schematics"), browsePopup), new IconedMenuItem(SVG.WB_SUNNY, I18n.i18n("folder.shaderpacks"), () -> control.onBrowse("shaderpacks"), browsePopup), new IconedMenuItem(SVG.SCREENSHOT_MONITOR, I18n.i18n("folder.screenshots"), () -> control.onBrowse("screenshots"), browsePopup), new IconedMenuItem(SVG.SETTINGS, I18n.i18n("folder.config"), () -> control.onBrowse("config"), browsePopup), new IconedMenuItem(SVG.SCRIPT, I18n.i18n("folder.logs"), () -> control.onBrowse("logs"), browsePopup)});
            PopupMenu managementList = new PopupMenu();
            JFXPopup managementPopup = new JFXPopup((Region)managementList);
            Object[] objectArray = new Node[12];
            objectArray[0] = new IconedMenuItem(SVG.ROCKET_LAUNCH, I18n.i18n("version.launch.test"), control::testGame, managementPopup);
            objectArray[1] = new IconedMenuItem(SVG.SCRIPT, I18n.i18n("version.launch_script"), control::generateLaunchScript, managementPopup);
            objectArray[2] = new MenuSeparator();
            objectArray[3] = new IconedMenuItem(SVG.EDIT, I18n.i18n("version.manage.rename"), control::rename, managementPopup);
            objectArray[4] = new IconedMenuItem(SVG.FOLDER_COPY, I18n.i18n("version.manage.duplicate"), control::duplicate, managementPopup);
            objectArray[5] = new IconedMenuItem(SVG.DELETE, I18n.i18n("version.manage.remove"), control::remove, managementPopup);
            objectArray[6] = new IconedMenuItem(SVG.OUTPUT, I18n.i18n("modpack.export"), control::export, managementPopup);
            objectArray[7] = new MenuSeparator();
            objectArray[8] = new IconedMenuItem(null, I18n.i18n("version.manage.redownload_assets_index"), control::redownloadAssetIndex, managementPopup);
            objectArray[9] = new IconedMenuItem(null, I18n.i18n("version.manage.remove_assets"), control::clearAssets, managementPopup);
            objectArray[10] = new IconedMenuItem(null, I18n.i18n("version.manage.remove_libraries"), control::clearLibraries, managementPopup);
            objectArray[11] = new IconedMenuItem(null, I18n.i18n("version.manage.clean"), control::clearJunkFiles, managementPopup).addTooltip(I18n.i18n("version.manage.clean.tooltip"));
            managementList.getContent().setAll(objectArray);
            AdvancedListBox toolbar = new AdvancedListBox().addNavigationDrawerItem(I18n.i18n("version.update"), SVG.UPDATE, control::updateGame, upgradeItem -> upgradeItem.visibleProperty().bind((ObservableValue)control.currentVersionUpgradable)).addNavigationDrawerItem(I18n.i18n("version.launch.test"), SVG.ROCKET_LAUNCH, control::testGame).addNavigationDrawerItem(I18n.i18n("settings.game.exploration"), SVG.FOLDER_OPEN, null, browseMenuItem -> browseMenuItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> browsePopup.show((Node)browseMenuItem, JFXPopup.PopupVPosition.BOTTOM, JFXPopup.PopupHPosition.LEFT, browseMenuItem.getWidth(), 0.0)))).addNavigationDrawerItem(I18n.i18n("settings.game.management"), SVG.MENU, null, managementItem -> managementItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> managementPopup.show((Node)managementItem, JFXPopup.PopupVPosition.BOTTOM, JFXPopup.PopupHPosition.LEFT, managementItem.getWidth(), 0.0))));
            toolbar.getStyleClass().add((Object)"advanced-list-box-clear-padding");
            FXUtils.setLimitHeight((Region)toolbar, 184.0);
            this.setLeft(new Node[]{sideBar, toolbar});
            control.state.bind((ObservableValue)Bindings.createObjectBinding(() -> DecoratorPage.State.fromTitle(I18n.i18n("version.manage.manage.title", ((VersionPage)this.getSkinnable()).getVersion()), -1.0), (Observable[])new Observable[]{((VersionPage)this.getSkinnable()).version}));
            this.setCenter(new Node[]{control.transitionPane});
        }
    }

    public static interface VersionLoadable {
        public void loadVersion(Profile var1, String var2);
    }
}

