/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

public final class ByteArray {
    private static final VarHandle SHORT_LE = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle INT_LE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle LONG_LE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle SHORT_BE = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.BIG_ENDIAN);
    private static final VarHandle INT_BE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN);
    private static final VarHandle LONG_BE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);

    public static byte getByte(byte[] array, int offset) {
        return array[offset];
    }

    public static int getUnsignedByte(byte[] array, int offset) {
        return Byte.toUnsignedInt(ByteArray.getByte(array, offset));
    }

    public static short getShortLE(byte[] array, int offset) {
        return SHORT_LE.get(array, offset);
    }

    public static int getUnsignedShortLE(byte[] array, int offset) {
        return Short.toUnsignedInt(ByteArray.getShortLE(array, offset));
    }

    public static short getShortBE(byte[] array, int offset) {
        return SHORT_BE.get(array, offset);
    }

    public static int getUnsignedShortBE(byte[] array, int offset) {
        return Short.toUnsignedInt(ByteArray.getShortBE(array, offset));
    }

    public static int getIntLE(byte[] array, int offset) {
        return INT_LE.get(array, offset);
    }

    public static long getUnsignedIntLE(byte[] array, int offset) {
        return Integer.toUnsignedLong(ByteArray.getIntLE(array, offset));
    }

    public static int getIntBE(byte[] array, int offset) {
        return INT_BE.get(array, offset);
    }

    public static long getUnsignedIntBE(byte[] array, int offset) {
        return Integer.toUnsignedLong(ByteArray.getIntBE(array, offset));
    }

    public static long getLongLE(byte[] array, int offset) {
        return LONG_LE.get(array, offset);
    }

    public static long getLongBE(byte[] array, int offset) {
        return LONG_BE.get(array, offset);
    }

    public static void setByte(byte[] array, int offset, byte value) {
        array[offset] = value;
    }

    public static void setUnsignedByte(byte[] array, int offset, int value) {
        array[offset] = (byte)(value & 0xFF);
    }

    public static void setShortLE(byte[] array, int offset, short value) {
        SHORT_LE.set(array, offset, value);
    }

    public static void setUnsignedShortLE(byte[] array, int offset, int value) {
        ByteArray.setShortLE(array, offset, (short)(value & 0xFFFF));
    }

    public static void setShortBE(byte[] array, int offset, short value) {
        SHORT_BE.set(array, offset, value);
    }

    public static void setUnsignedShortBE(byte[] array, int offset, int value) {
        ByteArray.setShortBE(array, offset, (short)(value & 0xFFFF));
    }

    public static void setIntLE(byte[] array, int offset, int value) {
        INT_LE.set(array, offset, value);
    }

    public static void setUnsignedIntLE(byte[] array, int offset, long value) {
        ByteArray.setIntLE(array, offset, (int)(value & 0xFFFFFFFFL));
    }

    public static void setIntBE(byte[] array, int offset, int value) {
        INT_BE.set(array, offset, value);
    }

    public static void setUnsignedIntBE(byte[] array, int offset, long value) {
        ByteArray.setIntBE(array, offset, (int)(value & 0xFFFFFFFFL));
    }

    public static void setLongLE(byte[] array, int offset, long value) {
        LONG_LE.set(array, offset, value);
    }

    public static void setLongBE(byte[] array, int offset, long value) {
        LONG_BE.set(array, offset, value);
    }

    private ByteArray() {
    }
}

