/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.hardware.CentralProcessor;
import org.jackhuang.hmcl.util.platform.hardware.GraphicsCard;
import org.jackhuang.hmcl.util.platform.hardware.HardwareDetector;
import org.jackhuang.hmcl.util.platform.linux.LinuxCPUDetector;
import org.jackhuang.hmcl.util.platform.linux.LinuxGPUDetector;
import org.jetbrains.annotations.Nullable;

public final class LinuxHardwareDetector
extends HardwareDetector {
    private static final Path MEMINFO = Paths.get("/proc/meminfo", new String[0]);
    private static final Pattern MEMINFO_PATTERN = Pattern.compile("^.+:\\s*(?<value>\\d+)\\s*kB?$");

    @Override
    @Nullable
    public CentralProcessor detectCentralProcessor() {
        if (OperatingSystem.CURRENT_OS != OperatingSystem.LINUX) {
            return null;
        }
        CentralProcessor cpu = LinuxCPUDetector.detect();
        return cpu != null ? cpu : super.detectCentralProcessor();
    }

    @Override
    public List<GraphicsCard> detectGraphicsCards() {
        List<GraphicsCard> fastfetchResults;
        if (OperatingSystem.CURRENT_OS != OperatingSystem.LINUX) {
            return null;
        }
        List<GraphicsCard> cards = LinuxGPUDetector.detect();
        if ((cards == null || cards.isEmpty()) && (fastfetchResults = super.detectGraphicsCards()) != null) {
            cards = fastfetchResults;
        }
        return cards;
    }

    private static long parseMemoryInfoLine(String line) throws IOException {
        Matcher matcher = MEMINFO_PATTERN.matcher(line);
        if (!matcher.matches()) {
            throw new IOException("Unable to parse line in /proc/meminfo: " + line);
        }
        return Long.parseLong(matcher.group("value")) * 1024L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getTotalMemorySize() {
        try (BufferedReader reader = Files.newBufferedReader(MEMINFO);){
            String line;
            do {
                if ((line = reader.readLine()) == null) return super.getTotalMemorySize();
            } while (!line.startsWith("MemTotal:"));
            long total = LinuxHardwareDetector.parseMemoryInfoLine(line);
            if (total <= 0L) {
                throw new IOException("Invalid total memory size: " + line + " kB");
            }
            long l = total;
            return l;
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to parse /proc/meminfo", e);
        }
        return super.getTotalMemorySize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getFreeMemorySize() {
        try (BufferedReader reader = Files.newBufferedReader(MEMINFO);){
            String line;
            long free = -1L;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("MemAvailable:")) {
                    long available = LinuxHardwareDetector.parseMemoryInfoLine(line);
                    if (available < 0L) {
                        throw new IOException("Invalid available memory size: " + line + " kB");
                    }
                    long l = available;
                    return l;
                }
                if (!line.startsWith("MemFree:")) continue;
                free = LinuxHardwareDetector.parseMemoryInfoLine(line);
            }
            if (free < 0L) return super.getFreeMemorySize();
            long l = free;
            return l;
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to parse /proc/meminfo", e);
        }
        return super.getFreeMemorySize();
    }
}

