/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsConstraintCreator;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsConstraintsSolver;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsTCModel;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsUpdate;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class Java50FixCore
extends CompilationUnitRewriteOperationsFixCore {
    private static final String OVERRIDE = "Override";
    private static final String DEPRECATED = "Deprecated";

    public static Java50FixCore createAddOverrideAnnotationFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        if (!Java50FixCore.isMissingOverrideAnnotationProblem(problem.getProblemId())) {
            return null;
        }
        return Java50FixCore.createFix(compilationUnit, problem, OVERRIDE, FixMessages.Java50Fix_AddOverride_description);
    }

    public static boolean isMissingOverrideAnnotationInterfaceProblem(int id) {
        return id == 67109500;
    }

    public static boolean isMissingOverrideAnnotationProblem(int id) {
        return id == 67109491 || id == 67109500;
    }

    public static Java50FixCore createAddDeprectatedAnnotation(CompilationUnit compilationUnit, IProblemLocation problem) {
        if (!Java50FixCore.isMissingDeprecationProblem(problem.getProblemId())) {
            return null;
        }
        return Java50FixCore.createFix(compilationUnit, problem, DEPRECATED, FixMessages.Java50Fix_AddDeprecated_description);
    }

    public static boolean isMissingDeprecationProblem(int id) {
        return switch (id) {
            case 16778649, 536871540, 536871541, 536871542 -> true;
            default -> false;
        };
    }

    private static Java50FixCore createFix(CompilationUnit compilationUnit, IProblemLocation problem, String annotation, String label) {
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        if (selectedNode == null) {
            return null;
        }
        ASTNode declaringNode = Java50FixCore.getDeclaringNode(selectedNode);
        if (!(declaringNode instanceof BodyDeclaration)) {
            return null;
        }
        BodyDeclaration declaration = (BodyDeclaration)declaringNode;
        AnnotationRewriteOperation operation = new AnnotationRewriteOperation(declaration, annotation);
        return new Java50FixCore(label, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{operation});
    }

    public static Java50FixCore createRawTypeReferenceFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        SimpleType node = Java50FixCore.createRawTypeReferenceOperations(compilationUnit, new IProblemLocation[]{problem}, operations);
        if (operations.isEmpty()) {
            return null;
        }
        return new Java50FixCore(Messages.format(FixMessages.Java50Fix_AddTypeArguments_description, BasicElementLabels.getJavaElementName(node.getName().getFullyQualifiedName())), compilationUnit, operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[operations.size()]));
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean addOverrideAnnotation, boolean addOverrideInterfaceAnnotation, boolean addDeprecatedAnnotation, boolean rawTypeReference) {
        if (!(addOverrideAnnotation || addDeprecatedAnnotation || rawTypeReference)) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        IProblem[] problems = compilationUnit.getProblems();
        IProblemLocation[] locations = new IProblemLocation[problems.length];
        int i = 0;
        while (i < problems.length) {
            locations[i] = new ProblemLocation(problems[i]);
            ++i;
        }
        if (addOverrideAnnotation) {
            Java50FixCore.createAddOverrideAnnotationOperations(compilationUnit, addOverrideInterfaceAnnotation, locations, operations);
        }
        if (addDeprecatedAnnotation) {
            Java50FixCore.createAddDeprecatedAnnotationOperations(compilationUnit, locations, operations);
        }
        if (rawTypeReference) {
            Java50FixCore.createRawTypeReferenceOperations(compilationUnit, locations, operations);
        }
        if (operations.isEmpty()) {
            return null;
        }
        String fixName = rawTypeReference ? FixMessages.Java50Fix_add_type_parameters_change_name : FixMessages.Java50Fix_add_annotations_change_name;
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] operationsArray = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[operations.size()]);
        return new Java50FixCore(fixName, compilationUnit, operationsArray);
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] problems, boolean addOverrideAnnotation, boolean addOverrideInterfaceAnnotation, boolean addDeprecatedAnnotation, boolean rawTypeReferences) {
        if (!(addOverrideAnnotation || addDeprecatedAnnotation || rawTypeReferences)) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        if (addOverrideAnnotation) {
            Java50FixCore.createAddOverrideAnnotationOperations(compilationUnit, addOverrideInterfaceAnnotation, problems, operations);
        }
        if (addDeprecatedAnnotation) {
            Java50FixCore.createAddDeprecatedAnnotationOperations(compilationUnit, problems, operations);
        }
        if (rawTypeReferences) {
            Java50FixCore.createRawTypeReferenceOperations(compilationUnit, problems, operations);
        }
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] operationsArray = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[operations.size()]);
        return new Java50FixCore(FixMessages.Java50Fix_add_annotations_change_name, compilationUnit, operationsArray);
    }

    private static void createAddDeprecatedAnnotationOperations(CompilationUnit compilationUnit, IProblemLocation[] locations, List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> result) {
        IProblemLocation[] iProblemLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode declaringNode;
            ASTNode selectedNode;
            IProblemLocation problem = iProblemLocationArray[n2];
            if (Java50FixCore.isMissingDeprecationProblem(problem.getProblemId()) && (selectedNode = problem.getCoveringNode(compilationUnit)) != null && (declaringNode = Java50FixCore.getDeclaringNode(selectedNode)) instanceof BodyDeclaration) {
                BodyDeclaration declaration = (BodyDeclaration)declaringNode;
                AnnotationRewriteOperation operation = new AnnotationRewriteOperation(declaration, DEPRECATED);
                result.add(operation);
            }
            ++n2;
        }
    }

    private static void createAddOverrideAnnotationOperations(CompilationUnit compilationUnit, boolean addOverrideInterfaceAnnotation, IProblemLocation[] locations, List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> result) {
        IProblemLocation[] iProblemLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode declaringNode;
            ASTNode selectedNode;
            IProblemLocation problem = iProblemLocationArray[n2];
            int problemId = problem.getProblemId();
            if (Java50FixCore.isMissingOverrideAnnotationProblem(problemId) && (!Java50FixCore.isMissingOverrideAnnotationInterfaceProblem(problemId) || addOverrideInterfaceAnnotation) && (selectedNode = problem.getCoveringNode(compilationUnit)) != null && (declaringNode = Java50FixCore.getDeclaringNode(selectedNode)) instanceof BodyDeclaration) {
                BodyDeclaration declaration = (BodyDeclaration)declaringNode;
                AnnotationRewriteOperation operation = new AnnotationRewriteOperation(declaration, OVERRIDE);
                result.add(operation);
            }
            ++n2;
        }
    }

    private static SimpleType createRawTypeReferenceOperations(CompilationUnit compilationUnit, IProblemLocation[] locations, List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations) {
        if (Java50FixCore.hasFatalError(compilationUnit)) {
            return null;
        }
        ArrayList<SimpleType> result = new ArrayList<SimpleType>();
        IProblemLocation[] iProblemLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemLocation problem = iProblemLocationArray[n2];
            if (Java50FixCore.isRawTypeReferenceProblem(problem.getProblemId())) {
                MethodInvocation invocation;
                SimpleType rawReference;
                ASTNode node = problem.getCoveredNode(compilationUnit);
                if (node instanceof ClassInstanceCreation) {
                    rawReference = (Type)node.getStructuralProperty((StructuralPropertyDescriptor)ClassInstanceCreation.TYPE_PROPERTY);
                    if (!rawReference.isVar() && Java50FixCore.isRawTypeReference((ASTNode)rawReference)) {
                        result.add((SimpleType)rawReference);
                    }
                } else if (node instanceof SimpleName) {
                    ASTNode parent;
                    rawReference = node.getParent();
                    if (Java50FixCore.isRawTypeReference((ASTNode)rawReference) && !((parent = rawReference.getParent()) instanceof ArrayType) && !(parent instanceof ParameterizedType) && !((SimpleType)rawReference).isVar()) {
                        result.add((SimpleType)rawReference);
                    }
                } else if (node instanceof MethodInvocation && (rawReference = Java50FixCore.getRawReference(invocation = (MethodInvocation)node, compilationUnit)) != null && !rawReference.isVar()) {
                    result.add(rawReference);
                }
            }
            ++n2;
        }
        if (result.isEmpty()) {
            return null;
        }
        SimpleType[] types = result.toArray(new SimpleType[result.size()]);
        operations.add(new AddTypeParametersOperation(types));
        return types[0];
    }

    private static boolean hasFatalError(CompilationUnit compilationUnit) {
        try {
            if (!compilationUnit.getJavaElement().isStructureKnown()) {
                return true;
            }
        }
        catch (JavaModelException e) {
            JavaManipulationPlugin.log(e);
            return true;
        }
        IProblem[] iProblemArray = compilationUnit.getProblems();
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (problem.isError()) {
                if (!(problem instanceof CategorizedProblem)) {
                    return true;
                }
                CategorizedProblem categorizedProblem = (CategorizedProblem)problem;
                int categoryID = categorizedProblem.getCategoryID();
                switch (categoryID) {
                    case 10: 
                    case 20: 
                    case 30: 
                    case 40: 
                    case 50: 
                    case 60: 
                    case 160: {
                        return true;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    public static boolean isRawTypeReferenceProblem(int id) {
        switch (id) {
            case 16777747: 
            case 16777748: 
            case 16777788: 
            case 16777801: {
                return true;
            }
        }
        return false;
    }

    public static SimpleType getRawReference(MethodInvocation invocation, CompilationUnit compilationUnit) {
        SimpleType rawReference;
        SimpleType rawReference2;
        Name name1 = (Name)invocation.getStructuralProperty((StructuralPropertyDescriptor)MethodInvocation.NAME_PROPERTY);
        if (name1 instanceof SimpleName && (rawReference2 = Java50FixCore.getRawReference((SimpleName)name1, compilationUnit)) != null) {
            return rawReference2;
        }
        Expression expr = (Expression)invocation.getStructuralProperty((StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY);
        if (expr instanceof SimpleName) {
            SimpleType rawReference3 = Java50FixCore.getRawReference((SimpleName)expr, compilationUnit);
            if (rawReference3 != null) {
                return rawReference3;
            }
        } else if (expr instanceof QualifiedName) {
            SimpleType rawReference4;
            Name name = (Name)expr;
            while (name instanceof QualifiedName) {
                SimpleName simpleName = (SimpleName)name.getStructuralProperty((StructuralPropertyDescriptor)QualifiedName.NAME_PROPERTY);
                SimpleType rawReference5 = Java50FixCore.getRawReference(simpleName, compilationUnit);
                if (rawReference5 != null) {
                    return rawReference5;
                }
                name = (Name)name.getStructuralProperty((StructuralPropertyDescriptor)QualifiedName.QUALIFIER_PROPERTY);
            }
            if (name instanceof SimpleName && (rawReference4 = Java50FixCore.getRawReference((SimpleName)name, compilationUnit)) != null) {
                return rawReference4;
            }
        } else if (expr instanceof MethodInvocation && (rawReference = Java50FixCore.getRawReference((MethodInvocation)expr, compilationUnit)) != null) {
            return rawReference;
        }
        return null;
    }

    public static SimpleType getRawReference(SimpleName name, CompilationUnit compilationUnit) {
        SimpleName[] simpleNameArray = LinkedNodeFinder.findByNode((ASTNode)compilationUnit, name);
        int n = simpleNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDecl;
            SingleVariableDeclaration declaration;
            ASTNode result;
            SimpleName n3 = simpleNameArray[n2];
            if (n3.getParent() instanceof VariableDeclarationFragment) {
                FieldDeclaration declaration2;
                VariableDeclarationStatement statement;
                ASTNode result2;
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)n3.getParent();
                if (fragment.getParent() instanceof VariableDeclarationStatement ? Java50FixCore.isRawTypeReference(result2 = (ASTNode)(statement = (VariableDeclarationStatement)fragment.getParent()).getStructuralProperty((StructuralPropertyDescriptor)VariableDeclarationStatement.TYPE_PROPERTY)) : fragment.getParent() instanceof FieldDeclaration && Java50FixCore.isRawTypeReference(result2 = (ASTNode)(declaration2 = (FieldDeclaration)fragment.getParent()).getStructuralProperty((StructuralPropertyDescriptor)FieldDeclaration.TYPE_PROPERTY))) {
                    return (SimpleType)result2;
                }
            } else if (n3.getParent() instanceof SingleVariableDeclaration ? Java50FixCore.isRawTypeReference(result = (ASTNode)(declaration = (SingleVariableDeclaration)n3.getParent()).getStructuralProperty((StructuralPropertyDescriptor)SingleVariableDeclaration.TYPE_PROPERTY)) : n3.getParent() instanceof MethodDeclaration && Java50FixCore.isRawTypeReference(result = (ASTNode)(methodDecl = (MethodDeclaration)n3.getParent()).getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY))) {
                return (SimpleType)result;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isRawTypeReference(ASTNode node) {
        if (!(node instanceof SimpleType)) {
            return false;
        }
        ITypeBinding typeBinding = ((SimpleType)node).resolveBinding();
        if (typeBinding == null) {
            return false;
        }
        ITypeBinding binding = typeBinding.getTypeDeclaration();
        if (binding == null) {
            return false;
        }
        ITypeBinding[] parameters = binding.getTypeParameters();
        return parameters.length != 0;
    }

    private static ASTNode getDeclaringNode(ASTNode selectedNode) {
        ASTNode declaringNode = null;
        if (selectedNode instanceof MethodDeclaration) {
            declaringNode = selectedNode;
        } else if (selectedNode instanceof SimpleName) {
            StructuralPropertyDescriptor locationInParent = selectedNode.getLocationInParent();
            if (locationInParent == MethodDeclaration.NAME_PROPERTY || locationInParent == TypeDeclaration.NAME_PROPERTY || locationInParent == EnumConstantDeclaration.NAME_PROPERTY) {
                declaringNode = selectedNode.getParent();
            } else if (locationInParent == VariableDeclarationFragment.NAME_PROPERTY) {
                declaringNode = selectedNode.getParent().getParent();
            }
        }
        return declaringNode;
    }

    private Java50FixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewrites) {
        super(name, compilationUnit, fixRewrites);
    }

    private static class AddTypeParametersOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final SimpleType[] fTypes;

        public AddTypeParametersOperation(SimpleType[] types) {
            this.fTypes = types;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore positionGroups) throws CoreException {
            InferTypeArgumentsTCModel model = new InferTypeArgumentsTCModel();
            InferTypeArgumentsConstraintCreator creator = new InferTypeArgumentsConstraintCreator(model, true);
            CompilationUnit root = cuRewrite.getRoot();
            root.accept((ASTVisitor)creator);
            InferTypeArgumentsConstraintsSolver solver = new InferTypeArgumentsConstraintsSolver(model);
            InferTypeArgumentsUpdate update = solver.solveConstraints((IProgressMonitor)new NullProgressMonitor());
            solver = null;
            ParameterizedType[] nodes = InferTypeArgumentsRefactoring.inferArguments(this.fTypes, update, model, cuRewrite);
            if (nodes.length == 0) {
                return;
            }
            ASTRewrite astRewrite = cuRewrite.getASTRewrite();
            int i = 0;
            while (i < nodes.length) {
                ParameterizedType type = nodes[i];
                List args = type.typeArguments();
                int j = 0;
                for (Type argType : args) {
                    LinkedProposalPositionGroupCore group = new LinkedProposalPositionGroupCore("G" + i + "_" + j);
                    if (!positionGroups.hasLinkedPositions()) {
                        group.addPosition(astRewrite.track((ASTNode)argType), true);
                    } else {
                        group.addPosition(astRewrite.track((ASTNode)argType), false);
                    }
                    positionGroups.addPositionGroup(group);
                    ++j;
                }
                ++i;
            }
            positionGroups.setEndPosition(astRewrite.track((ASTNode)nodes[0]));
        }
    }

    private static class AnnotationRewriteOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final BodyDeclaration fBodyDeclaration;
        private final String fAnnotation;

        public AnnotationRewriteOperation(BodyDeclaration bodyDeclaration, String annotation) {
            this.fBodyDeclaration = bodyDeclaration;
            this.fAnnotation = annotation;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            AST ast = cuRewrite.getRoot().getAST();
            ListRewrite listRewrite = cuRewrite.getASTRewrite().getListRewrite((ASTNode)this.fBodyDeclaration, this.fBodyDeclaration.getModifiersProperty());
            MarkerAnnotation newAnnotation = ast.newMarkerAnnotation();
            newAnnotation.setTypeName((Name)ast.newSimpleName(this.fAnnotation));
            TextEditGroup group = this.createTextEditGroup(Messages.format(FixMessages.Java50Fix_AddMissingAnnotation_description, BasicElementLabels.getJavaElementName(this.fAnnotation)), cuRewrite);
            listRewrite.insertFirst((ASTNode)newAnnotation, group);
        }
    }
}

