#! format: off
#! source: https://github.com/alexeyovchinnikov/SIAN-Julia

import AbstractAlgebra

function Goodwin(; np=AbstractAlgebra, internal_ordering=:degrevlex, k=np.QQ)
    R, (x1_9,x1_8,x4_8,x1_7,x2_7,x3_7,x4_7,x1_6,x2_6,x3_6,x4_6,x1_5,x2_5,x3_5,x4_5,x1_4,x2_4,x3_4,x4_4,x1_3,x2_3,x3_3,x4_3,x1_2,x2_2,x3_2,x4_2,x1_1,x2_1,x3_1,x4_1,x1_0,x2_0,x3_0,x4_0,z_aux,b_0,c_0,alpha_0,beta_0,gama_0,delta_0,sigma_0) = np.polynomial_ring(k, [:x1_9,:x1_8,:x4_8,:x1_7,:x2_7,:x3_7,:x4_7,:x1_6,:x2_6,:x3_6,:x4_6,:x1_5,:x2_5,:x3_5,:x4_5,:x1_4,:x2_4,:x3_4,:x4_4,:x1_3,:x2_3,:x3_3,:x4_3,:x1_2,:x2_2,:x3_2,:x4_2,:x1_1,:x2_1,:x3_1,:x4_1,:x1_0,:x2_0,:x3_0,:x4_0,:z_aux,:b_0,:c_0,:alpha_0,:beta_0,:gama_0,:delta_0,:sigma_0], internal_ordering=internal_ordering)
    sys = [
    		-x1_0 + 75630587615098605042,
		x1_0*x4_0*b_0 + x1_0*b_0*c_0 + x1_1*x4_0 + x1_1*c_0 - 1,
		-x1_1 - k(288099247257192374562847917412771200155514126792036525259607)//k(50285678141080776564),
		x4_1*x1_0*b_0 + x1_1*x4_0*b_0 + x1_1*b_0*c_0 + x1_1*x4_1 + x1_2*x4_0 + x1_2*c_0,
		-x2_0*x4_0*gama_0*sigma_0 + x3_0*x4_0*delta_0*sigma_0 + x4_1*x3_0,
		-x1_2 + k(413837326337881638003264654817027959009137056616324103666245308633046689517577678174697896735830824360632490934620099)//k(953523738978108229442757555461519040389631834088987613712),
		2*x1_1*x4_1*b_0 + x4_2*x1_0*b_0 + x1_2*x4_0*b_0 + x1_2*b_0*c_0 + x4_2*x1_1 + 2*x1_2*x4_1 + x1_3*x4_0 + x1_3*c_0,
		-x4_1*x2_0*gama_0*sigma_0 - x2_1*x4_0*gama_0*sigma_0 + x4_1*x3_0*delta_0*sigma_0 + x3_1*x4_0*delta_0*sigma_0 + x3_1*x4_1 + x4_2*x3_0,
		-x1_0*alpha_0 + x2_0*beta_0 + x2_1,
		-x2_0*gama_0 + x3_0*delta_0 + x3_1,
		-x1_3 - k(2675036482581259782695456087079082898751862788147051343660812954844171250149402103895130362967559844301724612132058050199699072157410872764378275087582655440439657916580071443)//k(81363799690593683428506412417910208505167266957532140203869065744776334071031676261578991356832),
		3*x4_2*x1_1*b_0 + 3*x1_2*x4_1*b_0 + x4_3*x1_0*b_0 + x1_3*x4_0*b_0 + x1_3*b_0*c_0 + 3*x1_2*x4_2 + x4_3*x1_1 + 3*x1_3*x4_1 + x1_4*x4_0 + x1_4*c_0,
		-2*x2_1*x4_1*gama_0*sigma_0 - x4_2*x2_0*gama_0*sigma_0 - x2_2*x4_0*gama_0*sigma_0 + 2*x3_1*x4_1*delta_0*sigma_0 + x4_2*x3_0*delta_0*sigma_0 + x3_2*x4_0*delta_0*sigma_0 + 2*x4_2*x3_1 + x3_2*x4_1 + x4_3*x3_0,
		-x1_1*alpha_0 + x2_1*beta_0 + x2_2,
		-x2_1*gama_0 + x3_1*delta_0 + x3_2,
		-x1_4 + k(22682692430887346721972509403724857287499604754290612906675280012754754824755629572292373574418691427746773097018487851057352080773337363549433625910749836520755551732115577747446272854611159748286377504144598736272306161816651252327)//k(4628493680493494008145439643688995407045748025279332632744470260867230621112476975689752799887388207243718851669962465138736428560768),
		6*x1_2*x4_2*b_0 + 4*x4_3*x1_1*b_0 + 4*x1_3*x4_1*b_0 + x4_4*x1_0*b_0 + x1_4*x4_0*b_0 + x1_4*b_0*c_0 + 4*x4_3*x1_2 + 6*x1_3*x4_2 + x4_4*x1_1 + 4*x1_4*x4_1 + x1_5*x4_0 + x1_5*c_0,
		-3*x4_2*x2_1*gama_0*sigma_0 - 3*x2_2*x4_1*gama_0*sigma_0 - x4_3*x2_0*gama_0*sigma_0 - x2_3*x4_0*gama_0*sigma_0 + 3*x4_2*x3_1*delta_0*sigma_0 + 3*x3_2*x4_1*delta_0*sigma_0 + x4_3*x3_0*delta_0*sigma_0 + x3_3*x4_0*delta_0*sigma_0 + 3*x3_2*x4_2 + 3*x4_3*x3_1 + x3_3*x4_1 + x4_4*x3_0,
		-x2_2*gama_0 + x3_2*delta_0 + x3_3,
		-x1_2*alpha_0 + x2_2*beta_0 + x2_3,
		-x1_5 + k(6557648442454974639469518281774336913258131465231686993185891683250062824647588226766398204489221939005085316672116066556055354827473403249835209434246334781666031956752560046570253899311914866116880037142757957425962719364766375514109504511393184843780057410249466282395518443638500370570019004791798474937629)//k(98736879139591475666098984766578479201344566358742566610830218498602212904171748047454851831531736297383530831448796726693492368521384190047294934218265875798696993138112),
		10*x4_3*x1_2*b_0 + 10*x1_3*x4_2*b_0 + 5*x4_4*x1_1*b_0 + 5*x1_4*x4_1*b_0 + x4_5*x1_0*b_0 + x1_5*x4_0*b_0 + x1_5*b_0*c_0 + 10*x1_3*x4_3 + 5*x4_4*x1_2 + 10*x1_4*x4_2 + x4_5*x1_1 + 5*x1_5*x4_1 + x1_6*x4_0 + x1_6*c_0,
		-6*x2_2*x4_2*gama_0*sigma_0 - 4*x4_3*x2_1*gama_0*sigma_0 - 4*x2_3*x4_1*gama_0*sigma_0 - x4_4*x2_0*gama_0*sigma_0 - x2_4*x4_0*gama_0*sigma_0 + 6*x3_2*x4_2*delta_0*sigma_0 + 4*x4_3*x3_1*delta_0*sigma_0 + 4*x3_3*x4_1*delta_0*sigma_0 + x4_4*x3_0*delta_0*sigma_0 + x3_4*x4_0*delta_0*sigma_0 + 6*x4_3*x3_2 + 4*x3_3*x4_2 + 4*x4_4*x3_1 + x3_4*x4_1 + x4_5*x3_0,
		-x2_3*gama_0 + x3_3*delta_0 + x3_4,
		-x1_3*alpha_0 + x2_3*beta_0 + x2_4,
		-x1_6 + k(735521844056031912771256157950657036897338322015343727950355160055704920490283805835839757448686267815958911023314307108170013368894267770378213400036724023114070811828164136033335511154618625524957172055280282140540343606566412447845522726632881709845750816908855012536211213669439880884566687688565748164912130997591166192988749767631272370795522005445438903652360192269437337174442695)//k(33700713796586540555832537808129632473744298065613085052165092016855309920726342646938940323346199915598876437633632233992400337949875718587396725929302019061596766469086380153543594083711781064056189482300928),
		20*x1_3*x4_3*b_0 + 15*x4_4*x1_2*b_0 + 15*x1_4*x4_2*b_0 + 6*x4_5*x1_1*b_0 + 6*x1_5*x4_1*b_0 + x4_6*x1_0*b_0 + x1_6*x4_0*b_0 + x1_6*b_0*c_0 + 15*x4_4*x1_3 + 20*x1_4*x4_3 + 6*x4_5*x1_2 + 15*x1_5*x4_2 + x4_6*x1_1 + 6*x1_6*x4_1 + x1_7*x4_0 + x1_7*c_0,
		-10*x4_3*x2_2*gama_0*sigma_0 - 10*x2_3*x4_2*gama_0*sigma_0 - 5*x4_4*x2_1*gama_0*sigma_0 - 5*x2_4*x4_1*gama_0*sigma_0 - x4_5*x2_0*gama_0*sigma_0 - x2_5*x4_0*gama_0*sigma_0 + 10*x4_3*x3_2*delta_0*sigma_0 + 10*x3_3*x4_2*delta_0*sigma_0 + 5*x4_4*x3_1*delta_0*sigma_0 + 5*x3_4*x4_1*delta_0*sigma_0 + x4_5*x3_0*delta_0*sigma_0 + x3_5*x4_0*delta_0*sigma_0 + 10*x3_3*x4_3 + 10*x4_4*x3_2 + 5*x3_4*x4_2 + 5*x4_5*x3_1 + x3_5*x4_1 + x4_6*x3_0,
		-x1_4*alpha_0 + x2_4*beta_0 + x2_5,
		-x2_4*gama_0 + x3_4*delta_0 + x3_5,
		-x1_7 - k(24107327302636060463195200400197901570994657715725291146062387048786241748667730902319868966518094257917594680014228877165373124480102269964961406744449525285373634054428181968880355513671403237990936896722119935536271666923856572294265613716449575189256457369686550088403416054484657216385231086876209567929265163795278391255859284828589174108551162040058399057262379401992418743383088774720085068338765257185861919716914644721576882521690499233232296108217344554899)//k(958556147996943129634811099325496730154836279699558020824243343067585505354236035047886769691532082055885593792014247758963210651256500770467900192124704505525390963464487507873797262429435113464700724042440979884882188321038869510308135847924736),
		35*x4_4*x1_3*b_0 + 35*x1_4*x4_3*b_0 + 21*x4_5*x1_2*b_0 + 21*x1_5*x4_2*b_0 + 7*x4_6*x1_1*b_0 + 7*x1_6*x4_1*b_0 + x4_7*x1_0*b_0 + x1_7*x4_0*b_0 + x1_7*b_0*c_0 + 35*x1_4*x4_4 + 21*x4_5*x1_3 + 35*x1_5*x4_3 + 7*x4_6*x1_2 + 21*x1_6*x4_2 + x4_7*x1_1 + 7*x1_7*x4_1 + x1_8*x4_0 + x1_8*c_0,
		-20*x2_3*x4_3*gama_0*sigma_0 - 15*x4_4*x2_2*gama_0*sigma_0 - 15*x2_4*x4_2*gama_0*sigma_0 - 6*x4_5*x2_1*gama_0*sigma_0 - 6*x2_5*x4_1*gama_0*sigma_0 - x4_6*x2_0*gama_0*sigma_0 - x2_6*x4_0*gama_0*sigma_0 + 20*x3_3*x4_3*delta_0*sigma_0 + 15*x4_4*x3_2*delta_0*sigma_0 + 15*x3_4*x4_2*delta_0*sigma_0 + 6*x4_5*x3_1*delta_0*sigma_0 + 6*x3_5*x4_1*delta_0*sigma_0 + x4_6*x3_0*delta_0*sigma_0 + x3_6*x4_0*delta_0*sigma_0 + 20*x4_4*x3_3 + 15*x3_4*x4_3 + 15*x4_5*x3_2 + 6*x3_5*x4_2 + 6*x4_6*x3_1 + x3_6*x4_1 + x4_7*x3_0,
		-x2_5*gama_0 + x3_5*delta_0 + x3_6,
		-x1_5*alpha_0 + x2_5*beta_0 + x2_6,
		-x1_8 - k(55978883354920010450143139893661322985778047600463440608341440805042446465158455483200854979025509696804038797535208416456170257325515718727462137129957267277467026731851925571947390357598271971545314897555537597657597052602121369618974611585801925137732713251218498029671348272159437948704136199370666921724523299058126696253750103715865877277495853051277541799547172622772502535566870842438446737772950934516279629308507388565901369363674757480128121367825106465884550285818046023439957742805146200379013443857354290339874172886822463760520843)//k(163586426283197030477964221023920485191428647277976825386100565871713269366549542987714550644008795274493389723106173042445172286973503258277263968008343463987682459564014370618374831839703881773344201896085186709247851511278585562026580143329823339995763442690925124641448717891080192),
		70*x1_4*x4_4*b_0 + 56*x4_5*x1_3*b_0 + 56*x1_5*x4_3*b_0 + 28*x4_6*x1_2*b_0 + 28*x1_6*x4_2*b_0 + 8*x4_7*x1_1*b_0 + 8*x1_7*x4_1*b_0 + x4_8*x1_0*b_0 + x1_8*x4_0*b_0 + x1_8*b_0*c_0 + 56*x4_5*x1_4 + 70*x1_5*x4_4 + 28*x4_6*x1_3 + 56*x1_6*x4_3 + 8*x4_7*x1_2 + 28*x1_7*x4_2 + x4_8*x1_1 + 8*x1_8*x4_1 + x1_9*x4_0 + x1_9*c_0,
		-35*x4_4*x2_3*gama_0*sigma_0 - 35*x2_4*x4_3*gama_0*sigma_0 - 21*x4_5*x2_2*gama_0*sigma_0 - 21*x2_5*x4_2*gama_0*sigma_0 - 7*x4_6*x2_1*gama_0*sigma_0 - 7*x2_6*x4_1*gama_0*sigma_0 - x4_7*x2_0*gama_0*sigma_0 - x2_7*x4_0*gama_0*sigma_0 + 35*x4_4*x3_3*delta_0*sigma_0 + 35*x3_4*x4_3*delta_0*sigma_0 + 21*x4_5*x3_2*delta_0*sigma_0 + 21*x3_5*x4_2*delta_0*sigma_0 + 7*x4_6*x3_1*delta_0*sigma_0 + 7*x3_6*x4_1*delta_0*sigma_0 + x4_7*x3_0*delta_0*sigma_0 + x3_7*x4_0*delta_0*sigma_0 + 35*x3_4*x4_4 + 35*x4_5*x3_3 + 21*x3_5*x4_3 + 21*x4_6*x3_2 + 7*x3_6*x4_2 + 7*x4_7*x3_1 + x3_7*x4_1 + x4_8*x3_0,
		-x2_6*gama_0 + x3_6*delta_0 + x3_7,
		-x1_6*alpha_0 + x2_6*beta_0 + x2_7,
		-x1_9 + k(89795140076354516948032733209528825463451309840039065556850493110303140095995455652066201535281527879585958567001581956512615855639783507962995965976811038237288326711166055517127940514808380398005660859812733555455378164012701004653121380748111501766144246280995075575291021081948539641112331991095247294101370591995728360419561667954933691960667961487261942762924027817666546976526132558907819851330130000980401429662696894826246192342170877575037148930398613755283402812546545363198009810880410865688160535736416907233313681948015263878077530289125869806254371911877083964317425744714071776199710464123908271772187074147)//k(6979382198953147939658372183783704831079770970521859071929693064017526858161595253742283788793790462274828105644048032785365627792344536788818319328188923914437757579126265909241891354702503385099415044107996307269458566919654932640221523602475740674157677043298456123044537890480111208528339330845896647368061346386989056),
		x3_0*x4_0*z_aux + x3_0*z_aux*c_0 - 1
    ]
end
