#! format: off
#! source: https://github.com/alexeyovchinnikov/SIAN-Julia

import AbstractAlgebra

function DAISY_mamil4_with_weights(; np=AbstractAlgebra, internal_ordering=:degrevlex, k=np.QQ)
    R, (x1_11,x2_10,x3_10,x4_10,x1_10,x2_9,x3_9,x4_9,x1_9,x2_8,x3_8,x4_8,x1_8,x2_7,x3_7,x4_7,x1_7,x2_6,x3_6,x4_6,x1_6,x2_5,x3_5,x4_5,x1_5,x2_4,x3_4,x4_4,x1_4,x2_3,x3_3,x4_3,x1_3,x2_2,x3_2,x4_2,x1_2,x2_1,x3_1,x4_1,x1_1,x2_0,x3_0,x4_0,x1_0,z_aux,k01_0,k12_0,k13_0,k14_0,k21_0,k31_0,k41_0) = np.polynomial_ring(k, [:x1_11,:x2_10,:x3_10,:x4_10,:x1_10,:x2_9,:x3_9,:x4_9,:x1_9,:x2_8,:x3_8,:x4_8,:x1_8,:x2_7,:x3_7,:x4_7,:x1_7,:x2_6,:x3_6,:x4_6,:x1_6,:x2_5,:x3_5,:x4_5,:x1_5,:x2_4,:x3_4,:x4_4,:x1_4,:x2_3,:x3_3,:x4_3,:x1_3,:x2_2,:x3_2,:x4_2,:x1_2,:x2_1,:x3_1,:x4_1,:x1_1,:x2_0,:x3_0,:x4_0,:x1_0,:z_aux,:k01_0,:k12_0,:k13_0,:k14_0,:k21_0,:k31_0,:k41_0], internal_ordering=internal_ordering)
    sys = [
    		-x1_0 + 325033256191231543,
		-x2_0^2*k12_0^2 - x3_0^2*k13_0^2 - x4_0^2*k14_0^2 + x1_0*k01_0^2 + x1_0*k21_0^2 + x1_0*k31_0^2 + x1_0*k41_0^2 + x1_1 - 640874352163439719,
		-x1_1 + 301636320796121316952383207998466048,
		-x2_1^2*k12_0^2 - x3_1^2*k13_0^2 - x4_1^2*k14_0^2 + x1_1*k01_0^2 + x1_1*k21_0^2 + x1_1*k31_0^2 + x1_1*k41_0^2 + x1_2 - 633484278360801773,
		x4_0^2*k14_0^2 - x1_0*k41_0^2 + x4_1^2,
		x2_0^2*k12_0^2 - x1_0*k21_0^2 + x2_1^2,
		x3_0^2*k13_0^2 - x1_0*k31_0^2 + x3_1^2,
		-x1_2 - 521266663962964447386108526269031619429996282963228199,
		-x2_2^2*k12_0^2 - x3_2^2*k13_0^2 - x4_2^2*k14_0^2 + x1_2*k01_0^2 + x1_2*k21_0^2 + x1_2*k31_0^2 + x1_2*k41_0^2 + x1_3 - 80589921337947321,
		x4_1^2*k14_0^2 - x1_1*k41_0^2 + x4_2^2,
		x2_1^2*k12_0^2 - x1_1*k21_0^2 + x2_2^2,
		x3_1^2*k13_0^2 - x1_1*k31_0^2 + x3_2^2,
		-x1_3 + 710965021475563032937645858068785572431803052040215029457156899508820645,
		-x2_3^2*k12_0^2 - x3_3^2*k13_0^2 - x4_3^2*k14_0^2 + x1_3*k01_0^2 + x1_3*k21_0^2 + x1_3*k31_0^2 + x1_3*k41_0^2 + x1_4 - 553121329388854645,
		x3_2^2*k13_0^2 - x1_2*k31_0^2 + x3_3^2,
		x2_2^2*k12_0^2 - x1_2*k21_0^2 + x2_3^2,
		x4_2^2*k14_0^2 - x1_2*k41_0^2 + x4_3^2,
		-x1_4 - 947018406197431963241565045187291940681107913412615587740340364418146934204211684679184706,
		-x2_4^2*k12_0^2 - x3_4^2*k13_0^2 - x4_4^2*k14_0^2 + x1_4*k01_0^2 + x1_4*k21_0^2 + x1_4*k31_0^2 + x1_4*k41_0^2 + x1_5 - 538925133497019568,
		x4_3^2*k14_0^2 - x1_3*k41_0^2 + x4_4^2,
		x2_3^2*k12_0^2 - x1_3*k21_0^2 + x2_4^2,
		x3_3^2*k13_0^2 - x1_3*k31_0^2 + x3_4^2,
		-x1_5 + 1259127987190474592949053801496675647471248695733267760712830872205222274079842605968850560395390274529197790,
		-x2_5^2*k12_0^2 - x3_5^2*k13_0^2 - x4_5^2*k14_0^2 + x1_5*k01_0^2 + x1_5*k21_0^2 + x1_5*k31_0^2 + x1_5*k41_0^2 + x1_6 - 312435982471478365,
		x4_4^2*k14_0^2 - x1_4*k41_0^2 + x4_5^2,
		x3_4^2*k13_0^2 - x1_4*k31_0^2 + x3_5^2,
		x2_4^2*k12_0^2 - x1_4*k21_0^2 + x2_5^2,
		-x1_6 - 1674678646838250518058801921189903797746258975766148266993357462762221657614971768401703578856055793519934109133988152840270381,
		-x2_6^2*k12_0^2 - x3_6^2*k13_0^2 - x4_6^2*k14_0^2 + x1_6*k01_0^2 + x1_6*k21_0^2 + x1_6*k31_0^2 + x1_6*k41_0^2 + x1_7 - 438882059125485049,
		x3_5^2*k13_0^2 - x1_5*k31_0^2 + x3_6^2,
		x2_5^2*k12_0^2 - x1_5*k21_0^2 + x2_6^2,
		x4_5^2*k14_0^2 - x1_5*k41_0^2 + x4_6^2,
		-x1_7 + 2228100345258080161074691010025806771042512700020159206150364174948388021390422631451285385645014857258529845448837535859615385764571043574965477,
		-x2_7^2*k12_0^2 - x3_7^2*k13_0^2 - x4_7^2*k14_0^2 + x1_7*k01_0^2 + x1_7*k21_0^2 + x1_7*k31_0^2 + x1_7*k41_0^2 + x1_8 - 554365525565873907,
		x4_6^2*k14_0^2 - x1_6*k41_0^2 + x4_7^2,
		x3_6^2*k13_0^2 - x1_6*k31_0^2 + x3_7^2,
		x2_6^2*k12_0^2 - x1_6*k21_0^2 + x2_7^2,
		-x1_8 - 2964923516299085027636979951586857104742630162187395843733722733447013665792895249302474370487923795687925708651133847703070066044291841437590502883752725566261050,
		-x2_8^2*k12_0^2 - x3_8^2*k13_0^2 - x4_8^2*k14_0^2 + x1_8*k01_0^2 + x1_8*k21_0^2 + x1_8*k31_0^2 + x1_8*k41_0^2 + x1_9 - 503876985722195294,
		x2_7^2*k12_0^2 - x1_7*k21_0^2 + x2_8^2,
		x4_7^2*k14_0^2 - x1_7*k41_0^2 + x4_8^2,
		x3_7^2*k13_0^2 - x1_7*k31_0^2 + x3_8^2,
		-x1_9 + 3945736846535871558920148409157366737388231469017997904251024324646037016837836275757357203579513289179238770452062029878679758849153780699662719908478191905483819682665724227589322,
		-x2_9^2*k12_0^2 - x3_9^2*k13_0^2 - x4_9^2*k14_0^2 + x1_9*k01_0^2 + x1_9*k21_0^2 + x1_9*k31_0^2 + x1_9*k41_0^2 + x1_10 - 226283459233525229,
		x2_8^2*k12_0^2 - x1_8*k21_0^2 + x2_9^2,
		x4_8^2*k14_0^2 - x1_8*k41_0^2 + x4_9^2,
		x3_8^2*k13_0^2 - x1_8*k31_0^2 + x3_9^2,
		-x1_10 - 5251206644228342065368216985950702620489975878802010669387932374634556359512302205629165954379366469569341329554824272989707956080540086361101284225166983204757417447899360959494826235945025899924835,
		-x2_10^2*k12_0^2 - x3_10^2*k13_0^2 - x4_10^2*k14_0^2 + x1_10*k01_0^2 + x1_10*k21_0^2 + x1_10*k31_0^2 + x1_10*k41_0^2 + x1_11 - 372275514289023224,
		x3_9^2*k13_0^2 - x1_9*k31_0^2 + x3_10^2,
		x2_9^2*k12_0^2 - x1_9*k21_0^2 + x2_10^2,
		x4_9^2*k14_0^2 - x1_9*k41_0^2 + x4_10^2,
		-x1_11 + 6988716502426964061852542086682011659106208058752221061238238769806499283907950491645628897888639008604889201099213793390925560486511085334259897391148945172956617381909747995308230201909868776371037882712412991092410,
		z_aux - 1
    ]
end
