#! format: off
#! source: https://github.com/alexeyovchinnikov/SIAN-Julia

import AbstractAlgebra

function SEIR_with_weights(; np=AbstractAlgebra, internal_ordering=:degrevlex, k=np.QQ)
    R, (In_6,In_5,E_5,S_4,N_4,In_4,E_4,S_3,N_3,In_3,E_3,S_2,N_2,In_2,E_2,S_1,N_1,In_1,E_1,S_0,N_0,In_0,E_0,z_aux,b_0,nu_0,a_0) = np.polynomial_ring(k, [:In_6,:In_5,:E_5,:S_4,:N_4,:In_4,:E_4,:S_3,:N_3,:In_3,:E_3,:S_2,:N_2,:In_2,:E_2,:S_1,:N_1,:In_1,:E_1,:S_0,:N_0,:In_0,:E_0,:z_aux,:b_0,:nu_0,:a_0], internal_ordering=internal_ordering)
    sys = [
    		-In_0 + 50233694983,
		-E_0^2*nu_0 + In_0*a_0 + In_1,
		-N_0 + 31277148749,
		N_1,
		-In_1 + 11705182023199511903649,
		-E_1^2*nu_0 + In_1*a_0 + In_2,
		-S_0^3*In_0*b_0^3 + N_0*E_0^2*nu_0 + E_1^2*N_0,
		-In_2 - k(15298883402736045317110749781112694613096647)//k(4468164107),
		-E_2^2*nu_0 + In_2*a_0 + In_3,
		-In_1*S_0^3*b_0^3 - S_1^3*In_0*b_0^3 + E_1^2*N_0*nu_0 + N_1*E_0^2*nu_0 + N_1*E_1^2 + E_2^2*N_0,
		S_0^3*In_0*b_0^3 + S_1^3*N_0,
		-In_3 + k(119387138428185133521746325876169321504694441029700585746369171269)//k(139751433409581752143),
		-E_3^2*nu_0 + In_3*a_0 + In_4,
		-2*S_1^3*In_1*b_0^3 - In_2*S_0^3*b_0^3 - S_2^3*In_0*b_0^3 + 2*N_1*E_1^2*nu_0 + E_2^2*N_0*nu_0 + N_2*E_0^2*nu_0 + 2*E_2^2*N_1 + N_2*E_1^2 + E_3^2*N_0,
		In_1*S_0^3*b_0^3 + S_1^3*In_0*b_0^3 + S_1^3*N_1 + S_2^3*N_0,
		N_2,
		-In_4 - k(2051227436683969885446617795894684436002519552358992579851696769849468955296855470267245)//k(4371026370637456703652660519107),
		-E_4^2*nu_0 + In_4*a_0 + In_5,
		-3*In_2*S_1^3*b_0^3 - 3*S_2^3*In_1*b_0^3 - In_3*S_0^3*b_0^3 - S_3^3*In_0*b_0^3 + 3*E_2^2*N_1*nu_0 + 3*N_2*E_1^2*nu_0 + E_3^2*N_0*nu_0 + N_3*E_0^2*nu_0 + 3*N_2*E_2^2 + 3*E_3^2*N_1 + N_3*E_1^2 + E_4^2*N_0,
		N_3,
		2*S_1^3*In_1*b_0^3 + In_2*S_0^3*b_0^3 + S_2^3*In_0*b_0^3 + N_2*S_1^3 + 2*S_2^3*N_1 + S_3^3*N_0,
		-In_5 + k(38699653557403918060444939054765964558803829937128512169604816089430824866646080432215379750898433795170605761)//k(136713241980229339271191474685709195647143),
		-E_5^2*nu_0 + In_5*a_0 + In_6,
		-6*S_2^3*In_2*b_0^3 - 4*In_3*S_1^3*b_0^3 - 4*S_3^3*In_1*b_0^3 - In_4*S_0^3*b_0^3 - S_4^3*In_0*b_0^3 + 6*N_2*E_2^2*nu_0 + 4*E_3^2*N_1*nu_0 + 4*N_3*E_1^2*nu_0 + E_4^2*N_0*nu_0 + N_4*E_0^2*nu_0 + 6*E_3^2*N_2 + 4*N_3*E_2^2 + 4*E_4^2*N_1 + N_4*E_1^2 + E_5^2*N_0,
		3*In_2*S_1^3*b_0^3 + 3*S_2^3*In_1*b_0^3 + In_3*S_0^3*b_0^3 + S_3^3*In_0*b_0^3 + 3*S_2^3*N_2 + N_3*S_1^3 + 3*S_3^3*N_1 + S_4^3*N_0,
		N_4,
		-In_6 - k(399154494569543502009571034490916344153960747664580436349965284271448151591089675164855020343438216164787669325709857656644375809263)//k(4276000405373664361519043004205594536812834927874107),
		-N_1,
		-N_2,
		-N_3,
		-N_4,
		N_0*z_aux - 1
    ]
end
