/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.ec4j.core.Cache;
import org.ec4j.core.EditorConfigLoader;
import org.ec4j.core.Resource;
import org.ec4j.core.ResourcePath;
import org.ec4j.core.ResourceProperties;
import org.ec4j.core.model.Ec4jPath;
import org.ec4j.core.model.EditorConfig;
import org.ec4j.core.model.Property;
import org.ec4j.core.model.Section;

public class ResourcePropertiesService {
    private final Cache cache;
    private final String configFileName;
    private final List<EditorConfig> defaultEditorConfigs;
    private final boolean keepUnset;
    private final EditorConfigLoader loader;
    private final Set<ResourcePath> rootDirectories;

    public static Builder builder() {
        return new Builder();
    }

    public static ResourcePropertiesService default_() {
        return ResourcePropertiesService.builder().build();
    }

    ResourcePropertiesService(String configFileName, Set<ResourcePath> rootDirectories, List<EditorConfig> defaultEditorConfigs, Cache cache2, EditorConfigLoader loader, boolean keepUnset) {
        this.rootDirectories = rootDirectories;
        this.defaultEditorConfigs = defaultEditorConfigs;
        this.loader = loader;
        this.configFileName = configFileName;
        this.cache = cache2;
        this.keepUnset = keepUnset;
    }

    public Cache getCache() {
        return this.cache;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public List<EditorConfig> getDefaultEditorConfigs() {
        return this.defaultEditorConfigs;
    }

    public EditorConfigLoader getLoader() {
        return this.loader;
    }

    public Set<ResourcePath> getRootDirectories() {
        return this.rootDirectories;
    }

    public ResourceProperties queryProperties(Resource resource) throws IOException {
        ResourceProperties.Builder result2 = ResourceProperties.builder();
        ArrayList<DirEditorConfigPair> editorConfigs = new ArrayList<DirEditorConfigPair>();
        boolean root = false;
        for (ResourcePath dir2 = resource.getParent(); dir2 != null && !root; root |= this.rootDirectories.contains(dir2), dir2 = dir2.getParent()) {
            Resource configFile2 = dir2.resolve(this.configFileName);
            if (!configFile2.exists()) continue;
            EditorConfig config = this.cache.get(configFile2, this.loader);
            result2.editorConfigFile(configFile2.getPath());
            root = config.isRoot();
            editorConfigs.add(new DirEditorConfigPair(configFile2.getParent(), config));
        }
        if (!this.defaultEditorConfigs.isEmpty()) {
            ResourcePath lastDir = editorConfigs.isEmpty() ? resource.getParent() : ((DirEditorConfigPair)editorConfigs.get(editorConfigs.size() - 1)).directory;
            for (EditorConfig ec : this.defaultEditorConfigs) {
                editorConfigs.add(new DirEditorConfigPair(lastDir, ec));
            }
        }
        int i2 = editorConfigs.size() - 1;
        while (i2 >= 0) {
            DirEditorConfigPair pair = (DirEditorConfigPair)editorConfigs.get(i2--);
            ResourcePath editorConfigDir = pair.directory;
            EditorConfig config = pair.editorConfig;
            Ec4jPath path = editorConfigDir.relativize(resource).getPath();
            List<Section> sections = config.getSections();
            for (Section section : sections) {
                if (!section.match(path)) continue;
                if (this.keepUnset) {
                    result2.properties(section.getProperties());
                    continue;
                }
                for (Property prop : section.getProperties().values()) {
                    if (prop.isUnset()) {
                        result2.removeProperty(prop);
                        continue;
                    }
                    result2.property(prop);
                }
            }
        }
        return result2.build();
    }

    private static class DirEditorConfigPair {
        private final ResourcePath directory;
        private final EditorConfig editorConfig;

        private DirEditorConfigPair(ResourcePath directory, EditorConfig editorConfig) {
            this.directory = directory;
            this.editorConfig = editorConfig;
        }
    }

    public static class Builder {
        private Cache cache = Cache.Caches.none();
        private String configFileName = ".editorconfig";
        private List<EditorConfig> defaultEditorConfigs = new ArrayList<EditorConfig>();
        private boolean keepUnset = false;
        private EditorConfigLoader loader = EditorConfigLoader.default_();
        private Set<ResourcePath> rootDirectories = new LinkedHashSet<ResourcePath>();

        public ResourcePropertiesService build() {
            Set<ResourcePath> useRootDirs = Collections.unmodifiableSet(this.rootDirectories);
            this.rootDirectories = null;
            List<EditorConfig> useDefaultEditorConfigs = Collections.unmodifiableList(this.defaultEditorConfigs);
            this.defaultEditorConfigs = null;
            return new ResourcePropertiesService(this.configFileName, useRootDirs, useDefaultEditorConfigs, this.cache, this.loader, this.keepUnset);
        }

        public Builder cache(Cache cache2) {
            this.cache = cache2;
            return this;
        }

        public Builder configFileName(String configFileName) {
            this.configFileName = configFileName;
            return this;
        }

        public Builder defaultEditorConfig(EditorConfig defaultEditorConfig) {
            this.defaultEditorConfigs.add(defaultEditorConfig);
            return this;
        }

        public Builder defaultEditorConfigs(Collection<EditorConfig> defaultEditorConfigs) {
            this.defaultEditorConfigs.addAll(defaultEditorConfigs);
            return this;
        }

        public Builder defaultEditorConfigs(EditorConfig ... defaultEditorConfigs) {
            for (EditorConfig defaultEditorConfig : defaultEditorConfigs) {
                this.defaultEditorConfigs.add(defaultEditorConfig);
            }
            return this;
        }

        public Builder keepUnset(boolean keepUnset) {
            this.keepUnset = keepUnset;
            return this;
        }

        public Builder loader(EditorConfigLoader loader) {
            this.loader = loader;
            return this;
        }

        public Builder rootDirectories(Collection<ResourcePath> rootDirectories) {
            this.rootDirectories.addAll(rootDirectories);
            return this;
        }

        public Builder rootDirectories(ResourcePath ... rootDirectories) {
            for (ResourcePath rootDirectory : rootDirectories) {
                this.rootDirectories.add(rootDirectory);
            }
            return this;
        }

        public Builder rootDirectory(ResourcePath rootDirectory) {
            this.rootDirectories.add(rootDirectory);
            return this;
        }
    }
}

